/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.modeladapter.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.timevale.esign.paas.esign.utils.JsonHelper;
import com.timevale.esign.paas.esign.utils.StringUtil;
import com.timevale.esign.paas.esign.utils.bean.Result;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.modeladapter.adapter.Adapter;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.ApiurlsModel;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.Oauth2Config;
import com.timevale.esign.paas.esign.utils.modeladapter.model.AbstractModelType;
import com.timevale.esign.paas.esign.utils.modeladapter.model.ModelFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GetOpenAPIUrl {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetOpenAPIUrl.class);
    private static final String OS = System.getProperty("os.name");
    private AbstractModelType[] models;

    public GetOpenAPIUrl(AbstractModelType[] models) {
        this.models = models;
    }

    public void getUrlInfo(String projId, String projSecret, String apisUrl) throws SuperException {
        String string = "https";
        if (Adapter.instance().getConfig() != null) {
            string = Adapter.instance().getConfig().getHttpType();
        }
        String string2 = "urls";
        if (StringUtil.isNull(string) || !string.equals("http")) {
            string = "https";
            string2 = "https_urls";
        }
        ApiurlsModel apiurlsModel = new ApiurlsModel();
        apiurlsModel.setChannel("jar1.0");
        apiurlsModel.setOs(OS);
        apiurlsModel.setVersion("1.0");
        apiurlsModel.setWifilist("");
        apiurlsModel.setProjectId(projId);
        apiurlsModel.setProjectSecret(projSecret);
        apiurlsModel.setHttpType(string);
        JsonObject jsonObject = Adapter.instance().submit(null, apiurlsModel);
        Result result = JsonHelper.fromJson(jsonObject, Result.class);
        if (0 != result.getErrCode()) {
            LOGGER.error("get url info from open api failed. errCode: {}", (Object)result.getErrCode());
            throw ErrorsDiscriptor.ExternalServiceTaken.e(result.getErrCode(), result.getMsg());
        }
        JsonArray jsonArray = jsonObject.get(string2).getAsJsonArray();
        if (null == jsonArray || 0 >= jsonArray.size()) {
            LOGGER.error("get url info from open api error. the return url list is empty.");
            throw ErrorsDiscriptor.ExternalService.e();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(256);
        for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
            JsonObject jsonObject2 = (JsonObject)jsonArray.get(i2);
            if (null == jsonObject2.get("urlKey") || null == jsonObject2.get("urlValue")) continue;
            hashMap.put(jsonObject2.get("urlKey").getAsString(), jsonObject2.get("urlValue").getAsString());
        }
        this.setModelType(hashMap);
        this.setTsaServers(jsonObject);
    }

    private void setTsaServers(JsonObject jsonObj) {
        if (!jsonObj.has("tsaServers")) {
            LOGGER.error("there is no tsa servers");
            return;
        }
        JsonArray jsonArray = jsonObj.get("tsaServers").getAsJsonArray();
        if (null == jsonArray || 0 >= jsonArray.size()) {
            LOGGER.error("get tsaServers info from open api error. the return tsaServers list is empty.");
            return;
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>(256);
        for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
            JsonObject jsonObject = (JsonObject)jsonArray.get(i2);
            if (null == jsonObject.get("issuer") || null == jsonObject.get("url")) continue;
            concurrentHashMap.put(jsonObject.get("issuer").getAsString(), jsonObject.get("url").getAsString());
        }
        Oauth2Config.setTSA_SERVERS_MAP(concurrentHashMap);
    }

    public void setModelType(Map<String, String> urlMapping) throws SuperException {
        for (AbstractModelType abstractModelType : this.models) {
            ModelFactory modelFactory = abstractModelType.factory();
            String string = urlMapping.get(modelFactory.getKey());
            if (null == string) {
                LOGGER.info("this api url is not exist. api:{}", (Object)modelFactory.getKey());
                modelFactory.setUrl(null);
                continue;
            }
            modelFactory.setUrl(string);
            LOGGER.debug("fatch config for key:{}", (Object)modelFactory.getKey());
            LOGGER.debug("fatch config for url:{}", (Object)string);
        }
    }
}

