/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.modeladapter.impl;

import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.modeladapter.adapter.ModelsInitializerConfig;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.ModelsSecurityAdapter;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.rpc.ProjectUrlsRpc;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.rpc.bean.InterfaceUrl;
import com.timevale.esign.paas.esign.utils.modeladapter.impl.rpc.bean.InterfaceUrlsOutput;
import com.timevale.esign.paas.esign.utils.modeladapter.model.AbstractModelType;
import com.timevale.esign.paas.esign.utils.modeladapter.model.ModelFactory;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RefreshModels {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshModels.class);

    public static <T extends Enum<T>> void refresh(Class<T> modelsEnumClass, ModelsInitializerConfig config) throws SuperException {
        ModelsSecurityAdapter modelsSecurityAdapter = ModelsSecurityAdapter.from(config.getSecurity());
        InterfaceUrlsOutput interfaceUrlsOutput = ProjectUrlsRpc.refresh(config.getUrl(), config.getUrlHttpConfig(), config.getProjectAccesser(), modelsSecurityAdapter.getJsonKey());
        config.getInitializing().initializing(interfaceUrlsOutput);
        List<InterfaceUrl> list = modelsSecurityAdapter.parseRpcOutput(interfaceUrlsOutput);
        if (null == list || list.isEmpty()) {
            LOGGER.error("get url info from open api error. the return url list is empty.");
            throw ErrorsDiscriptor.ForbiddenProjectAccess.e();
        }
        Map<String, String> map = RefreshModels.collect(list);
        RefreshModels.setModelType(map, modelsEnumClass);
    }

    private RefreshModels() {
    }

    private static Map<String, String> collect(List<InterfaceUrl> urls) {
        HashMap<String, String> hashMap = new HashMap<String, String>(256);
        for (InterfaceUrl interfaceUrl : urls) {
            if (StringUtils.isEmpty((String)interfaceUrl.getUrlKey()) || StringUtils.isEmpty((String)interfaceUrl.getUrlValue())) continue;
            hashMap.put(interfaceUrl.getUrlKey(), interfaceUrl.getUrlValue());
        }
        return hashMap;
    }

    private static <T extends Enum<T>> void setModelType(Map<String, String> urlMapping, Class<T> enumClass) throws SuperException {
        EnumSet<AbstractModelType> enumSet = EnumSet.allOf(enumClass);
        for (AbstractModelType abstractModelType : enumSet) {
            ModelFactory modelFactory = abstractModelType.factory();
            String string = urlMapping.get(modelFactory.getKey());
            if (null == string) {
                LOGGER.info("this api url is not exist. api:{}", (Object)modelFactory.getKey());
                modelFactory.setUrl(null);
                continue;
            }
            modelFactory.setUrl(string);
            LOGGER.debug("fatch config for key:{}", (Object)modelFactory.getKey());
            LOGGER.debug("fatch config for url:{}", (Object)string);
        }
    }
}

