/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.network.request;

import com.timevale.esign.paas.esign.utils.JsonHelper;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.httpclient.HttpConfigT;
import com.timevale.esign.paas.esign.utils.httpclient.HttpDeleteBody;
import com.timevale.esign.paas.esign.utils.network.NtmExecutor;
import com.timevale.esign.paas.esign.utils.network.impl.http.NtmHttpEntityExecutor;
import com.timevale.esign.paas.esign.utils.network.impl.http.NtmHttpExecutor;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtmHttpRequest<T> {
    private HttpEntity entity;
    private HttpConfigT<T> httpConfigT;
    private String url;
    private static final Logger LOGGER = LoggerFactory.getLogger(NtmHttpRequest.class);

    public NtmHttpRequest(String url, HttpConfigT<T> httpConfigT) {
        this.httpConfigT = httpConfigT;
        this.url = url;
    }

    public HttpConfigT<T> httpConfig() {
        return this.httpConfigT;
    }

    public NtmExecutor<T> executorForPost() {
        HttpPost httpPost = new HttpPost(this.url);
        httpPost.setEntity(this.entity);
        return new NtmHttpEntityExecutor<T>((HttpEntityEnclosingRequestBase)httpPost, this.httpConfigT);
    }

    public NtmExecutor<T> executorForPut() {
        HttpPut httpPut = new HttpPut(this.url);
        httpPut.setEntity(this.entity);
        return new NtmHttpEntityExecutor<T>((HttpEntityEnclosingRequestBase)httpPut, this.httpConfigT);
    }

    public NtmExecutor<T> executorForDelete() {
        HttpDeleteBody httpDeleteBody = new HttpDeleteBody(this.url);
        httpDeleteBody.setEntity(this.entity);
        return new NtmHttpEntityExecutor<T>(httpDeleteBody, this.httpConfigT);
    }

    public NtmExecutor<T> executorForGet() {
        HttpGet httpGet = new HttpGet(this.url);
        return new NtmHttpExecutor<T>((HttpUriRequest)httpGet, this.httpConfigT);
    }

    public NtmHttpRequest<T> entity(InputStream inputStream, ContentType contentType) {
        this.entity = new InputStreamEntity(inputStream, contentType);
        return this;
    }

    public NtmHttpRequest<T> entity(InputStream inputStream) {
        return this.entity((Object)inputStream, ContentType.APPLICATION_OCTET_STREAM);
    }

    public NtmHttpRequest<T> entity(byte[] bytes, ContentType contentType) {
        this.entity = new ByteArrayEntity(bytes, contentType);
        return this;
    }

    public NtmHttpRequest<T> entity(byte[] bytes) {
        return this.entity((Object)bytes, ContentType.APPLICATION_OCTET_STREAM);
    }

    public NtmHttpRequest<T> entity(String data, ContentType contentType) throws SuperException {
        try {
            return this.entity((Object)data.getBytes(this.httpConfigT.getEncoding()), contentType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.error("unsupport encoding.", (Throwable)unsupportedEncodingException);
            throw ErrorsDiscriptor.UnsupportCharset.e(unsupportedEncodingException, this.httpConfigT.getEncoding());
        }
    }

    public NtmHttpRequest<T> entity(String data) throws SuperException {
        return this.entity((Object)data, ContentType.TEXT_PLAIN);
    }

    public <ET> NtmHttpRequest<T> entity(ET entity, ContentType contentType) throws SuperException {
        return this.entity((ET)JsonHelper.toJson(entity), contentType);
    }

    public <ET> NtmHttpRequest<T> entity(ET entity) throws SuperException {
        return this.entity(entity, ContentType.APPLICATION_JSON);
    }
}

