/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.reflect;

import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClassUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassUtil.class);

    public static <T> T newInstance(Class<T> cls) throws SuperException {
        try {
            T t2 = cls.newInstance();
            return t2;
        }
        catch (Exception exception) {
            LOGGER.error("create instance for controller failed. class:{}, loader:{}", cls.getClass(), (Object)cls.getClassLoader());
            throw ErrorsDiscriptor.ClassInstantiation.e(exception);
        }
    }

    public static <T> T newInstance(String className) throws SuperException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.error("load class for controller failed. class:{}", (Object)className);
            throw ErrorsDiscriptor.ClassUnmatch.e(classNotFoundException, className);
        }
        Object obj = ClassUtil.newInstance(clazz);
        return (T)obj;
    }

    public static <T> T newInstance(String className, Class<T> assignFrom) throws SuperException {
        T t2 = ClassUtil.newInstance(className);
        if (!assignFrom.isAssignableFrom(t2.getClass())) {
            LOGGER.error("the class not inherit from interface. class:{}", (Object)className);
            throw ErrorsDiscriptor.ClassUnmatchSpec.e(assignFrom.getName(), t2.getClass().getName());
        }
        return t2;
    }
}

