/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.security.cipher.impl.sign.rsa;

import com.timevale.esign.paas.esign.utils.coding.Coder;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.security.RSAKeyUtil;
import com.timevale.esign.paas.esign.utils.security.cipher.impl.ISimSignerProvider;
import com.timevale.esign.paas.esign.utils.security.cipher.impl.cipher.rsa.RSACipherProvider;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSASignerProvider
implements ISimSignerProvider {
    private byte[] key;
    private Signature signature;
    private String asymmetricAlgorithm;
    private static final Logger LOGGER = LoggerFactory.getLogger(RSACipherProvider.class);

    public RSASignerProvider(String asymmetricAlgorithm, String algorithmFully) throws SuperException {
        this.asymmetricAlgorithm = asymmetricAlgorithm;
        this.signature = this.createSignature(algorithmFully);
    }

    @Override
    public ISimSignerProvider init(String key) throws SuperException {
        String string = RSAKeyUtil.preParseRsaKey(key);
        return this.init(Coder.BASE64.decode(string));
    }

    @Override
    public ISimSignerProvider init(byte[] key) throws SuperException {
        this.key = key;
        return this;
    }

    @Override
    public byte[] sign(byte[] data) throws SuperException {
        this.initSign(this.signature, this.key);
        try {
            this.signature.update(data);
            return this.signature.sign();
        }
        catch (SignatureException signatureException) {
            LOGGER.error("sign failed.", (Throwable)signatureException);
            throw ErrorsDiscriptor.FailureCipherSign.e(signatureException);
        }
    }

    @Override
    public boolean verify(byte[] data, byte[] signatureData) throws SuperException {
        this.initVerify(this.signature, this.key);
        try {
            this.signature.update(data);
            return this.signature.verify(signatureData);
        }
        catch (SignatureException signatureException) {
            LOGGER.error("verify failed.", (Throwable)signatureException);
            throw ErrorsDiscriptor.FailureCipherVerify.e(signatureException);
        }
    }

    private void initSign(Signature signature, byte[] key) throws SuperException {
        PrivateKey privateKey;
        KeyFactory keyFactory = this.createKeyFactory(this.asymmetricAlgorithm);
        try {
            privateKey = RSAKeyUtil.parsePrivateKey(keyFactory, key);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            LOGGER.error("invalid key spec to generate private key.", (Object)this.asymmetricAlgorithm);
            throw ErrorsDiscriptor.InvalidCipherKey.e(invalidKeySpecException);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.error("invalid cipher key.", (Throwable)invalidKeyException);
            throw ErrorsDiscriptor.InvalidCipherKey.e(invalidKeyException);
        }
    }

    private void initVerify(Signature signature, byte[] key) throws SuperException {
        PublicKey publicKey;
        KeyFactory keyFactory = this.createKeyFactory(this.asymmetricAlgorithm);
        try {
            publicKey = RSAKeyUtil.parsePublieKey(keyFactory, key);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            LOGGER.error("invalid key spec to generate pubilc key.", (Object)this.asymmetricAlgorithm);
            throw ErrorsDiscriptor.InvalidCipherKey.e();
        }
        try {
            signature.initVerify(publicKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            LOGGER.error("invalid cipher key.", (Throwable)invalidKeyException);
            throw ErrorsDiscriptor.InvalidCipherKey.e(invalidKeyException);
        }
    }

    private KeyFactory createKeyFactory(String algorithm) throws SuperException {
        try {
            return KeyFactory.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.error("invalid cipher algorithm to create key factory. alg:{}", (Object)algorithm);
            throw ErrorsDiscriptor.InvalidCipherAlgorithm.e();
        }
    }

    private Signature createSignature(String algorithm) throws SuperException {
        try {
            return Signature.getInstance(algorithm);
        }
        catch (Exception exception) {
            LOGGER.error("create sitnature failed. algorithm:{}", (Object)algorithm);
            LOGGER.error("exception:", (Throwable)exception);
            throw ErrorsDiscriptor.InvalidCipherAlgorithm.e(exception);
        }
    }
}

