/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractMultiset;
import com.timevale.esign.paas.guava.common.collect.BoundType;
import com.timevale.esign.paas.guava.common.collect.Multiset;
import com.timevale.esign.paas.guava.common.collect.Multisets;
import com.timevale.esign.paas.guava.common.collect.SortedMultiset;
import com.timevale.esign.paas.guava.common.collect.SortedMultisets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

@GwtCompatible
abstract class AbstractSortedMultiset<E>
extends AbstractMultiset<E>
implements SortedMultiset<E> {
    final Comparator<? super E> comparator;
    private transient SortedMultiset<E> descendingMultiset;

    AbstractSortedMultiset(Comparator<? super E> comparator) {
        this.comparator = Preconditions.checkNotNull(comparator);
    }

    @Override
    public SortedSet<E> elementSet() {
        return (SortedSet)super.elementSet();
    }

    @Override
    SortedSet<E> createElementSet() {
        return new SortedMultisets.ElementSet<E>(){

            @Override
            SortedMultiset<E> multiset() {
                return AbstractSortedMultiset.this;
            }
        };
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        Iterator iterator = this.entryIterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        Iterator<Multiset.Entry<E>> iterator = this.descendingEntryIterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public Multiset.Entry<E> pollFirstEntry() {
        Iterator iterator = this.entryIterator();
        if (iterator.hasNext()) {
            Multiset.Entry entry = iterator.next();
            entry = Multisets.immutableEntry(entry.getElement(), entry.getCount());
            iterator.remove();
            return entry;
        }
        return null;
    }

    @Override
    public Multiset.Entry<E> pollLastEntry() {
        Iterator<Multiset.Entry<E>> iterator = this.descendingEntryIterator();
        if (iterator.hasNext()) {
            Multiset.Entry<E> entry = iterator.next();
            entry = Multisets.immutableEntry(entry.getElement(), entry.getCount());
            iterator.remove();
            return entry;
        }
        return null;
    }

    @Override
    public SortedMultiset<E> subMultiset(E fromElement, BoundType fromBoundType, E toElement, BoundType toBoundType) {
        return this.tailMultiset(fromElement, fromBoundType).headMultiset(toElement, toBoundType);
    }

    abstract Iterator<Multiset.Entry<E>> descendingEntryIterator();

    Iterator<E> descendingIterator() {
        return Multisets.iteratorImpl(this.descendingMultiset());
    }

    @Override
    public SortedMultiset<E> descendingMultiset() {
        SortedMultiset<E> sortedMultiset = this.descendingMultiset;
        return sortedMultiset == null ? (this.descendingMultiset = this.createDescendingMultiset()) : sortedMultiset;
    }

    SortedMultiset<E> createDescendingMultiset() {
        return new SortedMultisets.DescendingMultiset<E>(){

            @Override
            SortedMultiset<E> forwardMultiset() {
                return AbstractSortedMultiset.this;
            }

            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                return AbstractSortedMultiset.this.descendingEntryIterator();
            }

            @Override
            public Iterator<E> iterator() {
                return AbstractSortedMultiset.this.descendingIterator();
            }
        };
    }
}

