/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.EmptyImmutableMap;
import com.timevale.esign.paas.guava.common.collect.ImmutableCollection;
import com.timevale.esign.paas.guava.common.collect.ImmutableSet;
import com.timevale.esign.paas.guava.common.collect.ImmutableSortedMap;
import com.timevale.esign.paas.guava.common.collect.Iterables;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.Maps;
import com.timevale.esign.paas.guava.common.collect.RegularImmutableMap;
import com.timevale.esign.paas.guava.common.collect.SingletonImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMap<K, V>
implements Serializable,
Map<K, V> {
    public static <K, V> ImmutableMap<K, V> of() {
        return EmptyImmutableMap.INSTANCE;
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        return new SingletonImmutableMap<K, V>(Preconditions.checkNotNull(k1), Preconditions.checkNotNull(v1));
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2));
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3));
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4));
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return Maps.immutableEntry(Preconditions.checkNotNull(key, "null key"), Preconditions.checkNotNull(value, "null value"));
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Map.Entry[] entryArray;
        if (map instanceof ImmutableMap && !(map instanceof ImmutableSortedMap) && !(entryArray = (Map.Entry[])map).isPartialView()) {
            return entryArray;
        }
        entryArray = map.entrySet().toArray(new Map.Entry[0]);
        switch (entryArray.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return new SingletonImmutableMap(ImmutableMap.entryOf(entryArray[0].getKey(), entryArray[0].getValue()));
            }
        }
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Object k2 = entryArray[i2].getKey();
            Object v2 = entryArray[i2].getValue();
            entryArray[i2] = ImmutableMap.entryOf(k2, v2);
        }
        return new RegularImmutableMap(entryArray);
    }

    ImmutableMap() {
    }

    @Override
    public final V put(K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return this.get(key) != null;
    }

    @Override
    public abstract boolean containsValue(@Nullable Object var1);

    @Override
    public abstract V get(@Nullable Object var1);

    @Override
    public abstract ImmutableSet<Map.Entry<K, V>> entrySet();

    @Override
    public abstract ImmutableSet<K> keySet();

    @Override
    public abstract ImmutableCollection<V> values();

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((ImmutableSet)this.entrySet()).equals(map.entrySet());
        }
        return false;
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return ((ImmutableSet)this.entrySet()).hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    Object writeReplace() {
        return new SerializedForm(this);
    }

    static class SerializedForm
    implements Serializable {
        private final Object[] keys;
        private final Object[] values;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, ?> map) {
            this.keys = new Object[map.size()];
            this.values = new Object[map.size()];
            int n2 = 0;
            for (Map.Entry entry : map.entrySet()) {
                this.keys[n2] = entry.getKey();
                this.values[n2] = entry.getValue();
                ++n2;
            }
        }

        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>();
            return this.createMap(builder);
        }

        Object createMap(Builder<Object, Object> builder) {
            for (int i2 = 0; i2 < this.keys.length; ++i2) {
                builder.put(this.keys[i2], this.values[i2]);
            }
            return builder.build();
        }
    }

    public static class Builder<K, V> {
        final ArrayList<Map.Entry<K, V>> entries = Lists.newArrayList();

        public Builder<K, V> put(K key, V value) {
            this.entries.add(ImmutableMap.entryOf(key, value));
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            this.entries.ensureCapacity(this.entries.size() + map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public ImmutableMap<K, V> build() {
            return Builder.fromEntryList(this.entries);
        }

        private static <K, V> ImmutableMap<K, V> fromEntryList(List<Map.Entry<K, V>> entries) {
            int n2 = entries.size();
            switch (n2) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    return new SingletonImmutableMap<K, V>(Iterables.getOnlyElement(entries));
                }
            }
            Map.Entry[] entryArray = entries.toArray(new Map.Entry[entries.size()]);
            return new RegularImmutableMap(entryArray);
        }
    }
}

