/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.EmptyImmutableMultiset;
import com.timevale.esign.paas.guava.common.collect.ImmutableCollection;
import com.timevale.esign.paas.guava.common.collect.ImmutableMap;
import com.timevale.esign.paas.guava.common.collect.ImmutableSet;
import com.timevale.esign.paas.guava.common.collect.Iterators;
import com.timevale.esign.paas.guava.common.collect.LinkedHashMultiset;
import com.timevale.esign.paas.guava.common.collect.Multiset;
import com.timevale.esign.paas.guava.common.collect.Multisets;
import com.timevale.esign.paas.guava.common.collect.ObjectArrays;
import com.timevale.esign.paas.guava.common.collect.RegularImmutableMultiset;
import com.timevale.esign.paas.guava.common.collect.Sets;
import com.timevale.esign.paas.guava.common.collect.UnmodifiableIterator;
import com.timevale.esign.paas.guava.common.primitives.Ints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true)
public abstract class ImmutableMultiset<E>
extends ImmutableCollection<E>
implements Multiset<E> {
    private transient ImmutableSet<Multiset.Entry<E>> entrySet;

    public static <E> ImmutableMultiset<E> of() {
        return EmptyImmutableMultiset.INSTANCE;
    }

    public static <E> ImmutableMultiset<E> of(E element) {
        return ImmutableMultiset.copyOfInternal(element);
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2) {
        return ImmutableMultiset.copyOfInternal(e1, e2);
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3) {
        return ImmutableMultiset.copyOfInternal(e1, e2, e3);
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableMultiset.copyOfInternal(e1, e2, e3, e4);
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableMultiset.copyOfInternal(e1, e2, e3, e4, e5);
    }

    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        int n2 = others.length + 6;
        ArrayList arrayList = new ArrayList(n2);
        Collections.addAll(arrayList, e1, e2, e3, e4, e5, e6);
        Collections.addAll(arrayList, others);
        return ImmutableMultiset.copyOf(arrayList);
    }

    @Deprecated
    public static <E> ImmutableMultiset<E> of(E[] elements) {
        return ImmutableMultiset.copyOf(Arrays.asList(elements));
    }

    public static <E> ImmutableMultiset<E> copyOf(E[] elements) {
        return ImmutableMultiset.copyOf(Arrays.asList(elements));
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterable<? extends E> elements) {
        Multiset<Object> multiset;
        if (elements instanceof ImmutableMultiset && !(multiset = (ImmutableMultiset)elements).isPartialView()) {
            return multiset;
        }
        multiset = elements instanceof Multiset ? Multisets.cast(elements) : LinkedHashMultiset.create(elements);
        return ImmutableMultiset.copyOfInternal(multiset);
    }

    private static <E> ImmutableMultiset<E> copyOfInternal(E ... elements) {
        return ImmutableMultiset.copyOf(Arrays.asList(elements));
    }

    private static <E> ImmutableMultiset<E> copyOfInternal(Multiset<? extends E> multiset) {
        long l2 = 0L;
        ImmutableMap.Builder<E, Integer> builder = ImmutableMap.builder();
        for (Multiset.Entry<E> entry : multiset.entrySet()) {
            int n2 = entry.getCount();
            if (n2 <= 0) continue;
            builder.put(entry.getElement(), n2);
            l2 += (long)n2;
        }
        if (l2 == 0L) {
            return ImmutableMultiset.of();
        }
        return new RegularImmutableMultiset(builder.build(), Ints.saturatedCast(l2));
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterator<? extends E> elements) {
        LinkedHashMultiset linkedHashMultiset = LinkedHashMultiset.create();
        Iterators.addAll(linkedHashMultiset, elements);
        return ImmutableMultiset.copyOfInternal(linkedHashMultiset);
    }

    ImmutableMultiset() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        final UnmodifiableIterator<Multiset.Entry<E>> unmodifiableIterator = this.entryIterator();
        return new UnmodifiableIterator<E>(){
            int remaining;
            E element;

            @Override
            public boolean hasNext() {
                return this.remaining > 0 || unmodifiableIterator.hasNext();
            }

            @Override
            public E next() {
                if (this.remaining <= 0) {
                    Multiset.Entry entry = (Multiset.Entry)unmodifiableIterator.next();
                    this.element = entry.getElement();
                    this.remaining = entry.getCount();
                }
                --this.remaining;
                return this.element;
            }
        };
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.count(object) > 0;
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        return this.elementSet().containsAll(targets);
    }

    @Override
    public final int add(E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int setCount(E element, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean setCount(E element, int oldCount, int newCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multiset) {
            Multiset multiset = (Multiset)object;
            if (this.size() != multiset.size()) {
                return false;
            }
            for (Multiset.Entry entry : multiset.entrySet()) {
                if (this.count(entry.getElement()) == entry.getCount()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    @Override
    public String toString() {
        return this.entrySet().toString();
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        ImmutableSet<Multiset.Entry<Multiset.Entry<E>>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = this.createEntrySet()) : immutableSet;
    }

    abstract UnmodifiableIterator<Multiset.Entry<E>> entryIterator();

    abstract int distinctElements();

    ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet(this);
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        final Multiset<E> contents;

        public Builder() {
            this(LinkedHashMultiset.create());
        }

        Builder(Multiset<E> contents) {
            this.contents = contents;
        }

        @Override
        public Builder<E> add(E element) {
            this.contents.add(Preconditions.checkNotNull(element));
            return this;
        }

        public Builder<E> addCopies(E element, int occurrences) {
            this.contents.add(Preconditions.checkNotNull(element), occurrences);
            return this;
        }

        public Builder<E> setCount(E element, int count) {
            this.contents.setCount(Preconditions.checkNotNull(element), count);
            return this;
        }

        @Override
        public Builder<E> add(E ... elements) {
            super.add(elements);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> elements) {
            if (elements instanceof Multiset) {
                Multiset<E> multiset = Multisets.cast(elements);
                for (Multiset.Entry<E> entry : multiset.entrySet()) {
                    this.addCopies(entry.getElement(), entry.getCount());
                }
            } else {
                super.addAll(elements);
            }
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        @Override
        public ImmutableMultiset<E> build() {
            return ImmutableMultiset.copyOf(this.contents);
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        final int[] counts;
        private static final long serialVersionUID = 0L;

        SerializedForm(Multiset<?> multiset) {
            int n2 = multiset.entrySet().size();
            this.elements = new Object[n2];
            this.counts = new int[n2];
            int n3 = 0;
            for (Multiset.Entry<?> entry : multiset.entrySet()) {
                this.elements[n3] = entry.getElement();
                this.counts[n3] = entry.getCount();
                ++n3;
            }
        }

        Object readResolve() {
            LinkedHashMultiset linkedHashMultiset = LinkedHashMultiset.create(this.elements.length);
            for (int i2 = 0; i2 < this.elements.length; ++i2) {
                linkedHashMultiset.add(this.elements[i2], this.counts[i2]);
            }
            return ImmutableMultiset.copyOf(linkedHashMultiset);
        }
    }

    static class EntrySet<E>
    extends ImmutableSet<Multiset.Entry<E>> {
        final transient ImmutableMultiset<E> multiset;
        private static final long serialVersionUID = 0L;

        public EntrySet(ImmutableMultiset<E> multiset) {
            this.multiset = multiset;
        }

        @Override
        public UnmodifiableIterator<Multiset.Entry<E>> iterator() {
            return this.multiset.entryIterator();
        }

        @Override
        public int size() {
            return this.multiset.distinctElements();
        }

        @Override
        boolean isPartialView() {
            return this.multiset.isPartialView();
        }

        @Override
        public boolean contains(Object o2) {
            if (o2 instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)o2;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int n2 = this.multiset.count(entry.getElement());
                return n2 == entry.getCount();
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            return this.toArray(objectArray);
        }

        @Override
        public <T> T[] toArray(T[] other) {
            int n2 = this.size();
            if (other.length < n2) {
                other = ObjectArrays.newArray(other, n2);
            } else if (other.length > n2) {
                other[n2] = null;
            }
            T[] TArray = other;
            int n3 = 0;
            for (Multiset.Entry entry : this) {
                TArray[n3++] = entry;
            }
            return other;
        }

        @Override
        public int hashCode() {
            return this.multiset.hashCode();
        }

        @Override
        Object writeReplace() {
            return new EntrySetSerializedForm<E>(this.multiset);
        }

        static class EntrySetSerializedForm<E>
        implements Serializable {
            final ImmutableMultiset<E> multiset;

            EntrySetSerializedForm(ImmutableMultiset<E> multiset) {
                this.multiset = multiset;
            }

            Object readResolve() {
                return this.multiset.entrySet();
            }
        }
    }
}

