/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.annotations.GwtIncompatible;
import com.timevale.esign.paas.guava.common.base.Equivalence;
import com.timevale.esign.paas.guava.common.base.Equivalences;
import com.timevale.esign.paas.guava.common.base.Function;
import com.timevale.esign.paas.guava.common.base.Joiner;
import com.timevale.esign.paas.guava.common.base.Objects;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.base.Predicate;
import com.timevale.esign.paas.guava.common.base.Predicates;
import com.timevale.esign.paas.guava.common.collect.AbstractMapEntry;
import com.timevale.esign.paas.guava.common.collect.BiMap;
import com.timevale.esign.paas.guava.common.collect.Collections2;
import com.timevale.esign.paas.guava.common.collect.ForwardingCollection;
import com.timevale.esign.paas.guava.common.collect.ForwardingIterator;
import com.timevale.esign.paas.guava.common.collect.ForwardingMap;
import com.timevale.esign.paas.guava.common.collect.ForwardingMapEntry;
import com.timevale.esign.paas.guava.common.collect.ForwardingSet;
import com.timevale.esign.paas.guava.common.collect.ImmutableEntry;
import com.timevale.esign.paas.guava.common.collect.ImmutableMap;
import com.timevale.esign.paas.guava.common.collect.Iterators;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.MapDifference;
import com.timevale.esign.paas.guava.common.collect.MapMaker;
import com.timevale.esign.paas.guava.common.collect.Sets;
import com.timevale.esign.paas.guava.common.collect.Synchronized;
import com.timevale.esign.paas.guava.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class Maps {
    static final Joiner.MapJoiner STANDARD_JOINER = Collections2.STANDARD_JOINER.withKeyValueSeparator("=");

    private Maps() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(Maps.capacity(expectedSize));
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            Preconditions.checkArgument(expectedSize >= 0);
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return expectedSize + expectedSize / 3;
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<? extends K, ? extends V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new MapMaker().makeMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(SortedMap<K, ? extends V> map) {
        return new TreeMap<K, V>(map);
    }

    public static <C, K extends C, V> TreeMap<K, V> newTreeMap(@Nullable Comparator<C> comparator) {
        return new TreeMap(comparator);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Class<K> type) {
        return new EnumMap(Preconditions.checkNotNull(type));
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Map<K, ? extends V> map) {
        return new EnumMap<K, V>(map);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <K, V> BiMap<K, V> synchronizedBiMap(BiMap<K, V> bimap) {
        return Synchronized.biMap(bimap, null);
    }

    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        return Maps.difference(left, right, Equivalences.equals());
    }

    @Beta
    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right, Equivalence<? super V> valueEquivalence) {
        Preconditions.checkNotNull(valueEquivalence);
        HashMap<K, V> hashMap = Maps.newHashMap();
        HashMap<K, V> hashMap2 = new HashMap<K, V>(right);
        HashMap<K, V> hashMap3 = Maps.newHashMap();
        HashMap<K, MapDifference.ValueDifference<V>> hashMap4 = Maps.newHashMap();
        boolean bl2 = true;
        for (Map.Entry<K, V> entry : left.entrySet()) {
            K k2 = entry.getKey();
            V v2 = entry.getValue();
            if (right.containsKey(k2)) {
                Object v3 = hashMap2.remove(k2);
                if (valueEquivalence.equivalent(v2, v3)) {
                    hashMap3.put(k2, v2);
                    continue;
                }
                bl2 = false;
                hashMap4.put(k2, ValueDifferenceImpl.create(v2, v3));
                continue;
            }
            bl2 = false;
            hashMap.put(k2, v2);
        }
        boolean bl3 = bl2 && hashMap2.isEmpty();
        return Maps.mapDifference(bl3, hashMap, hashMap2, hashMap3, hashMap4);
    }

    private static <K, V> MapDifference<K, V> mapDifference(boolean areEqual, Map<K, V> onlyOnLeft, Map<K, V> onlyOnRight, Map<K, V> onBoth, Map<K, MapDifference.ValueDifference<V>> differences) {
        return new MapDifferenceImpl<K, V>(areEqual, Collections.unmodifiableMap(onlyOnLeft), Collections.unmodifiableMap(onlyOnRight), Collections.unmodifiableMap(onBoth), Collections.unmodifiableMap(differences));
    }

    public static <K, V> ImmutableMap<K, V> uniqueIndex(Iterable<V> values, Function<? super V, K> keyFunction) {
        return Maps.uniqueIndex(values.iterator(), keyFunction);
    }

    @Deprecated
    @Beta
    public static <K, V, I extends Object & Iterator<V>> ImmutableMap<K, V> uniqueIndex(I values, Function<? super V, K> keyFunction) {
        Iterable iterable = (Iterable)Preconditions.checkNotNull(values);
        return Maps.uniqueIndex(iterable, keyFunction);
    }

    public static <K, V> ImmutableMap<K, V> uniqueIndex(Iterator<V> values, Function<? super V, K> keyFunction) {
        Preconditions.checkNotNull(keyFunction);
        ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();
        while (values.hasNext()) {
            V v2 = values.next();
            builder.put(keyFunction.apply(v2), v2);
        }
        return builder.build();
    }

    @GwtIncompatible(value="java.util.Properties")
    public static ImmutableMap<String, String> fromProperties(Properties properties) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            builder.put(string, properties.getProperty(string));
        }
        return builder.build();
    }

    @GwtCompatible(serializable=true)
    public static <K, V> Map.Entry<K, V> immutableEntry(@Nullable K key, @Nullable V value) {
        return new ImmutableEntry<K, V>(key, value);
    }

    static <K, V> Set<Map.Entry<K, V>> unmodifiableEntrySet(Set<Map.Entry<K, V>> entrySet) {
        return new UnmodifiableEntrySet<K, V>(Collections.unmodifiableSet(entrySet));
    }

    static <K, V> Map.Entry<K, V> unmodifiableEntry(final Map.Entry<K, V> entry) {
        Preconditions.checkNotNull(entry);
        return new AbstractMapEntry<K, V>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public V getValue() {
                return entry.getValue();
            }
        };
    }

    public static <K, V> BiMap<K, V> unmodifiableBiMap(BiMap<? extends K, ? extends V> bimap) {
        return new UnmodifiableBiMap<K, V>(bimap, null);
    }

    public static <K, V1, V2> Map<K, V2> transformValues(Map<K, V1> fromMap, final Function<? super V1, V2> function) {
        Preconditions.checkNotNull(function);
        EntryTransformer entryTransformer = new EntryTransformer<K, V1, V2>(){

            @Override
            public V2 transformEntry(K key, V1 value) {
                return function.apply(value);
            }
        };
        return Maps.transformEntries(fromMap, entryTransformer);
    }

    public static <K, V1, V2> Map<K, V2> transformEntries(Map<K, V1> fromMap, EntryTransformer<? super K, ? super V1, V2> transformer) {
        return new TransformedEntriesMap<K, V1, V2>(fromMap, transformer);
    }

    public static <K, V> Map<K, V> filterKeys(Map<K, V> unfiltered, final Predicate<? super K> keyPredicate) {
        Preconditions.checkNotNull(keyPredicate);
        Predicate predicate = new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> input) {
                return keyPredicate.apply(input.getKey());
            }
        };
        return unfiltered instanceof AbstractFilteredMap ? Maps.filterFiltered((AbstractFilteredMap)unfiltered, predicate) : new FilteredKeyMap<K, V>(Preconditions.checkNotNull(unfiltered), keyPredicate, predicate);
    }

    public static <K, V> Map<K, V> filterValues(Map<K, V> unfiltered, final Predicate<? super V> valuePredicate) {
        Preconditions.checkNotNull(valuePredicate);
        Predicate predicate = new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> input) {
                return valuePredicate.apply(input.getValue());
            }
        };
        return Maps.filterEntries(unfiltered, predicate);
    }

    public static <K, V> Map<K, V> filterEntries(Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        Preconditions.checkNotNull(entryPredicate);
        return unfiltered instanceof AbstractFilteredMap ? Maps.filterFiltered((AbstractFilteredMap)unfiltered, entryPredicate) : new FilteredEntryMap<K, V>(Preconditions.checkNotNull(unfiltered), entryPredicate);
    }

    private static <K, V> Map<K, V> filterFiltered(AbstractFilteredMap<K, V> map, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        Predicate<? super Map.Entry<K, V>> predicate = Predicates.and(map.predicate, entryPredicate);
        return new FilteredEntryMap(map.unfiltered, predicate);
    }

    static <V> V safeGet(Map<?, V> map, Object key) {
        try {
            return map.get(key);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    static boolean safeContainsKey(Map<?, ?> map, Object key) {
        try {
            return map.containsKey(key);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    static <K, V> boolean containsEntryImpl(Collection<Map.Entry<K, V>> c2, Object o2) {
        if (!(o2 instanceof Map.Entry)) {
            return false;
        }
        return c2.contains(Maps.unmodifiableEntry((Map.Entry)o2));
    }

    static <K, V> boolean removeEntryImpl(Collection<Map.Entry<K, V>> c2, Object o2) {
        if (!(o2 instanceof Map.Entry)) {
            return false;
        }
        return c2.remove(Maps.unmodifiableEntry((Map.Entry)o2));
    }

    static boolean equalsImpl(Map<?, ?> map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return ((Object)map.entrySet()).equals(map2.entrySet());
        }
        return false;
    }

    static int hashCodeImpl(Map<?, ?> map) {
        return Sets.hashCodeImpl(map.entrySet());
    }

    static String toStringImpl(Map<?, ?> map) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(map.size()).append('{');
        STANDARD_JOINER.appendTo(stringBuilder, map);
        return stringBuilder.append('}').toString();
    }

    static <K, V> void putAllImpl(Map<K, V> self, Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            self.put(entry.getKey(), entry.getValue());
        }
    }

    static boolean containsKeyImpl(Map<?, ?> map, @Nullable Object key) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!Objects.equal(entry.getKey(), key)) continue;
            return true;
        }
        return false;
    }

    static boolean containsValueImpl(Map<?, ?> map, @Nullable Object value) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!Objects.equal(entry.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    static abstract class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        abstract Map<K, V> map();

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        @Override
        public boolean contains(Object o2) {
            if (o2 instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o2;
                Object k2 = entry.getKey();
                V v2 = this.map().get(k2);
                return Objects.equal(v2, entry.getValue()) && (v2 != null || this.map().containsKey(k2));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean remove(Object o2) {
            if (this.contains(o2)) {
                Map.Entry entry = (Map.Entry)o2;
                return this.map().keySet().remove(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            try {
                return super.removeAll(Preconditions.checkNotNull(c2));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                boolean bl2 = true;
                for (Object obj : c2) {
                    bl2 |= this.remove(obj);
                }
                return bl2;
            }
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            try {
                return super.retainAll(Preconditions.checkNotNull(c2));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet hashSet = Sets.newHashSetWithExpectedSize(c2.size());
                for (Object obj : c2) {
                    if (!this.contains(obj)) continue;
                    Map.Entry entry = (Map.Entry)obj;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().retainAll(hashSet);
            }
        }
    }

    static abstract class Values<K, V>
    extends AbstractCollection<V> {
        Values() {
        }

        abstract Map<K, V> map();

        @Override
        public Iterator<V> iterator() {
            return Iterators.transform(this.map().entrySet().iterator(), new Function<Map.Entry<K, V>, V>(){

                @Override
                public V apply(Map.Entry<K, V> entry) {
                    return entry.getValue();
                }
            });
        }

        @Override
        public boolean remove(Object o2) {
            try {
                return super.remove(o2);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!Objects.equal(o2, entry.getValue())) continue;
                    this.map().remove(entry.getKey());
                    return true;
                }
                return false;
            }
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            try {
                return super.removeAll(Preconditions.checkNotNull(c2));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet<K> hashSet = Sets.newHashSet();
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!c2.contains(entry.getValue())) continue;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().removeAll(hashSet);
            }
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            try {
                return super.retainAll(Preconditions.checkNotNull(c2));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet<K> hashSet = Sets.newHashSet();
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!c2.contains(entry.getValue())) continue;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().retainAll(hashSet);
            }
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean contains(@Nullable Object o2) {
            return this.map().containsValue(o2);
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }

    static abstract class KeySet<K, V>
    extends AbstractSet<K> {
        KeySet() {
        }

        abstract Map<K, V> map();

        @Override
        public Iterator<K> iterator() {
            return Iterators.transform(this.map().entrySet().iterator(), new Function<Map.Entry<K, V>, K>(){

                @Override
                public K apply(Map.Entry<K, V> entry) {
                    return entry.getKey();
                }
            });
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean contains(Object o2) {
            return this.map().containsKey(o2);
        }

        @Override
        public boolean remove(Object o2) {
            if (this.contains(o2)) {
                this.map().remove(o2);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            return super.removeAll(Preconditions.checkNotNull(c2));
        }

        @Override
        public void clear() {
            this.map().clear();
        }
    }

    @GwtCompatible
    static abstract class ImprovedAbstractMap<K, V>
    extends AbstractMap<K, V> {
        private Set<Map.Entry<K, V>> entrySet;
        private Set<K> keySet;
        private Collection<V> values;

        ImprovedAbstractMap() {
        }

        protected abstract Set<Map.Entry<K, V>> createEntrySet();

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> set = this.entrySet;
            if (set == null) {
                this.entrySet = set = this.createEntrySet();
            }
            return set;
        }

        @Override
        public Set<K> keySet() {
            Set<K> set = this.keySet;
            if (set == null) {
                this.keySet = new KeySet<K, V>(){

                    @Override
                    Map<K, V> map() {
                        return this;
                    }
                };
                return this.keySet;
            }
            return set;
        }

        @Override
        public Collection<V> values() {
            Collection<V> collection = this.values;
            if (collection == null) {
                this.values = new Values<K, V>(){

                    @Override
                    Map<K, V> map() {
                        return this;
                    }
                };
                return this.values;
            }
            return collection;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }
    }

    static class FilteredEntryMap<K, V>
    extends AbstractFilteredMap<K, V> {
        final Set<Map.Entry<K, V>> filteredEntrySet;
        Set<Map.Entry<K, V>> entrySet;
        Set<K> keySet;

        FilteredEntryMap(Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
            super(unfiltered, entryPredicate);
            this.filteredEntrySet = Sets.filter(unfiltered.entrySet(), this.predicate);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            EntrySet entrySet = this.entrySet;
            return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
        }

        @Override
        public Set<K> keySet() {
            KeySet keySet = this.keySet;
            return keySet == null ? (this.keySet = new KeySet()) : keySet;
        }

        private class KeySet
        extends AbstractSet<K> {
            private KeySet() {
            }

            @Override
            public Iterator<K> iterator() {
                final Iterator iterator = FilteredEntryMap.this.filteredEntrySet.iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((Map.Entry)iterator.next()).getKey();
                    }
                };
            }

            @Override
            public int size() {
                return FilteredEntryMap.this.filteredEntrySet.size();
            }

            @Override
            public void clear() {
                FilteredEntryMap.this.filteredEntrySet.clear();
            }

            @Override
            public boolean contains(Object o2) {
                return FilteredEntryMap.this.containsKey(o2);
            }

            @Override
            public boolean remove(Object o2) {
                if (FilteredEntryMap.this.containsKey(o2)) {
                    FilteredEntryMap.this.unfiltered.remove(o2);
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl2 = false;
                for (Object obj : collection) {
                    bl2 |= this.remove(obj);
                }
                return bl2;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl2 = false;
                Iterator iterator = FilteredEntryMap.this.unfiltered.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (collection.contains(entry.getKey()) || !FilteredEntryMap.this.predicate.apply(entry)) continue;
                    iterator.remove();
                    bl2 = true;
                }
                return bl2;
            }

            @Override
            public Object[] toArray() {
                return Lists.newArrayList(this.iterator()).toArray();
            }

            @Override
            public <T> T[] toArray(T[] array) {
                return Lists.newArrayList(this.iterator()).toArray(array);
            }
        }

        private class EntrySet
        extends ForwardingSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            protected Set<Map.Entry<K, V>> delegate() {
                return FilteredEntryMap.this.filteredEntrySet;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator iterator = FilteredEntryMap.this.filteredEntrySet.iterator();
                return new UnmodifiableIterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new ForwardingMapEntry<K, V>(){

                            @Override
                            protected Map.Entry<K, V> delegate() {
                                return entry;
                            }

                            @Override
                            public V setValue(V value) {
                                Preconditions.checkArgument(FilteredEntryMap.this.apply(entry.getKey(), value));
                                return super.setValue(value);
                            }
                        };
                    }
                };
            }
        }
    }

    private static class FilteredKeyMap<K, V>
    extends AbstractFilteredMap<K, V> {
        Predicate<? super K> keyPredicate;
        Set<Map.Entry<K, V>> entrySet;
        Set<K> keySet;

        FilteredKeyMap(Map<K, V> unfiltered, Predicate<? super K> keyPredicate, Predicate<Map.Entry<K, V>> entryPredicate) {
            super(unfiltered, entryPredicate);
            this.keyPredicate = keyPredicate;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Set<Map.Entry<K, V>> set = this.entrySet;
            return set == null ? (this.entrySet = Sets.filter(this.unfiltered.entrySet(), this.predicate)) : set;
        }

        @Override
        public Set<K> keySet() {
            Set<K> set = this.keySet;
            return set == null ? (this.keySet = Sets.filter(this.unfiltered.keySet(), this.keyPredicate)) : set;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.unfiltered.containsKey(key) && this.keyPredicate.apply(key);
        }
    }

    private static abstract class AbstractFilteredMap<K, V>
    extends AbstractMap<K, V> {
        final Map<K, V> unfiltered;
        final Predicate<? super Map.Entry<K, V>> predicate;
        Collection<V> values;

        AbstractFilteredMap(Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
            this.unfiltered = unfiltered;
            this.predicate = predicate;
        }

        boolean apply(Object key, V value) {
            Object object = key;
            return this.predicate.apply(Maps.immutableEntry(object, value));
        }

        @Override
        public V put(K key, V value) {
            Preconditions.checkArgument(this.apply(key, value));
            return this.unfiltered.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Preconditions.checkArgument(this.apply(entry.getKey(), entry.getValue()));
            }
            this.unfiltered.putAll(map);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.unfiltered.containsKey(key) && this.apply(key, this.unfiltered.get(key));
        }

        @Override
        public V get(Object key) {
            V v2 = this.unfiltered.get(key);
            return v2 != null && this.apply(key, v2) ? (V)v2 : null;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        @Override
        public V remove(Object key) {
            return this.containsKey(key) ? (V)this.unfiltered.remove(key) : null;
        }

        @Override
        public Collection<V> values() {
            Values values = this.values;
            return values == null ? (this.values = new Values()) : values;
        }

        class Values
        extends AbstractCollection<V> {
            Values() {
            }

            @Override
            public Iterator<V> iterator() {
                final Iterator iterator = AbstractFilteredMap.this.entrySet().iterator();
                return new UnmodifiableIterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public V next() {
                        return ((Map.Entry)iterator.next()).getValue();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractFilteredMap.this.entrySet().size();
            }

            @Override
            public void clear() {
                AbstractFilteredMap.this.entrySet().clear();
            }

            @Override
            public boolean isEmpty() {
                return AbstractFilteredMap.this.entrySet().isEmpty();
            }

            @Override
            public boolean remove(Object o2) {
                Iterator iterator = AbstractFilteredMap.this.unfiltered.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!Objects.equal(o2, entry.getValue()) || !AbstractFilteredMap.this.predicate.apply(entry)) continue;
                    iterator.remove();
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl2 = false;
                Iterator iterator = AbstractFilteredMap.this.unfiltered.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!collection.contains(entry.getValue()) || !AbstractFilteredMap.this.predicate.apply(entry)) continue;
                    iterator.remove();
                    bl2 = true;
                }
                return bl2;
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                Preconditions.checkNotNull(collection);
                boolean bl2 = false;
                Iterator iterator = AbstractFilteredMap.this.unfiltered.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (collection.contains(entry.getValue()) || !AbstractFilteredMap.this.predicate.apply(entry)) continue;
                    iterator.remove();
                    bl2 = true;
                }
                return bl2;
            }

            @Override
            public Object[] toArray() {
                return Lists.newArrayList(this.iterator()).toArray();
            }

            @Override
            public <T> T[] toArray(T[] array) {
                return Lists.newArrayList(this.iterator()).toArray(array);
            }
        }
    }

    static class TransformedEntriesMap<K, V1, V2>
    extends AbstractMap<K, V2> {
        final Map<K, V1> fromMap;
        final EntryTransformer<? super K, ? super V1, V2> transformer;
        Set<Map.Entry<K, V2>> entrySet;
        Collection<V2> values;

        TransformedEntriesMap(Map<K, V1> fromMap, EntryTransformer<? super K, ? super V1, V2> transformer) {
            this.fromMap = Preconditions.checkNotNull(fromMap);
            this.transformer = Preconditions.checkNotNull(transformer);
        }

        @Override
        public int size() {
            return this.fromMap.size();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.fromMap.containsKey(key);
        }

        @Override
        public V2 get(Object key) {
            V1 V1 = this.fromMap.get(key);
            return (V2)(V1 != null || this.fromMap.containsKey(key) ? this.transformer.transformEntry(key, V1) : null);
        }

        @Override
        public V2 remove(Object key) {
            return this.fromMap.containsKey(key) ? (V2)this.transformer.transformEntry((K)key, (V1)this.fromMap.remove(key)) : null;
        }

        @Override
        public void clear() {
            this.fromMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.fromMap.keySet();
        }

        @Override
        public Set<Map.Entry<K, V2>> entrySet() {
            EntrySet entrySet = this.entrySet;
            if (entrySet == null) {
                this.entrySet = entrySet = new EntrySet<K, V2>(){

                    @Override
                    Map<K, V2> map() {
                        return this;
                    }

                    @Override
                    public Iterator<Map.Entry<K, V2>> iterator() {
                        Iterator iterator = fromMap.entrySet().iterator();
                        return Iterators.transform(iterator, new Function<Map.Entry<K, V1>, Map.Entry<K, V2>>(){

                            @Override
                            public Map.Entry<K, V2> apply(Map.Entry<K, V1> entry) {
                                return Maps.immutableEntry(entry.getKey(), transformer.transformEntry(entry.getKey(), entry.getValue()));
                            }
                        });
                    }
                };
            }
            return entrySet;
        }

        @Override
        public Collection<V2> values() {
            Collection<V2> collection = this.values;
            if (collection == null) {
                this.values = new Values<K, V2>(){

                    @Override
                    Map<K, V2> map() {
                        return this;
                    }
                };
                return this.values;
            }
            return collection;
        }
    }

    public static interface EntryTransformer<K, V1, V2> {
        public V2 transformEntry(@Nullable K var1, @Nullable V1 var2);
    }

    private static class UnmodifiableBiMap<K, V>
    extends ForwardingMap<K, V>
    implements BiMap<K, V>,
    Serializable {
        final Map<K, V> unmodifiableMap;
        final BiMap<? extends K, ? extends V> delegate;
        transient BiMap<V, K> inverse;
        transient Set<V> values;
        private static final long serialVersionUID = 0L;

        UnmodifiableBiMap(BiMap<? extends K, ? extends V> delegate, @Nullable BiMap<V, K> inverse) {
            this.unmodifiableMap = Collections.unmodifiableMap(delegate);
            this.delegate = delegate;
            this.inverse = inverse;
        }

        @Override
        protected Map<K, V> delegate() {
            return this.unmodifiableMap;
        }

        @Override
        public V forcePut(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BiMap<V, K> inverse() {
            BiMap<K, V> biMap = this.inverse;
            return biMap == null ? (this.inverse = new UnmodifiableBiMap<V, K>(this.delegate.inverse(), this)) : biMap;
        }

        @Override
        public Set<V> values() {
            Set<V> set = this.values;
            return set == null ? (this.values = Collections.unmodifiableSet(this.delegate.values())) : set;
        }
    }

    static class UnmodifiableEntrySet<K, V>
    extends UnmodifiableEntries<K, V>
    implements Set<Map.Entry<K, V>> {
        UnmodifiableEntrySet(Set<Map.Entry<K, V>> entries) {
            super(entries);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return Sets.equalsImpl(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    static class UnmodifiableEntries<K, V>
    extends ForwardingCollection<Map.Entry<K, V>> {
        private final Collection<Map.Entry<K, V>> entries;

        UnmodifiableEntries(Collection<Map.Entry<K, V>> entries) {
            this.entries = entries;
        }

        @Override
        protected Collection<Map.Entry<K, V>> delegate() {
            return this.entries;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator iterator = super.iterator();
            return new ForwardingIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    return Maps.unmodifiableEntry((Map.Entry)super.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                protected Iterator<Map.Entry<K, V>> delegate() {
                    return iterator;
                }
            };
        }

        @Override
        public boolean add(Map.Entry<K, V> element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }
    }

    static class ValueDifferenceImpl<V>
    implements MapDifference.ValueDifference<V> {
        private final V left;
        private final V right;

        static <V> MapDifference.ValueDifference<V> create(@Nullable V left, @Nullable V right) {
            return new ValueDifferenceImpl<V>(left, right);
        }

        private ValueDifferenceImpl(@Nullable V left, @Nullable V right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public V leftValue() {
            return this.left;
        }

        @Override
        public V rightValue() {
            return this.right;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof MapDifference.ValueDifference) {
                MapDifference.ValueDifference valueDifference = (MapDifference.ValueDifference)object;
                return Objects.equal(this.left, valueDifference.leftValue()) && Objects.equal(this.right, valueDifference.rightValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.left, this.right);
        }

        public String toString() {
            return "(" + this.left + ", " + this.right + ")";
        }
    }

    static class MapDifferenceImpl<K, V>
    implements MapDifference<K, V> {
        final boolean areEqual;
        final Map<K, V> onlyOnLeft;
        final Map<K, V> onlyOnRight;
        final Map<K, V> onBoth;
        final Map<K, MapDifference.ValueDifference<V>> differences;

        MapDifferenceImpl(boolean areEqual, Map<K, V> onlyOnLeft, Map<K, V> onlyOnRight, Map<K, V> onBoth, Map<K, MapDifference.ValueDifference<V>> differences) {
            this.areEqual = areEqual;
            this.onlyOnLeft = onlyOnLeft;
            this.onlyOnRight = onlyOnRight;
            this.onBoth = onBoth;
            this.differences = differences;
        }

        @Override
        public boolean areEqual() {
            return this.areEqual;
        }

        @Override
        public Map<K, V> entriesOnlyOnLeft() {
            return this.onlyOnLeft;
        }

        @Override
        public Map<K, V> entriesOnlyOnRight() {
            return this.onlyOnRight;
        }

        @Override
        public Map<K, V> entriesInCommon() {
            return this.onBoth;
        }

        @Override
        public Map<K, MapDifference.ValueDifference<V>> entriesDiffering() {
            return this.differences;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof MapDifference) {
                MapDifference mapDifference = (MapDifference)object;
                return ((Object)this.entriesOnlyOnLeft()).equals(mapDifference.entriesOnlyOnLeft()) && ((Object)this.entriesOnlyOnRight()).equals(mapDifference.entriesOnlyOnRight()) && ((Object)this.entriesInCommon()).equals(mapDifference.entriesInCommon()) && ((Object)this.entriesDiffering()).equals(mapDifference.entriesDiffering());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.entriesOnlyOnLeft(), this.entriesOnlyOnRight(), this.entriesInCommon(), this.entriesDiffering());
        }

        public String toString() {
            if (this.areEqual) {
                return "equal";
            }
            StringBuilder stringBuilder = new StringBuilder("not equal");
            if (!this.onlyOnLeft.isEmpty()) {
                stringBuilder.append(": only on left=").append(this.onlyOnLeft);
            }
            if (!this.onlyOnRight.isEmpty()) {
                stringBuilder.append(": only on right=").append(this.onlyOnRight);
            }
            if (!this.differences.isEmpty()) {
                stringBuilder.append(": value differences=").append(this.differences);
            }
            return stringBuilder.toString();
        }
    }
}

