/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.annotations.VisibleForTesting;
import com.timevale.esign.paas.guava.common.base.Function;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.ByFunctionOrdering;
import com.timevale.esign.paas.guava.common.collect.ComparatorOrdering;
import com.timevale.esign.paas.guava.common.collect.CompoundOrdering;
import com.timevale.esign.paas.guava.common.collect.ExplicitOrdering;
import com.timevale.esign.paas.guava.common.collect.ImmutableList;
import com.timevale.esign.paas.guava.common.collect.Iterables;
import com.timevale.esign.paas.guava.common.collect.LexicographicalOrdering;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.MapMaker;
import com.timevale.esign.paas.guava.common.collect.NaturalOrdering;
import com.timevale.esign.paas.guava.common.collect.NullsFirstOrdering;
import com.timevale.esign.paas.guava.common.collect.NullsLastOrdering;
import com.timevale.esign.paas.guava.common.collect.ObjectArrays;
import com.timevale.esign.paas.guava.common.collect.Platform;
import com.timevale.esign.paas.guava.common.collect.ReverseOrdering;
import com.timevale.esign.paas.guava.common.collect.UsingToStringOrdering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(List<T> valuesInOrder) {
        return new ExplicitOrdering<T>(valuesInOrder);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.explicit(Lists.asList(leastValue, remainingValuesInOrder));
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @Override
    public abstract int compare(@Nullable T var1, @Nullable T var2);

    @Beta
    public <E extends T> List<E> leastOf(Iterable<E> iterable, int k2) {
        Object[] objectArray;
        Preconditions.checkArgument(k2 >= 0, "%d is negative", k2);
        Object[] objectArray2 = Iterables.toArray(iterable);
        if (objectArray2.length <= k2) {
            Arrays.sort(objectArray2, this);
            objectArray = objectArray2;
        } else {
            this.quicksortLeastK(objectArray2, 0, objectArray2.length - 1, k2);
            Object[] objectArray3 = new Object[k2];
            objectArray = objectArray3;
            System.arraycopy(objectArray2, 0, objectArray, 0, k2);
        }
        return Collections.unmodifiableList(Arrays.asList(objectArray));
    }

    @Beta
    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int k2) {
        return this.reverse().leastOf(iterable, k2);
    }

    private <E extends T> void quicksortLeastK(E[] values, int left, int right, int k2) {
        if (right > left) {
            int n2 = left + right >>> 1;
            int n3 = this.partition(values, left, right, n2);
            this.quicksortLeastK(values, left, n3 - 1, k2);
            if (n3 < k2) {
                this.quicksortLeastK(values, n3 + 1, right, k2);
            }
        }
    }

    private <E extends T> int partition(E[] values, int left, int right, int pivotIndex) {
        E e2 = values[pivotIndex];
        values[pivotIndex] = values[right];
        values[right] = e2;
        int n2 = left;
        for (int i2 = left; i2 < right; ++i2) {
            if (this.compare(values[i2], e2) >= 0) continue;
            ObjectArrays.swap(values, n2, i2);
            ++n2;
        }
        ObjectArrays.swap(values, right, n2);
        return n2;
    }

    public int binarySearch(List<? extends T> sortedList, @Nullable T key) {
        return Collections.binarySearch(sortedList, key, this);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> arrayList = Lists.newArrayList(iterable);
        Collections.sort(arrayList, this);
        return arrayList;
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
        return ImmutableList.copyOf(this.sortedCopy(iterable));
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t2 = iterator.next();
            while (iterator.hasNext()) {
                T t3 = iterator.next();
                if (this.compare(t2, t3) > 0) {
                    return false;
                }
                t2 = t3;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            T t2 = iterator.next();
            while (iterator.hasNext()) {
                T t3 = iterator.next();
                if (this.compare(t2, t3) >= 0) {
                    return false;
                }
                t2 = t3;
            }
        }
        return true;
    }

    public <E extends T> E max(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        E e2 = iterator.next();
        while (iterator.hasNext()) {
            e2 = this.max(e2, iterator.next());
        }
        return e2;
    }

    public <E extends T> E max(@Nullable E a2, @Nullable E b2, @Nullable E c2, E ... rest) {
        E e2 = this.max(this.max(a2, b2), c2);
        for (E e3 : rest) {
            e2 = this.max(e2, e3);
        }
        return e2;
    }

    public <E extends T> E max(@Nullable E a2, @Nullable E b2) {
        return this.compare(a2, b2) >= 0 ? a2 : b2;
    }

    public <E extends T> E min(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        E e2 = iterator.next();
        while (iterator.hasNext()) {
            e2 = this.min(e2, iterator.next());
        }
        return e2;
    }

    public <E extends T> E min(@Nullable E a2, @Nullable E b2, @Nullable E c2, E ... rest) {
        E e2 = this.min(this.min(a2, b2), c2);
        for (E e3 : rest) {
            e2 = this.min(e2, e3);
        }
        return e2;
    }

    public <E extends T> E min(@Nullable E a2, @Nullable E b2) {
        return this.compare(a2, b2) <= 0 ? a2 : b2;
    }

    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<Object> {
        private Map<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeComputingMap(new Function<Object, Integer>(){
            final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Integer apply(Object from) {
                return this.counter.getAndIncrement();
            }
        });

        ArbitraryOrdering() {
        }

        @Override
        public int compare(Object left, Object right) {
            int n2;
            if (left == right) {
                return 0;
            }
            int n3 = this.identityHashCode(left);
            if (n3 != (n2 = this.identityHashCode(right))) {
                return n3 < n2 ? -1 : 1;
            }
            int n4 = this.uids.get(left).compareTo(this.uids.get(right));
            if (n4 == 0) {
                throw new AssertionError();
            }
            return n4;
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object value) {
            super("Cannot compare value: " + value);
            this.value = value;
        }
    }
}

