/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.ImmutableList;
import com.timevale.esign.paas.guava.common.collect.ImmutableSortedAsList;
import com.timevale.esign.paas.guava.common.collect.ImmutableSortedSet;
import com.timevale.esign.paas.guava.common.collect.SortedIterables;
import com.timevale.esign.paas.guava.common.collect.SortedLists;
import com.timevale.esign.paas.guava.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    private final transient ImmutableList<E> elements;

    RegularImmutableSortedSet(ImmutableList<E> elements, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = elements;
        Preconditions.checkArgument(!elements.isEmpty());
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 == null) {
            return false;
        }
        try {
            return this.binarySearch(o2) >= 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        if (!SortedIterables.hasSameComparator(this.comparator(), targets) || targets.size() <= 1) {
            return super.containsAll(targets);
        }
        Iterator iterator = this.iterator();
        Iterator<?> iterator2 = targets.iterator();
        Object obj = iterator2.next();
        try {
            while (iterator.hasNext()) {
                int n2 = this.unsafeCompare(iterator.next(), obj);
                if (n2 == 0) {
                    if (!iterator2.hasNext()) {
                        return true;
                    }
                    obj = iterator2.next();
                    continue;
                }
                if (n2 <= 0) continue;
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return false;
    }

    private int binarySearch(Object key) {
        Comparator comparator = this.comparator;
        return Collections.binarySearch(this.elements, key, comparator);
    }

    @Override
    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.elements.toArray(array);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        if (SortedIterables.hasSameComparator(this.comparator, set)) {
            Iterator iterator = set.iterator();
            try {
                for (Object e2 : this) {
                    Object e3 = iterator.next();
                    if (e3 != null && this.unsafeCompare(e2, e3) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.containsAll(set);
    }

    @Override
    public E first() {
        return this.elements.get(0);
    }

    @Override
    public E last() {
        return this.elements.get(this.size() - 1);
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E toElement, boolean inclusive) {
        int n2 = inclusive ? SortedLists.binarySearch(this.elements, Preconditions.checkNotNull(toElement), this.comparator(), SortedLists.KeyPresentBehavior.FIRST_AFTER, SortedLists.KeyAbsentBehavior.NEXT_HIGHER) : SortedLists.binarySearch(this.elements, Preconditions.checkNotNull(toElement), this.comparator(), SortedLists.KeyPresentBehavior.FIRST_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
        return this.createSubset(0, n2);
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return this.tailSetImpl(fromElement, fromInclusive).headSetImpl(toElement, toInclusive);
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E fromElement, boolean inclusive) {
        int n2 = inclusive ? SortedLists.binarySearch(this.elements, Preconditions.checkNotNull(fromElement), this.comparator(), SortedLists.KeyPresentBehavior.FIRST_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_HIGHER) : SortedLists.binarySearch(this.elements, Preconditions.checkNotNull(fromElement), this.comparator(), SortedLists.KeyPresentBehavior.FIRST_AFTER, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
        return this.createSubset(n2, this.size());
    }

    Comparator<Object> unsafeComparator() {
        return this.comparator;
    }

    private ImmutableSortedSet<E> createSubset(int newFromIndex, int newToIndex) {
        if (newFromIndex == 0 && newToIndex == this.size()) {
            return this;
        }
        if (newFromIndex < newToIndex) {
            return new RegularImmutableSortedSet<E>(this.elements.subList(newFromIndex, newToIndex), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    int indexOf(@Nullable Object target) {
        int n2;
        if (target == null) {
            return -1;
        }
        try {
            n2 = SortedLists.binarySearch(this.elements, target, this.comparator(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.INVERTED_INSERTION_INDEX);
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        return n2 >= 0 && this.elements.get(n2).equals(target) ? n2 : -1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableSortedAsList<E>(this, this.elements);
    }
}

