/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Function;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.Collections2;
import com.timevale.esign.paas.guava.common.collect.Iterables;
import com.timevale.esign.paas.guava.common.collect.Iterators;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.collect.Multiset;
import com.timevale.esign.paas.guava.common.collect.Multisets;
import com.timevale.esign.paas.guava.common.collect.ObjectArrays;
import com.timevale.esign.paas.guava.common.collect.Ordering;
import com.timevale.esign.paas.guava.common.collect.Sets;
import com.timevale.esign.paas.guava.common.collect.SortedIterable;
import com.timevale.esign.paas.guava.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

@GwtCompatible
final class SortedIterables {
    private SortedIterables() {
    }

    public static boolean hasSameComparator(Comparator<?> comparator, Iterable<?> elements) {
        Comparator<Object> comparator2;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elements);
        if (elements instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)elements;
            comparator2 = sortedSet.comparator();
            if (comparator2 == null) {
                comparator2 = Ordering.natural();
            }
        } else {
            comparator2 = elements instanceof SortedIterable ? ((SortedIterable)elements).comparator() : null;
        }
        return ((Object)comparator).equals(comparator2);
    }

    public static <E> Collection<E> sortedUnique(Comparator<? super E> comparator, Iterator<E> elements) {
        TreeSet<? super E> treeSet = Sets.newTreeSet(comparator);
        Iterators.addAll(treeSet, elements);
        return treeSet;
    }

    public static <E> Collection<E> sortedUnique(Comparator<? super E> comparator, Iterable<E> elements) {
        if (elements instanceof Multiset) {
            elements = ((Multiset)elements).elementSet();
        }
        if (elements instanceof Set) {
            if (SortedIterables.hasSameComparator(comparator, elements)) {
                return (Set)elements;
            }
            ArrayList<E> arrayList = Lists.newArrayList(elements);
            Collections.sort(arrayList, comparator);
            return arrayList;
        }
        Object[] objectArray = Iterables.toArray(elements);
        if (!SortedIterables.hasSameComparator(comparator, elements)) {
            Arrays.sort(objectArray, comparator);
        }
        return SortedIterables.uniquifySortedArray(comparator, objectArray);
    }

    private static <E> Collection<E> uniquifySortedArray(Comparator<? super E> comparator, E[] array) {
        if (array.length == 0) {
            return Collections.emptySet();
        }
        int n2 = 1;
        for (int i2 = 1; i2 < array.length; ++i2) {
            int n3 = comparator.compare(array[i2], array[n2 - 1]);
            if (n3 == 0) continue;
            array[n2++] = array[i2];
        }
        if (n2 < array.length) {
            array = ObjectArrays.arraysCopyOf(array, n2);
        }
        return Arrays.asList(array);
    }

    public static <E> Collection<Multiset.Entry<E>> sortedCounts(Comparator<? super E> comparator, Iterator<E> elements) {
        TreeMultiset<E> treeMultiset = TreeMultiset.create(comparator);
        Iterators.addAll(treeMultiset, elements);
        return treeMultiset.entrySet();
    }

    public static <E> Collection<Multiset.Entry<E>> sortedCounts(Comparator<? super E> comparator, Iterable<E> elements) {
        if (elements instanceof Multiset) {
            Multiset multiset = (Multiset)elements;
            if (SortedIterables.hasSameComparator(comparator, elements)) {
                return multiset.entrySet();
            }
            ArrayList arrayList = Lists.newArrayList(multiset.entrySet());
            Collections.sort(arrayList, Ordering.from(comparator).onResultOf(new Function<Multiset.Entry<E>, E>(){

                @Override
                public E apply(Multiset.Entry<E> entry) {
                    return entry.getElement();
                }
            }));
            return arrayList;
        }
        if (elements instanceof Set) {
            ArrayList<E> arrayList;
            if (SortedIterables.hasSameComparator(comparator, elements)) {
                arrayList = (ArrayList<E>)elements;
            } else {
                ArrayList<E> arrayList2 = Lists.newArrayList(elements);
                Collections.sort(arrayList2, comparator);
                arrayList = arrayList2;
            }
            return SortedIterables.singletonEntries(arrayList);
        }
        if (SortedIterables.hasSameComparator(comparator, elements)) {
            Object e2 = null;
            int n2 = 0;
            ArrayList<Multiset.Entry<Multiset.Entry<Object>>> arrayList = Lists.newArrayList();
            for (E e3 : elements) {
                if (n2 > 0) {
                    if (comparator.compare(e2, e3) == 0) {
                        ++n2;
                        continue;
                    }
                    arrayList.add(Multisets.immutableEntry(e2, n2));
                    e2 = e3;
                    n2 = 1;
                    continue;
                }
                e2 = e3;
                n2 = 1;
            }
            if (n2 > 0) {
                arrayList.add(Multisets.immutableEntry(e2, n2));
            }
            return arrayList;
        }
        TreeMultiset<E> treeMultiset = TreeMultiset.create(comparator);
        Iterables.addAll(treeMultiset, elements);
        return treeMultiset.entrySet();
    }

    static <E> Collection<Multiset.Entry<E>> singletonEntries(Collection<E> set) {
        return Collections2.transform(set, new Function<E, Multiset.Entry<E>>(){

            @Override
            public Multiset.Entry<E> apply(E elem) {
                return Multisets.immutableEntry(elem, 1);
            }
        });
    }
}

