/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractLinkedIterator;
import com.timevale.esign.paas.guava.common.collect.AbstractSortedMultiset;
import com.timevale.esign.paas.guava.common.collect.BoundType;
import com.timevale.esign.paas.guava.common.collect.BstAggregate;
import com.timevale.esign.paas.guava.common.collect.BstCountBasedBalancePolicies;
import com.timevale.esign.paas.guava.common.collect.BstInOrderPath;
import com.timevale.esign.paas.guava.common.collect.BstModificationResult;
import com.timevale.esign.paas.guava.common.collect.BstModifier;
import com.timevale.esign.paas.guava.common.collect.BstMutationResult;
import com.timevale.esign.paas.guava.common.collect.BstMutationRule;
import com.timevale.esign.paas.guava.common.collect.BstNode;
import com.timevale.esign.paas.guava.common.collect.BstNodeFactory;
import com.timevale.esign.paas.guava.common.collect.BstOperations;
import com.timevale.esign.paas.guava.common.collect.BstPathFactory;
import com.timevale.esign.paas.guava.common.collect.BstRangeOps;
import com.timevale.esign.paas.guava.common.collect.BstSide;
import com.timevale.esign.paas.guava.common.collect.GeneralRange;
import com.timevale.esign.paas.guava.common.collect.Iterables;
import com.timevale.esign.paas.guava.common.collect.Multiset;
import com.timevale.esign.paas.guava.common.collect.Multisets;
import com.timevale.esign.paas.guava.common.collect.Ordering;
import com.timevale.esign.paas.guava.common.collect.SortedMultiset;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

final class SortedTreeMultiset<E>
extends AbstractSortedMultiset<E> {
    private final GeneralRange<E> range;
    private final AtomicReference<Node> rootReference;
    private final transient BstPathFactory<Node, BstInOrderPath<Node>> pathFactory = BstInOrderPath.inOrderFactory();
    private final transient BstAggregate<Node> distinctAggregate = new BstAggregate<Node>(){

        @Override
        public int entryValue(Node entry) {
            return 1;
        }

        @Override
        public int treeValue(@Nullable Node tree) {
            return SortedTreeMultiset.this.distinctOrZero(tree);
        }
    };
    private final transient BstAggregate<Node> sizeAggregate = new BstAggregate<Node>(){

        @Override
        public int entryValue(Node entry) {
            return entry.elemOccurrences;
        }

        @Override
        public int treeValue(@Nullable Node tree) {
            return SortedTreeMultiset.this.sizeOrZero(tree);
        }
    };
    private final transient BstNodeFactory<Node> nodeFactory = new BstNodeFactory<Node>(){

        @Override
        public Node createNode(Node source, @Nullable Node left, @Nullable Node right) {
            return new Node(source.getKey(), source.elemOccurrences, left, right);
        }
    };

    public static <E extends Comparable> SortedTreeMultiset<E> create() {
        return new SortedTreeMultiset(Ordering.natural());
    }

    public static <E> SortedTreeMultiset<E> create(Comparator<? super E> comparator) {
        return new SortedTreeMultiset<E>(comparator);
    }

    public static <E extends Comparable> SortedTreeMultiset<E> create(Iterable<? extends E> elements) {
        SortedTreeMultiset<E> sortedTreeMultiset = SortedTreeMultiset.create();
        Iterables.addAll(sortedTreeMultiset, elements);
        return sortedTreeMultiset;
    }

    private SortedTreeMultiset(Comparator<? super E> comparator) {
        super(comparator);
        this.range = GeneralRange.all(comparator);
        this.rootReference = new AtomicReference();
    }

    private SortedTreeMultiset(GeneralRange<E> range, AtomicReference<Node> root) {
        super(range.comparator());
        this.range = range;
        this.rootReference = root;
    }

    E checkElement(Object o2) {
        Preconditions.checkNotNull(o2);
        return (E)o2;
    }

    @Override
    int distinctElements() {
        Node node = this.rootReference.get();
        return BstRangeOps.totalInRange(this.distinctAggregate, this.range, node);
    }

    @Override
    public int size() {
        Node node = this.rootReference.get();
        return BstRangeOps.totalInRange(this.sizeAggregate, this.range, node);
    }

    @Override
    public int count(@Nullable Object element) {
        if (element == null) {
            return 0;
        }
        try {
            E e2 = this.checkElement(element);
            if (this.range.contains(e2)) {
                Node node = (Node)BstOperations.seek(this.comparator(), (BstNode)this.rootReference.get(), e2);
                return node == null ? 0 : node.elemOccurrences;
            }
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    private int mutate(E e2, MultisetModifier modifier) {
        BstMutationRule bstMutationRule = BstMutationRule.createRule(modifier, BstCountBasedBalancePolicies.singleRebalancePolicy(this.distinctAggregate), this.nodeFactory);
        BstMutationResult bstMutationResult = BstOperations.mutate(this.comparator(), bstMutationRule, (BstNode)this.rootReference.get(), e2);
        if (!this.rootReference.compareAndSet((Node)bstMutationResult.getOriginalRoot(), (Node)bstMutationResult.getChangedRoot())) {
            throw new ConcurrentModificationException();
        }
        Node node = (Node)bstMutationResult.getOriginalTarget();
        return node == null ? 0 : node.elemOccurrences;
    }

    @Override
    public int add(E element, int occurrences) {
        Preconditions.checkNotNull(element);
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new AddModifier(occurrences));
    }

    @Override
    public int remove(@Nullable Object element, int occurrences) {
        if (element == null) {
            return 0;
        }
        if (occurrences == 0) {
            return this.count(element);
        }
        try {
            E e2 = this.checkElement(element);
            return this.range.contains(e2) ? this.mutate(e2, new RemoveModifier(occurrences)) : 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    @Override
    public boolean setCount(E element, int oldCount, int newCount) {
        Preconditions.checkNotNull(element);
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new ConditionalSetCountModifier(oldCount, newCount)) == oldCount;
    }

    @Override
    public int setCount(E element, int count) {
        Preconditions.checkNotNull(element);
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new SetCountModifier(count));
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        Node node = this.rootReference.get();
        BstInOrderPath bstInOrderPath = (BstInOrderPath)((Object)BstRangeOps.furthestPath(this.range, BstSide.LEFT, this.pathFactory, node));
        return this.iteratorInDirection(bstInOrderPath, BstSide.RIGHT);
    }

    @Override
    Iterator<Multiset.Entry<E>> descendingEntryIterator() {
        Node node = this.rootReference.get();
        BstInOrderPath bstInOrderPath = (BstInOrderPath)((Object)BstRangeOps.furthestPath(this.range, BstSide.RIGHT, this.pathFactory, node));
        return this.iteratorInDirection(bstInOrderPath, BstSide.LEFT);
    }

    private Iterator<Multiset.Entry<E>> iteratorInDirection(@Nullable BstInOrderPath<Node> start, final BstSide direction) {
        final AbstractLinkedIterator<BstInOrderPath<Node>> abstractLinkedIterator = new AbstractLinkedIterator<BstInOrderPath<Node>>(start){

            @Override
            protected BstInOrderPath<Node> computeNext(BstInOrderPath<Node> previous) {
                if (!previous.hasNext(direction)) {
                    return null;
                }
                BstInOrderPath<Node> bstInOrderPath = previous.next(direction);
                return SortedTreeMultiset.this.range.contains(((Node)bstInOrderPath.getTip()).getKey()) ? bstInOrderPath : null;
            }
        };
        return new Iterator<Multiset.Entry<E>>(){
            E toRemove = null;

            @Override
            public boolean hasNext() {
                return abstractLinkedIterator.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                BstInOrderPath bstInOrderPath = (BstInOrderPath)abstractLinkedIterator.next();
                this.toRemove = ((Node)bstInOrderPath.getTip()).getKey();
                return Multisets.immutableEntry(this.toRemove, ((Node)bstInOrderPath.getTip()).elemOccurrences);
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.toRemove != null);
                SortedTreeMultiset.this.setCount(this.toRemove, 0);
                this.toRemove = null;
            }
        };
    }

    @Override
    public void clear() {
        Node node;
        Node node2 = this.rootReference.get();
        if (!this.rootReference.compareAndSet(node2, node = BstRangeOps.minusRange(this.range, BstCountBasedBalancePolicies.fullRebalancePolicy(this.distinctAggregate), this.nodeFactory, node2))) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public SortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        Preconditions.checkNotNull(upperBound);
        return new SortedTreeMultiset<E>(this.range.intersect(GeneralRange.upTo(this.comparator, upperBound, boundType)), this.rootReference);
    }

    @Override
    public SortedMultiset<E> tailMultiset(E lowerBound, BoundType boundType) {
        Preconditions.checkNotNull(lowerBound);
        return new SortedTreeMultiset<E>(this.range.intersect(GeneralRange.downTo(this.comparator, lowerBound, boundType)), this.rootReference);
    }

    private int sizeOrZero(@Nullable Node node) {
        return node == null ? 0 : node.size;
    }

    private int distinctOrZero(@Nullable Node node) {
        return node == null ? 0 : node.distinct;
    }

    private final class ConditionalSetCountModifier
    extends MultisetModifier {
        private final int expectedCount;
        private final int setCount;

        private ConditionalSetCountModifier(int expectedCount, int setCount) {
            Preconditions.checkArgument(setCount >= 0 & expectedCount >= 0);
            this.expectedCount = expectedCount;
            this.setCount = setCount;
        }

        @Override
        int newCount(int oldCount) {
            return oldCount == this.expectedCount ? this.setCount : oldCount;
        }
    }

    private final class SetCountModifier
    extends MultisetModifier {
        private final int countToSet;

        private SetCountModifier(int countToSet) {
            Preconditions.checkArgument(countToSet >= 0);
            this.countToSet = countToSet;
        }

        @Override
        int newCount(int oldCount) {
            return this.countToSet;
        }
    }

    private final class RemoveModifier
    extends MultisetModifier {
        private final int countToRemove;

        private RemoveModifier(int countToRemove) {
            Preconditions.checkArgument(countToRemove > 0);
            this.countToRemove = countToRemove;
        }

        @Override
        int newCount(int oldCount) {
            return Math.max(0, oldCount - this.countToRemove);
        }
    }

    private final class AddModifier
    extends MultisetModifier {
        private final int countToAdd;

        private AddModifier(int countToAdd) {
            Preconditions.checkArgument(countToAdd > 0);
            this.countToAdd = countToAdd;
        }

        @Override
        int newCount(int oldCount) {
            return oldCount + this.countToAdd;
        }
    }

    private abstract class MultisetModifier
    implements BstModifier<E, Node> {
        private MultisetModifier() {
        }

        abstract int newCount(int var1);

        @Override
        @Nullable
        public BstModificationResult<Node> modify(E key, @Nullable Node originalEntry) {
            int n2;
            int n3 = originalEntry == null ? 0 : originalEntry.elemOccurrences;
            if (n3 == (n2 = this.newCount(n3))) {
                return BstModificationResult.identity(originalEntry);
            }
            if (n2 == 0) {
                return BstModificationResult.rebalancingChange(originalEntry, null);
            }
            if (n3 == 0) {
                return BstModificationResult.rebalancingChange(null, new Node(key, n2));
            }
            return BstModificationResult.rebuildingChange(originalEntry, new Node(key, n2));
        }
    }

    private final class Node
    extends BstNode<E, Node> {
        private final int elemOccurrences;
        private final int size;
        private final int distinct;

        private Node(E key, @Nullable int elemCount, @Nullable Node left, Node right) {
            super(SortedTreeMultiset.this.checkElement(key), left, right);
            Preconditions.checkArgument(elemCount > 0);
            this.elemOccurrences = elemCount;
            this.size = elemCount + SortedTreeMultiset.this.sizeOrZero(left) + SortedTreeMultiset.this.sizeOrZero(right);
            this.distinct = 1 + SortedTreeMultiset.this.distinctOrZero(left) + SortedTreeMultiset.this.distinctOrZero(right);
        }

        private Node(E key, int elemCount) {
            this(key, elemCount, null, null);
        }
    }
}

