/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.primitives;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

@GwtCompatible
public final class Bytes {
    private Bytes() {
    }

    public static int hashCode(byte value) {
        return value;
    }

    public static boolean contains(byte[] array, byte target) {
        for (byte by2 : array) {
            if (by2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(byte[] array, byte target) {
        return Bytes.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(byte[] array, byte target, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array.length - target.length + 1; ++i2) {
            for (int i3 = 0; i3 < target.length; ++i3) {
                if (array[i2 + i3] != target[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte target) {
        return Bytes.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(byte[] array, byte target, int start, int end) {
        for (int i2 = end - 1; i2 >= start; --i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static byte[] concat(byte[] ... arrays) {
        int n2 = 0;
        for (byte[] byArray : arrays) {
            n2 += byArray.length;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : arrays) {
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            n3 += byArray2.length;
        }
        return byArray;
    }

    public static byte[] ensureCapacity(byte[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength ? Bytes.copyOf(array, minLength + padding) : array;
    }

    private static byte[] copyOf(byte[] original, int length) {
        byte[] byArray = new byte[length];
        System.arraycopy(original, 0, byArray, 0, Math.min(original.length, length));
        return byArray;
    }

    public static byte[] toArray(Collection<Byte> collection) {
        if (collection instanceof ByteArrayAsList) {
            return ((ByteArrayAsList)collection).toByteArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (Byte)Preconditions.checkNotNull(objectArray[i2]);
        }
        return byArray;
    }

    public static List<Byte> asList(byte ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ByteArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class ByteArrayAsList
    extends AbstractList<Byte>
    implements Serializable,
    RandomAccess {
        final byte[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ByteArrayAsList(byte[] array) {
            this(array, 0, array.length);
        }

        ByteArrayAsList(byte[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Byte get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Byte && Bytes.indexOf(this.array, (Byte)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int n2;
            if (target instanceof Byte && (n2 = Bytes.indexOf(this.array, (Byte)target, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int n2;
            if (target instanceof Byte && (n2 = Bytes.lastIndexOf(this.array, (Byte)target, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Byte set(int index, Byte element) {
            Preconditions.checkElementIndex(index, this.size());
            byte by2 = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return by2;
        }

        @Override
        public List<Byte> subList(int fromIndex, int toIndex) {
            int n2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, n2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ByteArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ByteArrayAsList) {
                ByteArrayAsList byteArrayAsList = (ByteArrayAsList)object;
                int n2 = this.size();
                if (byteArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == byteArrayAsList.array[byteArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Bytes.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 5);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        byte[] toByteArray() {
            int n2 = this.size();
            byte[] byArray = new byte[n2];
            System.arraycopy(this.array, this.start, byArray, 0, n2);
            return byArray;
        }
    }
}

