/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.primitives;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@GwtCompatible
public final class Doubles {
    public static final int BYTES = 8;

    private Doubles() {
    }

    public static int hashCode(double value) {
        return Double.valueOf(value).hashCode();
    }

    public static int compare(double a2, double b2) {
        return Double.compare(a2, b2);
    }

    public static boolean isFinite(double value) {
        return Double.NEGATIVE_INFINITY < value & value < Double.POSITIVE_INFINITY;
    }

    public static boolean contains(double[] array, double target) {
        for (double d2 : array) {
            if (d2 != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(double[] array, double target) {
        return Doubles.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(double[] array, double target, int start, int end) {
        for (int i2 = start; i2 < end; ++i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(double[] array, double[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < array.length - target.length + 1; ++i2) {
            for (int i3 = 0; i3 < target.length; ++i3) {
                if (array[i2 + i3] != target[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double target) {
        return Doubles.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(double[] array, double target, int start, int end) {
        for (int i2 = end - 1; i2 >= start; --i2) {
            if (array[i2] != target) continue;
            return i2;
        }
        return -1;
    }

    public static double min(double ... array) {
        Preconditions.checkArgument(array.length > 0);
        double d2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            d2 = Math.min(d2, array[i2]);
        }
        return d2;
    }

    public static double max(double ... array) {
        Preconditions.checkArgument(array.length > 0);
        double d2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            d2 = Math.max(d2, array[i2]);
        }
        return d2;
    }

    public static double[] concat(double[] ... arrays) {
        int n2 = 0;
        for (double[] dArray : arrays) {
            n2 += dArray.length;
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (double[] dArray2 : arrays) {
            System.arraycopy(dArray2, 0, dArray, n3, dArray2.length);
            n3 += dArray2.length;
        }
        return dArray;
    }

    public static double[] ensureCapacity(double[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength ? Doubles.copyOf(array, minLength + padding) : array;
    }

    private static double[] copyOf(double[] original, int length) {
        double[] dArray = new double[length];
        System.arraycopy(original, 0, dArray, 0, Math.min(original.length, length));
        return dArray;
    }

    public static String join(String separator, double ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(array.length * 12);
        stringBuilder.append(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            stringBuilder.append(separator).append(array[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<double[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static double[] toArray(Collection<Double> collection) {
        if (collection instanceof DoubleArrayAsList) {
            return ((DoubleArrayAsList)collection).toDoubleArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = (Double)Preconditions.checkNotNull(objectArray[i2]);
        }
        return dArray;
    }

    public static List<Double> asList(double ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new DoubleArrayAsList(backingArray);
    }

    @GwtCompatible
    private static class DoubleArrayAsList
    extends AbstractList<Double>
    implements Serializable,
    RandomAccess {
        final double[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        DoubleArrayAsList(double[] array) {
            this(array, 0, array.length);
        }

        DoubleArrayAsList(double[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Double get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Double && Doubles.indexOf(this.array, (Double)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int n2;
            if (target instanceof Double && (n2 = Doubles.indexOf(this.array, (Double)target, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int n2;
            if (target instanceof Double && (n2 = Doubles.lastIndexOf(this.array, (Double)target, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Double set(int index, Double element) {
            Preconditions.checkElementIndex(index, this.size());
            double d2 = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return d2;
        }

        @Override
        public List<Double> subList(int fromIndex, int toIndex) {
            int n2 = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, n2);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new DoubleArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayAsList) {
                DoubleArrayAsList doubleArrayAsList = (DoubleArrayAsList)object;
                int n2 = this.size();
                if (doubleArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == doubleArrayAsList.array[doubleArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Doubles.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 12);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        double[] toDoubleArray() {
            int n2 = this.size();
            double[] dArray = new double[n2];
            System.arraycopy(this.array, this.start, dArray, 0, n2);
            return dArray;
        }
    }

    private static enum LexicographicalComparator implements Comparator<double[]>
    {
        INSTANCE;


        @Override
        public int compare(double[] left, double[] right) {
            int n2 = Math.min(left.length, right.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Doubles.compare(left[i2], right[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return left.length - right.length;
        }
    }
}

