/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.seal.sdk.request.generator;

import com.timevale.esign.paas.seal.sdk.drawer.ImageDrawer;
import com.timevale.esign.paas.seal.sdk.drawer.request.InnerRequest;
import com.timevale.esign.paas.seal.sdk.enums.DrawRuleTypeEnum;
import com.timevale.esign.paas.seal.sdk.enums.SealTypeEnum;
import com.timevale.esign.paas.seal.sdk.enums.UnitEnum;
import com.timevale.esign.paas.seal.sdk.exception.SealSdkException;
import com.timevale.esign.paas.seal.sdk.factory.DrawerFactory;
import com.timevale.esign.paas.seal.sdk.request.SealBaseRequest;
import com.timevale.esign.paas.seal.sdk.request.generator.RequestGenerator;
import com.timevale.esign.paas.seal.sdk.response.SealImageResponse;
import com.timevale.esign.paas.seal.sdk.util.DpiUtil;
import com.timevale.esign.paas.seal.sdk.util.ImageCommonUtil;
import com.timevale.esign.paas.seal.sdk.util.PixelUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public abstract class AbstractRequestGenerator
implements RequestGenerator {
    @Override
    public <T extends SealBaseRequest> SealImageResponse generate(T t2, DrawRuleTypeEnum drawRuleTypeEnum) {
        this.validateRequest(t2);
        InnerRequest innerRequest = this.getImageRequest();
        this.convert(t2, innerRequest);
        ImageDrawer imageDrawer = DrawerFactory.getImageDrawer(t2.getSealTypeEnum(), drawRuleTypeEnum);
        BufferedImage bufferedImage = imageDrawer.draw(innerRequest);
        bufferedImage = this.processImage(bufferedImage, t2);
        byte[] byArray = this.transferBytes(t2, innerRequest, bufferedImage);
        SealImageResponse sealImageResponse = new SealImageResponse();
        sealImageResponse.setBytes(byArray);
        if (UnitEnum.MM.equals((Object)t2.getUnit())) {
            sealImageResponse.setWidth(PixelUtil.transferMmToPixel(t2.getWidth(), t2.getDpi()));
            sealImageResponse.setHeight(PixelUtil.transferMmToPixel(t2.getHeight(), t2.getDpi()));
        } else {
            sealImageResponse.setWidth(t2.getWidth());
            sealImageResponse.setHeight(t2.getHeight());
        }
        return sealImageResponse;
    }

    protected <T extends SealBaseRequest> void validateRequest(T t2) {
        if (t2 == null) {
            throw new SealSdkException("SealBaseRequest request is null");
        }
        if (t2.getWidth() <= 0) {
            throw new SealSdkException("SealBaseRequest weight should > 0");
        }
        if (t2.getHeight() <= 0) {
            throw new SealSdkException("SealBaseRequest height should > 0");
        }
        Float f2 = t2.getBorderWidth();
        if (f2 != null && f2.floatValue() <= 0.0f) {
            throw new SealSdkException("SealBaseRequest borderWidth should > 0");
        }
        if (t2.getDpi() <= 0) {
            throw new SealSdkException("SealBaseRequest dpi should > 0");
        }
        if (t2.getUnit() == null) {
            throw new SealSdkException("SealBaseRequest fontUnit is null");
        }
        int n2 = t2.getOldStyle();
        if (n2 < 0 || n2 > 12) {
            throw new SealSdkException("SealBaseRequest oldValue range is [0, 12]");
        }
        float f3 = t2.getOpacity();
        if (f3 < 0.0f || f3 > 1.0f) {
            throw new SealSdkException("SealBaseRequest opacity range is [0, 1]");
        }
    }

    private BufferedImage processImage(BufferedImage rawImage, SealBaseRequest request) {
        int n2;
        float f2 = request.getOpacity();
        if (f2 != 1.0f) {
            rawImage = ImageCommonUtil.setAlphaToImage(rawImage, f2);
        }
        if ((n2 = request.getOldStyle()) != 0) {
            return ImageCommonUtil.makeOld(rawImage, request.getSealColor(), n2);
        }
        return rawImage;
    }

    private byte[] transferBytes(SealBaseRequest outerRequest, InnerRequest innerRequest, BufferedImage rawImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (outerRequest.getDpi() != innerRequest.getDpi()) {
                DpiUtil.resetPngDpi(rawImage, outerRequest.getDpi(), byteArrayOutputStream);
            } else {
                ImageIO.write((RenderedImage)rawImage, "png", byteArrayOutputStream);
            }
        }
        catch (IOException iOException) {
            throw new SealSdkException("\u56fe\u7247\u8f6c\u5b57\u8282\u6d41\u5931\u8d25", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected abstract InnerRequest getImageRequest();

    private <R extends InnerRequest, T extends SealBaseRequest> void convert(T t2, R r2) {
        SealTypeEnum sealTypeEnum = t2.getSealTypeEnum();
        int n2 = sealTypeEnum.getDpi();
        if (UnitEnum.MM.equals((Object)t2.getUnit())) {
            r2.setWidth(PixelUtil.transferMmToPixel(t2.getWidth(), n2));
            r2.setHeight(PixelUtil.transferMmToPixel(t2.getHeight(), n2));
            Float f2 = t2.getBorderWidth();
            if (f2 != null) {
                r2.setBorderWidth(PixelUtil.transferMmToPixel(t2.getBorderWidth().floatValue(), n2));
            } else {
                r2.setBorderWidth(0);
            }
        } else {
            r2.setHeight(t2.getHeight());
            r2.setWidth(t2.getWidth());
            Float f3 = t2.getBorderWidth();
            if (f3 != null) {
                r2.setBorderWidth((int)f3.floatValue());
            } else {
                r2.setBorderWidth(0);
            }
        }
        r2.setDpi(n2);
        r2.setSealColor(t2.getSealColor());
        this.convertDetail(t2, r2);
    }

    protected abstract <T extends SealBaseRequest, R extends InnerRequest> void convertDetail(T var1, R var2);
}

