/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.tech.util.SignatureProperties;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.Certificate;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSASignatureProperties
extends SignatureProperties {
    public RSASignatureProperties(byte[] privateKeyBytes, byte[] certificateBytes) {
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            Object object;
            if (privateKeyBytes.length > 0) {
                object = new PKCS8EncodedKeySpec(privateKeyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.privateKey = keyFactory.generatePrivate((KeySpec)object);
            }
            if (certificateBytes.length > 0) {
                byteArrayInputStream = new ByteArrayInputStream(certificateBytes);
                filterInputStream = new ASN1InputStream(byteArrayInputStream);
                object = (ASN1Sequence)((ASN1InputStream)filterInputStream).readObject();
                this.certificate = Certificate.getInstance(object);
                this.publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(this.certificate.getSubjectPublicKeyInfo().getEncoded()));
            }
            this.provider = "BC";
            this.signatureAlgorithm = "SHA256WithRSA";
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (byteArrayInputStream != null) {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

