/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.esign.utils.security.provider.Provider;
import com.timevale.esign.paas.tech.util.IOUtil;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DEROutputStream;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.jcajce.JcaCertStore;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSProcessable;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedDataGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtil.class);

    public static String pkcs1Sign(String privateKeyStr, String originDataStr, String signalg) {
        try {
            byte[] byArray = Base64.decodeBase64((String)privateKeyStr);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            Signature signature = Signature.getInstance(signalg);
            signature.initSign(privateKey);
            signature.update(originDataStr.getBytes("utf-8"));
            return Base64.encodeBase64String((byte[])signature.sign());
        }
        catch (Exception exception) {
            LOGGER.error("PKCS1\u7b7e\u540d\u5f02\u5e38: ", (Throwable)exception);
            return null;
        }
    }

    public static boolean verifySignedDataByP1(String publicKeyStr, String originDataStr, String signDataStr, String signalg) {
        try {
            Signature signature = Signature.getInstance(signalg);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decodeBase64((String)publicKeyStr));
            Certificate certificate = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            while (((InputStream)byteArrayInputStream).available() > 0) {
                certificate = certificateFactory.generateCertificate(byteArrayInputStream);
            }
            if (certificate != null) {
                signature.initVerify(certificate.getPublicKey());
                signature.update(originDataStr.getBytes("utf-8"));
                return signature.verify(Base64.decodeBase64((String)signDataStr));
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("PKCS1\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38: ", throwable);
        }
        return false;
    }

    public static boolean verifySignedDataByP7(String signedDataStr, String originDataStr) {
        byte[] byArray = Base64.decodeBase64((String)signedDataStr);
        byte[] byArray2 = null;
        if (originDataStr != null) {
            byArray2 = originDataStr.getBytes(Charset.forName("utf-8"));
        }
        try {
            CMSSignedData cMSSignedData;
            Object object;
            if (byArray2 != null) {
                object = new CMSProcessableByteArray(byArray2);
                cMSSignedData = new CMSSignedData((CMSProcessable)object, byArray);
            } else {
                cMSSignedData = new CMSSignedData(byArray);
            }
            object = cMSSignedData.getCertificates();
            SignerInformationStore signerInformationStore = cMSSignedData.getSignerInfos();
            Collection<SignerInformation> collection = signerInformationStore.getSigners();
            Iterator<SignerInformation> iterator = collection.iterator();
            if (iterator.hasNext()) {
                SignerInformation signerInformation = iterator.next();
                Collection collection2 = object.getMatches(signerInformation.getSID());
                Iterator iterator2 = collection2.iterator();
                X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)iterator2.next();
                return signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509CertificateHolder));
            }
        }
        catch (Exception exception) {
            LOGGER.error("PKCS7\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38: ", (Throwable)exception);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pkcs7Sign(String publicKeyStr, String originDataStr, String signedDataType, String privateKeyStr) throws Exception {
        String string;
        block8: {
            byte[] byArray = originDataStr.getBytes(Charset.forName("utf-8"));
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyStr));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            byte[] byArray2 = Base64.decodeBase64((byte[])publicKeyStr.getBytes(Charset.forName("utf-8")));
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            arrayList.add(x509Certificate);
            JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
            ContentSigner contentSigner = new JcaContentSignerBuilder(x509Certificate.getSigAlgName()).setProvider("BC").build(privateKey);
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            cMSSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).setDirectSignature(true).build(contentSigner, x509Certificate));
            cMSSignedDataGenerator.addCertificates(jcaCertStore);
            CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(byArray);
            boolean bl2 = false;
            if ("Attached".equals(signedDataType)) {
                bl2 = true;
            }
            if ("Detached".equals(signedDataType)) {
                bl2 = false;
            }
            CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, bl2);
            ContentInfo contentInfo = cMSSignedData.toASN1Structure();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string2 = null;
            try {
                DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
                dEROutputStream.writeObject(contentInfo);
                string = string2 = new String(Base64.encodeBase64((byte[])byteArrayOutputStream.toByteArray()), Charset.forName("utf-8"));
                if (byteArrayOutputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (byteArrayOutputStream != null) {
                        byteArrayOutputStream.close();
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    LOGGER.error("PKCS7\u7b7e\u540d\u5f02\u5e38: ", (Throwable)exception);
                    return null;
                }
            }
            byteArrayOutputStream.close();
        }
        return string;
    }

    static {
        Provider.BC.install();
    }
}

