/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.timestamp.enums.DigestAlgorithm;

public enum SignAlgorithm {
    SHA256WITHRSA("SHA256WithRSA", "SHA256", "RSA", "BC", DigestAlgorithm.SHA256),
    SM3WITHSM2("SM3withSM2", "SM3", "SM2", "SM", DigestAlgorithm.SM3);

    private String signAlg;
    private String hashAlg;
    private String encrypetAlg;
    private String provider;
    private DigestAlgorithm digestAlgorithm;

    private SignAlgorithm(String signAlg, String hashAlg, String encrypetAlg, String provider, DigestAlgorithm digestAlgorithm) {
        this.signAlg = signAlg;
        this.hashAlg = hashAlg;
        this.encrypetAlg = encrypetAlg;
        this.provider = provider;
        this.digestAlgorithm = digestAlgorithm;
    }

    public static SignAlgorithm convert(String alg) {
        for (SignAlgorithm signAlgorithm : SignAlgorithm.values()) {
            if (!signAlgorithm.getEncrypetAlg().equalsIgnoreCase(alg)) continue;
            return signAlgorithm;
        }
        return SHA256WITHRSA;
    }

    public String getSignAlg() {
        return this.signAlg;
    }

    public String getHashAlg() {
        return this.hashAlg;
    }

    public String getEncrypetAlg() {
        return this.encrypetAlg;
    }

    public String getProvider() {
        return this.provider;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }
}

