/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.generators;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.GOST3410Parameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.SecureRandom;

public class GOST3410KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private GOST3410KeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (GOST3410KeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger bigInteger;
        GOST3410Parameters gOST3410Parameters = this.param.getParameters();
        SecureRandom secureRandom = this.param.getRandom();
        BigInteger bigInteger2 = gOST3410Parameters.getQ();
        BigInteger bigInteger3 = gOST3410Parameters.getP();
        BigInteger bigInteger4 = gOST3410Parameters.getA();
        int n2 = 64;
        while ((bigInteger = new BigInteger(256, secureRandom)).signum() < 1 || bigInteger.compareTo(bigInteger2) >= 0 || WNafUtil.getNafWeight(bigInteger) < n2) {
        }
        BigInteger bigInteger5 = bigInteger4.modPow(bigInteger, bigInteger3);
        return new AsymmetricCipherKeyPair(new GOST3410PublicKeyParameters(bigInteger5, gOST3410Parameters), new GOST3410PrivateKeyParameters(bigInteger, gOST3410Parameters));
    }
}

