/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.agreement.DHStandardGroups;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.DHParameters;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.AbstractTlsServer;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsCipherFactory;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsCredentials;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsKeyExchange;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsPSKIdentityManager;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsPSKKeyExchange;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsUtils;
import java.io.IOException;

public class PSKTlsServer
extends AbstractTlsServer {
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsPSKIdentityManager tlsPSKIdentityManager) {
        this(new DefaultTlsCipherFactory(), tlsPSKIdentityManager);
    }

    public PSKTlsServer(TlsCipherFactory tlsCipherFactory, TlsPSKIdentityManager tlsPSKIdentityManager) {
        super(tlsCipherFactory);
        this.pskIdentityManager = tlsPSKIdentityManager;
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected DHParameters getDHParameters() {
        return DHStandardGroups.rfc7919_ffdhe2048;
    }

    @Override
    protected int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n2) {
        return new TlsPSKKeyExchange(n2, this.supportedSignatureAlgorithms, null, this.pskIdentityManager, this.getDHParameters(), this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

