/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls;

import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Digest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Mac;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.digests.LongDigest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.macs.HMac;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.KeyParameter;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.ProtocolVersion;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.SSL3Mac;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsContext;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.tls.TlsUtils;
import com.timevale.esign.paas.tgtext.bouncycastle.util.Arrays;

public class TlsMac {
    protected TlsContext context;
    protected byte[] secret;
    protected Mac mac;
    protected int digestBlockSize;
    protected int digestOverhead;
    protected int macLength;

    public TlsMac(TlsContext tlsContext, Digest digest, byte[] byArray, int n2, int n3) {
        this.context = tlsContext;
        KeyParameter keyParameter = new KeyParameter(byArray, n2, n3);
        this.secret = Arrays.clone(keyParameter.getKey());
        if (digest instanceof LongDigest) {
            this.digestBlockSize = 128;
            this.digestOverhead = 16;
        } else {
            this.digestBlockSize = 64;
            this.digestOverhead = 8;
        }
        if (TlsUtils.isSSL(tlsContext)) {
            this.mac = new SSL3Mac(digest);
            if (digest.getDigestSize() == 20) {
                this.digestOverhead = 4;
            }
        } else {
            this.mac = new HMac(digest);
        }
        this.mac.init(keyParameter);
        this.macLength = this.mac.getMacSize();
        if (tlsContext.getSecurityParameters().truncatedHMac) {
            this.macLength = Math.min(this.macLength, 10);
        }
    }

    public byte[] getMACSecret() {
        return this.secret;
    }

    public int getSize() {
        return this.macLength;
    }

    public byte[] calculateMac(long l2, short s2, byte[] byArray, int n2, int n3) {
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        boolean bl2 = protocolVersion.isSSL();
        byte[] byArray2 = new byte[bl2 ? 11 : 13];
        TlsUtils.writeUint64(l2, byArray2, 0);
        TlsUtils.writeUint8(s2, byArray2, 8);
        if (!bl2) {
            TlsUtils.writeVersion(protocolVersion, byArray2, 9);
        }
        TlsUtils.writeUint16(n3, byArray2, byArray2.length - 2);
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.update(byArray, n2, n3);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray3, 0);
        return this.truncate(byArray3);
    }

    public byte[] calculateMacConstantTime(long l2, short s2, byte[] byArray, int n2, int n3, int n4, byte[] byArray2) {
        byte[] byArray3 = this.calculateMac(l2, s2, byArray, n2, n3);
        int n5 = TlsUtils.isSSL(this.context) ? 11 : 13;
        int n6 = this.getDigestBlockCount(n5 + n4) - this.getDigestBlockCount(n5 + n3);
        while (--n6 >= 0) {
            this.mac.update(byArray2, 0, this.digestBlockSize);
        }
        this.mac.update(byArray2[0]);
        this.mac.reset();
        return byArray3;
    }

    protected int getDigestBlockCount(int n2) {
        return (n2 + this.digestOverhead) / this.digestBlockSize;
    }

    protected byte[] truncate(byte[] byArray) {
        if (byArray.length <= this.macLength) {
            return byArray;
        }
        return Arrays.copyOf(byArray, this.macLength);
    }
}

