/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.dvcs;

import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSException;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedDataGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.dvcs.DVCSException;
import com.timevale.esign.paas.tgtext.bouncycastle.dvcs.DVCSMessage;
import java.io.IOException;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

