/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.pkcs;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DLSequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.pkcs.ContentInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.pkcs.MacData;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.pkcs.Pfx;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSEncryptedDataGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSException;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.esign.paas.tgtext.bouncycastle.pkcs.MacDataGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.pkcs.PKCS12PfxPdu;
import com.timevale.esign.paas.tgtext.bouncycastle.pkcs.PKCS12SafeBag;
import com.timevale.esign.paas.tgtext.bouncycastle.pkcs.PKCSException;
import com.timevale.esign.paas.tgtext.bouncycastle.pkcs.PKCSIOException;
import java.io.IOException;

public class PKCS12PfxPduBuilder {
    private ASN1EncodableVector dataVector = new ASN1EncodableVector();

    public PKCS12PfxPduBuilder addData(PKCS12SafeBag pKCS12SafeBag) throws IOException {
        this.dataVector.add(new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(new DLSequence(pKCS12SafeBag.toASN1Structure()).getEncoded())));
        return this;
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor outputEncryptor, PKCS12SafeBag pKCS12SafeBag) throws IOException {
        return this.addEncryptedData(outputEncryptor, new DERSequence(pKCS12SafeBag.toASN1Structure()));
    }

    public PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor outputEncryptor, PKCS12SafeBag[] pKCS12SafeBagArray) throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != pKCS12SafeBagArray.length; ++i2) {
            aSN1EncodableVector.add(pKCS12SafeBagArray[i2].toASN1Structure());
        }
        return this.addEncryptedData(outputEncryptor, new DLSequence(aSN1EncodableVector));
    }

    private PKCS12PfxPduBuilder addEncryptedData(OutputEncryptor outputEncryptor, ASN1Sequence aSN1Sequence) throws IOException {
        CMSEncryptedDataGenerator cMSEncryptedDataGenerator = new CMSEncryptedDataGenerator();
        try {
            this.dataVector.add(cMSEncryptedDataGenerator.generate(new CMSProcessableByteArray(aSN1Sequence.getEncoded()), outputEncryptor).toASN1Structure());
        }
        catch (CMSException cMSException) {
            throw new PKCSIOException(cMSException.getMessage(), cMSException.getCause());
        }
        return this;
    }

    public PKCS12PfxPdu build(PKCS12MacCalculatorBuilder pKCS12MacCalculatorBuilder, char[] cArray) throws PKCSException {
        Object object;
        byte[] byArray;
        AuthenticatedSafe authenticatedSafe = AuthenticatedSafe.getInstance(new DLSequence(this.dataVector));
        try {
            byArray = authenticatedSafe.getEncoded();
        }
        catch (IOException iOException) {
            throw new PKCSException("unable to encode AuthenticatedSafe: " + iOException.getMessage(), iOException);
        }
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.data, new DEROctetString(byArray));
        MacData macData = null;
        if (pKCS12MacCalculatorBuilder != null) {
            object = new MacDataGenerator(pKCS12MacCalculatorBuilder);
            macData = ((MacDataGenerator)object).build(cArray, byArray);
        }
        object = new Pfx(contentInfo, macData);
        return new PKCS12PfxPdu((Pfx)object);
    }
}

