/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.asserts;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssertSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssertSupport.class);

    public static void checkPoint(boolean checked, String msg, Object ... args) {
        if (!checked) {
            LOGGER.warn(msg, args);
            LOGGER.warn("check point:", new Throwable());
        }
    }

    public static <T, E extends Exception> T assertNotnull(T t2, E e2) throws E {
        AssertSupport.assertTrue(null != t2, e2);
        return t2;
    }

    public static <T, E extends Exception> void assertNull(T t2, E e2) throws E {
        AssertSupport.assertTrue(null == t2, e2);
    }

    public static <E extends Exception> void assertAllNotnull(E e2, Object ... ts) throws E {
        for (Object object : ts) {
            AssertSupport.assertNotnull(object, e2);
        }
    }

    public static <E extends Exception> void assertNotallNull(E e2, Object ... ts) throws E {
        for (Object object : ts) {
            if (null == object) continue;
            return;
        }
        throw e2;
    }

    public static <T, E extends Exception> Collection<T> assertNotnull(Collection<T> t2, E e2) throws E {
        AssertSupport.assertTrue(null != t2 && !t2.isEmpty(), e2);
        return t2;
    }

    public static <T, E extends Exception> void assertNull(Collection<T> t2, E e2) throws E {
        AssertSupport.assertTrue(null == t2 || t2.isEmpty(), e2);
    }

    public static <T, E extends Exception> T[] assertNotnull(T[] t2, E e2) throws E {
        AssertSupport.assertTrue(null != t2 && t2.length > 0, e2);
        return t2;
    }

    public static <T, E extends Exception> void assertNull(T[] t2, E e2) throws E {
        AssertSupport.assertTrue(null == t2 || 0 == t2.length, e2);
    }

    public static <E extends Exception> String assertNotnull(String t2, E e2) throws E {
        AssertSupport.assertTrue(!StringUtils.isEmpty((String)t2), e2);
        return t2;
    }

    public static <E extends Exception> String assertNull(String t2, E e2) throws E {
        AssertSupport.assertTrue(StringUtils.isEmpty((String)t2), e2);
        return t2;
    }

    public static <E extends Exception> void assertAllNotnull(E e2, String ... ts) throws E {
        for (String string : ts) {
            AssertSupport.assertNotnull(string, e2);
        }
    }

    public static <E extends Exception> void assertNotallNull(E e2, String ... ts) throws E {
        for (String string : ts) {
            if (StringUtils.isEmpty((String)string)) continue;
            return;
        }
        throw e2;
    }

    public static <E extends Exception> void assertTrue(boolean value, E e2) throws E {
        if (!value) {
            throw e2;
        }
    }
}

