/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.timevale.esign.paas.esign.utils.Paging;
import com.timevale.esign.paas.esign.utils.configuration.Configuration;
import com.timevale.esign.paas.esign.utils.exception.Oauth2Exception;
import com.timevale.esign.paas.esign.utils.http.MySSLSocketFactory;
import com.timevale.esign.paas.esign.utils.http.PostParameter;
import com.timevale.esign.paas.esign.utils.http.Response;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.activation.MimetypesFileTypeMap;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HttpClient
implements Serializable {
    private static final long serialVersionUID = -176092625883595547L;
    private static final int OK = 200;
    private static final int NOT_MODIFIED = 304;
    private static final int BAD_REQUEST = 400;
    private static final int NOT_AUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int NOT_ACCEPTABLE = 406;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private String proxyHost = Configuration.getProxyHost();
    private int proxyPort = Configuration.getProxyPort();
    private String proxyAuthUser = Configuration.getProxyUser();
    private String proxyAuthPassword = Configuration.getProxyPassword();
    private String token;
    private static final boolean DEBUG = Configuration.getDebug();
    static Logger log = LoggerFactory.getLogger((String)HttpClient.class.getName());
    org.apache.commons.httpclient.HttpClient client = null;
    private MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = Configuration.getProxyHost(proxyHost);
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = Configuration.getProxyPort(proxyPort);
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void setProxyAuthUser(String proxyAuthUser) {
        this.proxyAuthUser = Configuration.getProxyUser(proxyAuthUser);
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = Configuration.getProxyPassword(proxyAuthPassword);
    }

    public String setToken(String token) {
        this.token = token;
        return this.token;
    }

    public HttpClient() {
        this(150, 300000, 300000, 0x100000);
    }

    public HttpClient(int maxConPerHost, int conTimeOutMs, int soTimeOutMs, int maxSize) {
        HttpConnectionManagerParams httpConnectionManagerParams = this.connectionManager.getParams();
        httpConnectionManagerParams.setDefaultMaxConnectionsPerHost(maxConPerHost);
        httpConnectionManagerParams.setConnectionTimeout(conTimeOutMs);
        httpConnectionManagerParams.setSoTimeout(soTimeOutMs);
        HttpClientParams httpClientParams = new HttpClientParams();
        httpClientParams.setCookiePolicy("ignoreCookies");
        this.client = new org.apache.commons.httpclient.HttpClient(httpClientParams, (HttpConnectionManager)this.connectionManager);
        Protocol protocol = new Protocol("https", (ProtocolSocketFactory)new MySSLSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)protocol);
        if (this.proxyHost != null && !this.proxyHost.equals("")) {
            this.client.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
            this.client.getParams().setAuthenticationPreemptive(true);
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                this.client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.proxyAuthUser, this.proxyAuthPassword));
                HttpClient.log("Proxy AuthUser: " + this.proxyAuthUser);
                HttpClient.log("Proxy AuthPassword: " + this.proxyAuthPassword);
            }
        }
    }

    private static void log(String message) {
        if (DEBUG) {
            log.debug(message);
        }
    }

    public Response get(String url) throws Oauth2Exception {
        return this.get(url, new PostParameter[0]);
    }

    public Response get(String url, PostParameter[] params) throws Oauth2Exception {
        Object object;
        HttpClient.log("Request:");
        HttpClient.log("GET:" + url);
        if (null != params && params.length > 0) {
            object = HttpClient.encodeParameters(params);
            url = -1 == url.indexOf("?") ? url + "?" + (String)object : url + "&" + (String)object;
        }
        object = new GetMethod(url);
        return this.httpRequest((HttpMethod)object);
    }

    public Response get(String url, PostParameter[] params, Paging paging) throws Oauth2Exception {
        if (null != paging) {
            ArrayList<PostParameter> arrayList = new ArrayList<PostParameter>(4);
            if (-1L != paging.getMaxId()) {
                arrayList.add(new PostParameter("max_id", String.valueOf(paging.getMaxId())));
            }
            if (-1L != paging.getSinceId()) {
                arrayList.add(new PostParameter("since_id", String.valueOf(paging.getSinceId())));
            }
            if (-1 != paging.getPage()) {
                arrayList.add(new PostParameter("page", String.valueOf(paging.getPage())));
            }
            if (-1 != paging.getCount()) {
                if (-1 != url.indexOf("search")) {
                    arrayList.add(new PostParameter("rpp", String.valueOf(paging.getCount())));
                } else {
                    arrayList.add(new PostParameter("count", String.valueOf(paging.getCount())));
                }
            }
            PostParameter[] postParameterArray = null;
            PostParameter[] postParameterArray2 = arrayList.toArray(new PostParameter[arrayList.size()]);
            if (null != params) {
                postParameterArray = new PostParameter[params.length + arrayList.size()];
                System.arraycopy(params, 0, postParameterArray, 0, params.length);
                System.arraycopy(postParameterArray2, 0, postParameterArray, params.length, arrayList.size());
            } else if (0 != postParameterArray2.length) {
                String string = HttpClient.encodeParameters(postParameterArray2);
                url = -1 != url.indexOf("?") ? url + "&" + string : url + "?" + string;
            }
            return this.get(url, postParameterArray);
        }
        return this.get(url, params);
    }

    public Response delete(String url, PostParameter[] params) throws Oauth2Exception {
        String string;
        if (0 != params.length) {
            string = HttpClient.encodeParameters(params);
            url = -1 == url.indexOf("?") ? url + "?" + string : url + "&" + string;
        }
        string = new DeleteMethod(url);
        return this.httpRequest((HttpMethod)string);
    }

    public Response post(String url, PostParameter[] params) throws Oauth2Exception {
        return this.post(url, params, true);
    }

    public Response post(String url, PostParameter[] params, Boolean WithTokenHeader) throws Oauth2Exception {
        HttpClient.log("Request:");
        HttpClient.log("POST" + url);
        PostMethod postMethod = new PostMethod(url);
        for (int i2 = 0; i2 < params.length; ++i2) {
            postMethod.addParameter(params[i2].getName(), params[i2].getValue());
        }
        HttpMethodParams httpMethodParams = postMethod.getParams();
        httpMethodParams.setContentCharset("UTF-8");
        if (WithTokenHeader.booleanValue()) {
            return this.httpRequest((HttpMethod)postMethod);
        }
        return this.httpRequest((HttpMethod)postMethod, WithTokenHeader);
    }

    public Response postBody(String url, JSONObject content, Boolean WithTokenHeader) throws Oauth2Exception {
        HttpClient.log("Request:");
        HttpClient.log("POST" + url);
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Content-Type", "application/json;charset=utf-8");
        postMethod.setRequestHeader("Accept", "application/json");
        postMethod.setRequestBody(content.toString());
        HttpMethodParams httpMethodParams = postMethod.getParams();
        httpMethodParams.setContentCharset("UTF-8");
        if (WithTokenHeader.booleanValue()) {
            return this.httpRequest((HttpMethod)postMethod);
        }
        return this.httpRequest((HttpMethod)postMethod, WithTokenHeader);
    }

    public Response postBody(String url, JsonObject content, Boolean WithTokenHeader) throws Oauth2Exception {
        HttpClient.log("Request:");
        HttpClient.log("POST" + url);
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Content-Type", "application/json;charset=utf-8");
        postMethod.setRequestHeader("Accept", "application/json");
        postMethod.setRequestBody(new Gson().toJson((JsonElement)content));
        HttpMethodParams httpMethodParams = postMethod.getParams();
        httpMethodParams.setContentCharset("UTF-8");
        if (WithTokenHeader.booleanValue()) {
            return this.httpRequest((HttpMethod)postMethod);
        }
        return this.httpRequest((HttpMethod)postMethod, WithTokenHeader);
    }

    public Response multPartPost(String url, PostParameter[] params, String fileParamName, File file, boolean authenticated) throws Oauth2Exception {
        PostMethod postMethod = new PostMethod(url);
        try {
            Part[] partArray = null;
            partArray = file != null ? (params == null ? new Part[1] : new Part[params.length + 1]) : (params == null ? new Part[1] : new Part[params.length]);
            if (params != null) {
                int n2 = 0;
                for (PostParameter postParameter : params) {
                    partArray[n2++] = new StringPart(postParameter.getName(), postParameter.getValue(), "UTF-8");
                }
            }
            if (file != null) {
                FilePart filePart = new FilePart(fileParamName, file.getName(), file, new MimetypesFileTypeMap().getContentType(file), "UTF-8");
                filePart.setTransferEncoding("binary");
                partArray[partArray.length - 1] = filePart;
            }
            HttpMethodParams httpMethodParams = postMethod.getParams();
            httpMethodParams.setContentCharset("UTF-8");
            postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(partArray, postMethod.getParams()));
            return this.httpRequest((HttpMethod)postMethod, authenticated);
        }
        catch (Exception exception) {
            throw new Oauth2Exception(exception.getMessage(), exception, -1);
        }
    }

    public Response httpRequest(HttpMethod method) throws Oauth2Exception {
        return this.httpRequest(method, true);
    }

    public Response httpRequest(HttpMethod method, Boolean WithTokenHeader) throws Oauth2Exception {
        int n2 = -1;
        try {
            Object object2;
            InetAddress inetAddress = InetAddress.getLocalHost();
            ArrayList<Header> arrayList = new ArrayList<Header>();
            if (WithTokenHeader.booleanValue()) {
                if (this.token == null) {
                    throw new IllegalStateException("Oauth2 token is not set!");
                }
                arrayList.add(new Header("Authorization", "OAuth2 " + this.token));
                arrayList.add(new Header("API-RemoteIP", inetAddress.getHostAddress()));
                this.client.getHostConfiguration().getParams().setParameter("http.default-headers", arrayList);
                for (Object object2 : arrayList) {
                    HttpClient.log(object2.getName() + ": " + object2.getValue());
                }
            }
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            this.client.executeMethod(method);
            n2 = method.getStatusCode();
            HttpClient.log("Response:");
            HttpClient.log("https StatusCode:" + String.valueOf(n2));
            Response response = new Response();
            response.setResponseAsString(method.getResponseBodyAsString());
            HttpClient.log(response.toString() + "\n");
            if (n2 != 200) {
                try {
                    throw new Oauth2Exception(HttpClient.getCause(n2), response.asJSONObject(), method.getStatusCode());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            object2 = response;
            return object2;
        }
        catch (IOException iOException) {
            throw new Oauth2Exception(iOException.getMessage(), iOException, n2);
        }
        finally {
            method.releaseConnection();
        }
    }

    public static String encodeParameters(PostParameter[] postParams) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < postParams.length; ++i2) {
            if (i2 != 0) {
                stringBuffer.append("&");
            }
            try {
                stringBuffer.append(URLEncoder.encode(postParams[i2].getName(), "UTF-8")).append("=").append(URLEncoder.encode(postParams[i2].getValue(), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private static String getCause(int statusCode) {
        String string = null;
        switch (statusCode) {
            case 304: {
                break;
            }
            case 400: {
                string = "The request was invalid.  An accompanying error message will explain why. This is the status code will be returned during rate limiting.";
                break;
            }
            case 401: {
                string = "Authentication credentials were missing or incorrect.";
                break;
            }
            case 403: {
                string = "The request is understood, but it has been refused.  An accompanying error message will explain why.";
                break;
            }
            case 404: {
                string = "The URI requested is invalid or the resource requested, such as a user, does not exists.";
                break;
            }
            case 406: {
                string = "Returned by the Search API when an invalid format is specified in the request.";
                break;
            }
            case 500: {
                string = "Something is broken.  Please post to the group so the Weibo team can investigate.";
                break;
            }
            case 502: {
                string = "Weibo is down or being upgraded.";
                break;
            }
            case 503: {
                string = "Service Unavailable: The Weibo servers are up, but overloaded with requests. Try again later. The search and trend methods use this to indicate when you are being rate limited.";
                break;
            }
            default: {
                string = "";
            }
        }
        return statusCode + ":" + string;
    }

    public String getToken() {
        return this.token;
    }
}

