/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.httpclient;

import com.timevale.esign.paas.esign.utils.JsonHelper;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.httpclient.HttpConfig;
import com.timevale.esign.paas.esign.utils.httpclient.INtmResponseParser;
import com.timevale.esign.paas.esign.utils.httpclient.IResponseParser;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConfigT<T>
extends HttpConfig {
    private final INtmResponseParser<T> DEFAULT = new INtmResponseParser<T>(){

        @Override
        public T parse(int code, byte[] data, String charset) throws SuperException {
            return this.parse(data, charset);
        }

        @Override
        public T parse(byte[] data, String charset) throws SuperException {
            String string;
            try {
                string = new String(data, charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.error("unsupport charset.", (Throwable)unsupportedEncodingException);
                throw ErrorsDiscriptor.UnsupportCharset.e(charset);
            }
            if (HttpConfigT.this.responseClass.equals(String.class)) {
                String string2 = string;
                return string2;
            }
            try {
                return JsonHelper.fromString(string, HttpConfigT.this.responseClass);
            }
            catch (Throwable throwable) {
                LOGGER.error("this json is not available. input:{}", (Object)string);
                throw ErrorsDiscriptor.InternalService.e(throwable);
            }
        }
    };
    private IResponseParser<T> parser = this.DEFAULT;
    private Class<T> responseClass;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConfigT.class);

    public HttpConfigT(Class<T> responseClass) {
        this.responseClass = responseClass;
    }

    public HttpConfigT(Class<T> responseClass, IResponseParser<T> parser) {
        this.responseClass = responseClass;
        this.parser = parser;
    }

    public HttpConfigT(Class<T> responseClass, IResponseParser<T> parser, HttpConfig config) {
        this.responseClass = responseClass;
        this.parser = parser;
        this.cloneFrom(config);
    }

    public T parse(byte[] data, String charset) throws SuperException {
        if (null == this.parser) {
            byte[] byArray = data;
            return (T)byArray;
        }
        return this.parser.parse(data, charset);
    }

    public T parse(int code, byte[] data, String charset) throws SuperException {
        if (null == this.parser) {
            byte[] byArray = data;
            return (T)byArray;
        }
        if (INtmResponseParser.class.isAssignableFrom(this.parser.getClass())) {
            return ((INtmResponseParser)this.parser).parse(code, data, charset);
        }
        return this.parser.parse(data, charset);
    }
}

