/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.network;

import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.network.constants.NtmScheme;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtmHost {
    private String host;
    private int port;
    private NtmScheme scheme;
    private static final Logger LOGGER = LoggerFactory.getLogger(NtmHost.class);

    public NtmHost(String uri) throws SuperException {
        URI uRI;
        try {
            uRI = new URI(uri);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.error("invalid uri. uri:{}", (Object)uri);
            throw ErrorsDiscriptor.InvalidFormatUrl.e(uRISyntaxException);
        }
        this.init(NtmScheme.from(uRI.getScheme()), uRI.getHost(), uRI.getPort());
    }

    public NtmHost(NtmScheme scheme, String host, int port) {
        this.init(scheme, host, port);
    }

    public String toHostURI() {
        return this.scheme.discription() + "://" + this.host + ":" + this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public NtmScheme getScheme() {
        return this.scheme;
    }

    private void init(NtmScheme scheme, String host, int port) {
        this.scheme = scheme;
        this.host = host;
        this.port = port <= 0 ? scheme.defaultPort() : port;
    }
}

