/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.esign.utils.security;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAKeyUtil {
    private static final String[] TRIMS = new String[]{"(?i)-----BEGIN PUBLIC KEY-----", "(?i)-----END PUBLIC KEY-----", "(?i)-----BEGIN PRIVATE KEY-----", "(?i)-----END PRIVATE KEY-----", "\r", "\n"};
    private static String trimmer;

    public static PublicKey parsePublieKey(KeyFactory fac, byte[] input) throws InvalidKeySpecException {
        return fac.generatePublic(new X509EncodedKeySpec(input));
    }

    public static PrivateKey parsePrivateKey(KeyFactory fac, byte[] input) throws InvalidKeySpecException {
        return fac.generatePrivate(new PKCS8EncodedKeySpec(input));
    }

    public static String preParseRsaKey(String key) {
        return key.replaceAll(trimmer, "");
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : TRIMS) {
            stringBuilder.append(string).append('|');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        trimmer = stringBuilder.toString();
    }
}

