/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.base.Objects;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractIndexedListIterator;
import com.timevale.esign.paas.guava.common.collect.AbstractMapEntry;
import com.timevale.esign.paas.guava.common.collect.ImmutableList;
import com.timevale.esign.paas.guava.common.collect.ImmutableMap;
import com.timevale.esign.paas.guava.common.collect.ImmutableSet;
import com.timevale.esign.paas.guava.common.collect.Maps;
import com.timevale.esign.paas.guava.common.collect.Table;
import com.timevale.esign.paas.guava.common.collect.Tables;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@Beta
public final class ArrayTable<R, C, V>
implements Table<R, C, V>,
Serializable {
    private final ImmutableList<R> rowList;
    private final ImmutableList<C> columnList;
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final V[][] array;
    private transient CellSet cellSet;
    private transient ColumnMap columnMap;
    private transient RowMap rowMap;
    private transient Collection<V> values;
    private static final long serialVersionUID = 0L;

    public static <R, C, V> ArrayTable<R, C, V> create(Iterable<? extends R> rowKeys, Iterable<? extends C> columnKeys) {
        return new ArrayTable<R, C, V>(rowKeys, columnKeys);
    }

    public static <R, C, V> ArrayTable<R, C, V> create(Table<R, C, V> table) {
        return new ArrayTable<R, C, V>(table);
    }

    public static <R, C, V> ArrayTable<R, C, V> create(ArrayTable<R, C, V> table) {
        return new ArrayTable<R, C, V>(table);
    }

    private ArrayTable(Iterable<? extends R> rowKeys, Iterable<? extends C> columnKeys) {
        this.rowList = ImmutableList.copyOf(rowKeys);
        this.columnList = ImmutableList.copyOf(columnKeys);
        Preconditions.checkArgument(!this.rowList.isEmpty());
        Preconditions.checkArgument(!this.columnList.isEmpty());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i2 = 0; i2 < this.rowList.size(); ++i2) {
            builder.put(this.rowList.get(i2), i2);
        }
        this.rowKeyToIndex = builder.build();
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (int i3 = 0; i3 < this.columnList.size(); ++i3) {
            builder2.put(this.columnList.get(i3), i3);
        }
        this.columnKeyToIndex = builder2.build();
        Object[][] objectArray = new Object[this.rowList.size()][this.columnList.size()];
        this.array = objectArray;
    }

    private ArrayTable(Table<R, C, V> table) {
        this(table.rowKeySet(), table.columnKeySet());
        this.putAll(table);
    }

    private ArrayTable(ArrayTable<R, C, V> table) {
        this.rowList = table.rowList;
        this.columnList = table.columnList;
        this.rowKeyToIndex = table.rowKeyToIndex;
        this.columnKeyToIndex = table.columnKeyToIndex;
        Object[][] objectArray = new Object[this.rowList.size()][this.columnList.size()];
        this.array = objectArray;
        for (int i2 = 0; i2 < this.rowList.size(); ++i2) {
            System.arraycopy(table.array[i2], 0, objectArray[i2], 0, table.array[i2].length);
        }
    }

    public ImmutableList<R> rowKeyList() {
        return this.rowList;
    }

    public ImmutableList<C> columnKeyList() {
        return this.columnList;
    }

    public V at(int rowIndex, int columnIndex) {
        return this.array[rowIndex][columnIndex];
    }

    public V set(int rowIndex, int columnIndex, @Nullable V value) {
        V v2 = this.array[rowIndex][columnIndex];
        this.array[rowIndex][columnIndex] = value;
        return v2;
    }

    public V[][] toArray(Class<V> valueClass) {
        Object[][] objectArray = (Object[][])Array.newInstance(valueClass, this.rowList.size(), this.columnList.size());
        for (int i2 = 0; i2 < this.rowList.size(); ++i2) {
            System.arraycopy(this.array[i2], 0, objectArray[i2], 0, this.array[i2].length);
        }
        return objectArray;
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void eraseAll() {
        for (Object[] objectArray : this.array) {
            Arrays.fill(objectArray, null);
        }
    }

    @Override
    public boolean contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        return this.containsRow(rowKey) && this.containsColumn(columnKey);
    }

    @Override
    public boolean containsColumn(@Nullable Object columnKey) {
        return this.columnKeyToIndex.containsKey(columnKey);
    }

    @Override
    public boolean containsRow(@Nullable Object rowKey) {
        return this.rowKeyToIndex.containsKey(rowKey);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        V[][] VArray = this.array;
        int n2 = VArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V[] VArray2;
            for (V v2 : VArray2 = VArray[i2]) {
                if (!Objects.equal(value, v2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        Integer n2 = this.rowKeyToIndex.get(rowKey);
        Integer n3 = this.columnKeyToIndex.get(columnKey);
        return this.getIndexed(n2, n3);
    }

    private V getIndexed(Integer rowIndex, Integer columnIndex) {
        return rowIndex == null || columnIndex == null ? null : (V)this.array[rowIndex][columnIndex];
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public V put(R rowKey, C columnKey, @Nullable V value) {
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(columnKey);
        Integer n2 = this.rowKeyToIndex.get(rowKey);
        Preconditions.checkArgument(n2 != null, "Row %s not in %s", rowKey, this.rowList);
        Integer n3 = this.columnKeyToIndex.get(columnKey);
        Preconditions.checkArgument(n3 != null, "Column %s not in %s", columnKey, this.columnList);
        return this.set(n2, n3, value);
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell<R, C, V> cell : table.cellSet()) {
            this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    @Override
    @Deprecated
    public V remove(Object rowKey, Object columnKey) {
        throw new UnsupportedOperationException();
    }

    public V erase(@Nullable Object rowKey, @Nullable Object columnKey) {
        Integer n2 = this.rowKeyToIndex.get(rowKey);
        Integer n3 = this.columnKeyToIndex.get(columnKey);
        if (n2 == null || n3 == null) {
            return null;
        }
        return this.set(n2, n3, null);
    }

    @Override
    public int size() {
        return this.rowList.size() * this.columnList.size();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof Table) {
            Table table = (Table)obj;
            return ((Object)this.cellSet()).equals(table.cellSet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.cellSet()).hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        CellSet cellSet = this.cellSet;
        return cellSet == null ? (this.cellSet = new CellSet()) : cellSet;
    }

    @Override
    public Map<R, V> column(C columnKey) {
        Preconditions.checkNotNull(columnKey);
        Integer n2 = this.columnKeyToIndex.get(columnKey);
        return n2 == null ? ImmutableMap.of() : new Column(n2);
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return this.columnKeyToIndex.keySet();
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap columnMap = this.columnMap;
        return columnMap == null ? (this.columnMap = new ColumnMap()) : columnMap;
    }

    @Override
    public Map<C, V> row(R rowKey) {
        Preconditions.checkNotNull(rowKey);
        Integer n2 = this.rowKeyToIndex.get(rowKey);
        return n2 == null ? ImmutableMap.of() : new Row(n2);
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return this.rowKeyToIndex.keySet();
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        RowMap rowMap = this.rowMap;
        return rowMap == null ? (this.rowMap = new RowMap()) : rowMap;
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values == null ? (this.values = new Values()) : values;
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new AbstractIndexedListIterator<V>(this.size()){

                @Override
                protected V get(int index) {
                    int n2 = index / ArrayTable.this.columnList.size();
                    int n3 = index % ArrayTable.this.columnList.size();
                    return ArrayTable.this.array[n2][n3];
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.size();
        }

        @Override
        public boolean contains(Object value) {
            return ArrayTable.this.containsValue(value);
        }
    }

    private class RowMapEntrySet
    extends AbstractSet<Map.Entry<R, Map<C, V>>> {
        private RowMapEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<R, Map<C, V>>> iterator() {
            return new AbstractIndexedListIterator<Map.Entry<R, Map<C, V>>>(this.size()){

                @Override
                protected Map.Entry<R, Map<C, V>> get(int index) {
                    return Maps.immutableEntry(ArrayTable.this.rowList.get(index), new Row(index));
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.rowList.size();
        }
    }

    private class RowMap
    extends AbstractMap<R, Map<C, V>> {
        transient RowMapEntrySet entrySet;

        private RowMap() {
        }

        @Override
        public Set<Map.Entry<R, Map<C, V>>> entrySet() {
            RowMapEntrySet rowMapEntrySet = this.entrySet;
            return rowMapEntrySet == null ? (this.entrySet = new RowMapEntrySet()) : rowMapEntrySet;
        }

        @Override
        public Map<C, V> get(Object rowKey) {
            Integer n2 = (Integer)ArrayTable.this.rowKeyToIndex.get(rowKey);
            return n2 == null ? null : new Row(n2);
        }

        @Override
        public boolean containsKey(Object rowKey) {
            return ArrayTable.this.containsRow(rowKey);
        }

        @Override
        public Set<R> keySet() {
            return ArrayTable.this.rowKeySet();
        }

        @Override
        public Map<C, V> remove(Object rowKey) {
            throw new UnsupportedOperationException();
        }
    }

    private class RowEntrySet
    extends AbstractSet<Map.Entry<C, V>> {
        final int rowIndex;

        RowEntrySet(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public Iterator<Map.Entry<C, V>> iterator() {
            return new AbstractIndexedListIterator<Map.Entry<C, V>>(this.size()){

                @Override
                protected Map.Entry<C, V> get(final int columnIndex) {
                    return new AbstractMapEntry<C, V>(){

                        @Override
                        public C getKey() {
                            return ArrayTable.this.columnList.get(columnIndex);
                        }

                        @Override
                        public V getValue() {
                            return ArrayTable.this.array[RowEntrySet.this.rowIndex][columnIndex];
                        }

                        @Override
                        public V setValue(V value) {
                            return ArrayTable.this.set(RowEntrySet.this.rowIndex, columnIndex, value);
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.columnList.size();
        }
    }

    private class Row
    extends AbstractMap<C, V> {
        final int rowIndex;
        RowEntrySet entrySet;

        Row(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public Set<Map.Entry<C, V>> entrySet() {
            RowEntrySet rowEntrySet = this.entrySet;
            return rowEntrySet == null ? (this.entrySet = new RowEntrySet(this.rowIndex)) : rowEntrySet;
        }

        @Override
        public V get(Object columnKey) {
            Integer n2 = (Integer)ArrayTable.this.columnKeyToIndex.get(columnKey);
            return ArrayTable.this.getIndexed(this.rowIndex, n2);
        }

        @Override
        public boolean containsKey(Object columnKey) {
            return ArrayTable.this.containsColumn(columnKey);
        }

        @Override
        public V put(C columnKey, V value) {
            Preconditions.checkNotNull(columnKey);
            Integer n2 = (Integer)ArrayTable.this.columnKeyToIndex.get(columnKey);
            Preconditions.checkArgument(n2 != null, "Column %s not in %s", columnKey, ArrayTable.this.columnList);
            return ArrayTable.this.set(this.rowIndex, n2, value);
        }

        @Override
        public Set<C> keySet() {
            return ArrayTable.this.columnKeySet();
        }
    }

    private class ColumnMapEntrySet
    extends AbstractSet<Map.Entry<C, Map<R, V>>> {
        private ColumnMapEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
            return new AbstractIndexedListIterator<Map.Entry<C, Map<R, V>>>(this.size()){

                @Override
                protected Map.Entry<C, Map<R, V>> get(int index) {
                    return Maps.immutableEntry(ArrayTable.this.columnList.get(index), new Column(index));
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.columnList.size();
        }
    }

    private class ColumnMap
    extends AbstractMap<C, Map<R, V>> {
        transient ColumnMapEntrySet entrySet;

        private ColumnMap() {
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> entrySet() {
            ColumnMapEntrySet columnMapEntrySet = this.entrySet;
            return columnMapEntrySet == null ? (this.entrySet = new ColumnMapEntrySet()) : columnMapEntrySet;
        }

        @Override
        public Map<R, V> get(Object columnKey) {
            Integer n2 = (Integer)ArrayTable.this.columnKeyToIndex.get(columnKey);
            return n2 == null ? null : new Column(n2);
        }

        @Override
        public boolean containsKey(Object columnKey) {
            return ArrayTable.this.containsColumn(columnKey);
        }

        @Override
        public Set<C> keySet() {
            return ArrayTable.this.columnKeySet();
        }

        @Override
        public Map<R, V> remove(Object columnKey) {
            throw new UnsupportedOperationException();
        }
    }

    private class ColumnEntrySet
    extends AbstractSet<Map.Entry<R, V>> {
        final int columnIndex;

        ColumnEntrySet(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public Iterator<Map.Entry<R, V>> iterator() {
            return new AbstractIndexedListIterator<Map.Entry<R, V>>(this.size()){

                @Override
                protected Map.Entry<R, V> get(final int rowIndex) {
                    return new AbstractMapEntry<R, V>(){

                        @Override
                        public R getKey() {
                            return ArrayTable.this.rowList.get(rowIndex);
                        }

                        @Override
                        public V getValue() {
                            return ArrayTable.this.array[rowIndex][ColumnEntrySet.this.columnIndex];
                        }

                        @Override
                        public V setValue(V value) {
                            return ArrayTable.this.set(rowIndex, ColumnEntrySet.this.columnIndex, value);
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.rowList.size();
        }
    }

    private class Column
    extends AbstractMap<R, V> {
        final int columnIndex;
        ColumnEntrySet entrySet;

        Column(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public Set<Map.Entry<R, V>> entrySet() {
            ColumnEntrySet columnEntrySet = this.entrySet;
            return columnEntrySet == null ? (this.entrySet = new ColumnEntrySet(this.columnIndex)) : columnEntrySet;
        }

        @Override
        public V get(Object rowKey) {
            Integer n2 = (Integer)ArrayTable.this.rowKeyToIndex.get(rowKey);
            return ArrayTable.this.getIndexed(n2, this.columnIndex);
        }

        @Override
        public boolean containsKey(Object rowKey) {
            return ArrayTable.this.rowKeyToIndex.containsKey(rowKey);
        }

        @Override
        public V put(R rowKey, V value) {
            Preconditions.checkNotNull(rowKey);
            Integer n2 = (Integer)ArrayTable.this.rowKeyToIndex.get(rowKey);
            Preconditions.checkArgument(n2 != null, "Row %s not in %s", rowKey, ArrayTable.this.rowList);
            return ArrayTable.this.set(n2, this.columnIndex, value);
        }

        @Override
        public Set<R> keySet() {
            return ArrayTable.this.rowKeySet();
        }
    }

    private class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return new AbstractIndexedListIterator<Table.Cell<R, C, V>>(this.size()){

                @Override
                protected Table.Cell<R, C, V> get(final int index) {
                    return new Tables.AbstractCell<R, C, V>(){
                        final int rowIndex;
                        final int columnIndex;
                        {
                            this.rowIndex = index / ArrayTable.this.columnList.size();
                            this.columnIndex = index % ArrayTable.this.columnList.size();
                        }

                        @Override
                        public R getRowKey() {
                            return ArrayTable.this.rowList.get(this.rowIndex);
                        }

                        @Override
                        public C getColumnKey() {
                            return ArrayTable.this.columnList.get(this.columnIndex);
                        }

                        @Override
                        public V getValue() {
                            return ArrayTable.this.array[this.rowIndex][this.columnIndex];
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.size();
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)obj;
                Integer n2 = (Integer)ArrayTable.this.rowKeyToIndex.get(cell.getRowKey());
                Integer n3 = (Integer)ArrayTable.this.columnKeyToIndex.get(cell.getColumnKey());
                return n2 != null && n3 != null && Objects.equal(ArrayTable.this.array[n2][n3], cell.getValue());
            }
            return false;
        }
    }
}

