/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.base.Optional;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.BstNode;
import com.timevale.esign.paas.guava.common.collect.BstPath;
import com.timevale.esign.paas.guava.common.collect.BstPathFactory;
import com.timevale.esign.paas.guava.common.collect.BstSide;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

@GwtCompatible
final class BstInOrderPath<N extends BstNode<?, N>>
extends BstPath<N, BstInOrderPath<N>> {
    private final BstSide sideExtension;
    private transient Optional<BstInOrderPath<N>> prevInOrder;
    private transient Optional<BstInOrderPath<N>> nextInOrder;

    public static <N extends BstNode<?, N>> BstPathFactory<N, BstInOrderPath<N>> inOrderFactory() {
        return new BstPathFactory<N, BstInOrderPath<N>>(){

            @Override
            public BstInOrderPath<N> extension(BstInOrderPath<N> path, BstSide side) {
                return BstInOrderPath.extension(path, side);
            }

            @Override
            public BstInOrderPath<N> initialPath(N root) {
                return new BstInOrderPath((BstNode)root, null, null, null);
            }
        };
    }

    private static <N extends BstNode<?, N>> BstInOrderPath<N> extension(BstInOrderPath<N> path, BstSide side) {
        Preconditions.checkNotNull(path);
        Object n2 = path.getTip();
        return new BstInOrderPath<N>(((BstNode)n2).getChild(side), side, path);
    }

    private BstInOrderPath(N tip, @Nullable BstSide sideExtension, @Nullable BstInOrderPath<N> tail) {
        super(tip, tail);
        this.sideExtension = sideExtension;
        assert (sideExtension == null == (tail == null));
    }

    private Optional<BstInOrderPath<N>> computeNextInOrder(BstSide side) {
        if (((BstNode)this.getTip()).hasChild(side)) {
            BstInOrderPath<N> bstInOrderPath = BstInOrderPath.extension(this, side);
            BstSide bstSide = side.other();
            while (((BstNode)bstInOrderPath.getTip()).hasChild(bstSide)) {
                bstInOrderPath = BstInOrderPath.extension(bstInOrderPath, bstSide);
            }
            return Optional.of(bstInOrderPath);
        }
        BstInOrderPath bstInOrderPath = this;
        while (bstInOrderPath.sideExtension == side) {
            bstInOrderPath = (BstInOrderPath)bstInOrderPath.getPrefix();
        }
        bstInOrderPath = (BstInOrderPath)bstInOrderPath.prefixOrNull();
        return Optional.fromNullable(bstInOrderPath);
    }

    private Optional<BstInOrderPath<N>> nextInOrder(BstSide side) {
        switch (side) {
            case LEFT: {
                Optional<BstInOrderPath<N>> optional = this.prevInOrder;
                return optional == null ? (this.prevInOrder = this.computeNextInOrder(side)) : optional;
            }
            case RIGHT: {
                Optional<BstInOrderPath<N>> optional = this.nextInOrder;
                return optional == null ? (this.nextInOrder = this.computeNextInOrder(side)) : optional;
            }
        }
        throw new AssertionError();
    }

    public boolean hasNext(BstSide side) {
        return this.nextInOrder(side).isPresent();
    }

    public BstInOrderPath<N> next(BstSide side) {
        if (!this.hasNext(side)) {
            throw new NoSuchElementException();
        }
        return this.nextInOrder(side).get();
    }

    public BstSide getSideOfExtension() {
        return this.sideExtension;
    }

    /* synthetic */ BstInOrderPath(BstNode x0, BstSide x1, BstInOrderPath x2, 1 x3) {
        this(x0, x1, x2);
    }
}

