/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.collect.DiscreteDomain;
import java.io.Serializable;
import java.math.BigInteger;

@GwtCompatible
@Beta
public final class DiscreteDomains {
    private DiscreteDomains() {
    }

    public static DiscreteDomain<Integer> integers() {
        return IntegerDomain.INSTANCE;
    }

    public static DiscreteDomain<Long> longs() {
        return LongDomain.INSTANCE;
    }

    static DiscreteDomain<BigInteger> bigIntegers() {
        return BigIntegerDomain.INSTANCE;
    }

    private static final class BigIntegerDomain
    extends DiscreteDomain<BigInteger>
    implements Serializable {
        private static final BigIntegerDomain INSTANCE = new BigIntegerDomain();
        private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        private static final long serialVersionUID = 0L;

        private BigIntegerDomain() {
        }

        @Override
        public BigInteger next(BigInteger value) {
            return value.add(BigInteger.ONE);
        }

        @Override
        public BigInteger previous(BigInteger value) {
            return value.subtract(BigInteger.ONE);
        }

        @Override
        public long distance(BigInteger start, BigInteger end) {
            return start.subtract(end).max(MIN_LONG).min(MAX_LONG).longValue();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class LongDomain
    extends DiscreteDomain<Long>
    implements Serializable {
        private static final LongDomain INSTANCE = new LongDomain();
        private static final long serialVersionUID = 0L;

        private LongDomain() {
        }

        @Override
        public Long next(Long value) {
            long l2 = value;
            return l2 == Long.MAX_VALUE ? null : Long.valueOf(l2 + 1L);
        }

        @Override
        public Long previous(Long value) {
            long l2 = value;
            return l2 == Long.MIN_VALUE ? null : Long.valueOf(l2 - 1L);
        }

        @Override
        public long distance(Long start, Long end) {
            long l2 = end - start;
            if (end > start && l2 < 0L) {
                return Long.MAX_VALUE;
            }
            if (end < start && l2 > 0L) {
                return Long.MIN_VALUE;
            }
            return l2;
        }

        @Override
        public Long minValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long maxValue() {
            return Long.MAX_VALUE;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class IntegerDomain
    extends DiscreteDomain<Integer>
    implements Serializable {
        private static final IntegerDomain INSTANCE = new IntegerDomain();
        private static final long serialVersionUID = 0L;

        private IntegerDomain() {
        }

        @Override
        public Integer next(Integer value) {
            int n2 = value;
            return n2 == Integer.MAX_VALUE ? null : Integer.valueOf(n2 + 1);
        }

        @Override
        public Integer previous(Integer value) {
            int n2 = value;
            return n2 == Integer.MIN_VALUE ? null : Integer.valueOf(n2 - 1);
        }

        @Override
        public long distance(Integer start, Integer end) {
            return (long)end.intValue() - (long)start.intValue();
        }

        @Override
        public Integer minValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer maxValue() {
            return Integer.MAX_VALUE;
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

