/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.collect;

import com.timevale.esign.paas.guava.common.annotations.GwtCompatible;
import com.timevale.esign.paas.guava.common.annotations.GwtIncompatible;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.collect.AbstractLinkedIterator;
import com.timevale.esign.paas.guava.common.collect.BoundType;
import com.timevale.esign.paas.guava.common.collect.ContiguousSet;
import com.timevale.esign.paas.guava.common.collect.DiscreteDomain;
import com.timevale.esign.paas.guava.common.collect.EmptyContiguousSet;
import com.timevale.esign.paas.guava.common.collect.ObjectArrays;
import com.timevale.esign.paas.guava.common.collect.Ordering;
import com.timevale.esign.paas.guava.common.collect.Range;
import com.timevale.esign.paas.guava.common.collect.Ranges;
import com.timevale.esign.paas.guava.common.collect.Sets;
import com.timevale.esign.paas.guava.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
final class RegularContiguousSet<C extends Comparable>
extends ContiguousSet<C> {
    private final Range<C> range;
    private static final long serialVersionUID = 0L;

    RegularContiguousSet(Range<C> range, DiscreteDomain<C> domain) {
        super(domain);
        this.range = range;
    }

    @Override
    ContiguousSet<C> headSetImpl(C toElement, boolean inclusive) {
        return this.range.intersection(Ranges.upTo(toElement, BoundType.forBoolean(inclusive))).asSet(this.domain);
    }

    @Override
    int indexOf(Object target) {
        return this.contains(target) ? (int)this.domain.distance(this.first(), (Comparable)target) : -1;
    }

    @Override
    ContiguousSet<C> subSetImpl(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
        return this.range.intersection(Ranges.range(fromElement, BoundType.forBoolean(fromInclusive), toElement, BoundType.forBoolean(toInclusive))).asSet(this.domain);
    }

    @Override
    ContiguousSet<C> tailSetImpl(C fromElement, boolean inclusive) {
        return this.range.intersection(Ranges.downTo(fromElement, BoundType.forBoolean(inclusive))).asSet(this.domain);
    }

    @Override
    public UnmodifiableIterator<C> iterator() {
        return new AbstractLinkedIterator<C>((Comparable)this.first()){
            final C last;
            {
                this.last = RegularContiguousSet.this.last();
            }

            @Override
            protected C computeNext(C previous) {
                return RegularContiguousSet.equalsOrThrow(previous, this.last) ? null : (Object)RegularContiguousSet.this.domain.next(previous);
            }
        };
    }

    private static boolean equalsOrThrow(Comparable<?> left, @Nullable Comparable<?> right) {
        return right != null && Range.compareOrThrow(left, right) == 0;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public C first() {
        return this.range.lowerBound.leastValueAbove(this.domain);
    }

    @Override
    public C last() {
        return this.range.upperBound.greatestValueBelow(this.domain);
    }

    @Override
    public int size() {
        long l2 = this.domain.distance(this.first(), this.last());
        return l2 >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2 + 1;
    }

    @Override
    public boolean contains(Object object) {
        try {
            return this.range.contains((Comparable)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        try {
            return this.range.containsAll(targets);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] other) {
        return ObjectArrays.toArrayImpl(this, other);
    }

    @Override
    public ContiguousSet<C> intersection(ContiguousSet<C> other) {
        Comparable comparable;
        Preconditions.checkNotNull(other);
        Preconditions.checkArgument(this.domain.equals(other.domain));
        if (other.isEmpty()) {
            return other;
        }
        Comparable comparable2 = (Comparable)Ordering.natural().max(this.first(), other.first());
        return comparable2.compareTo(comparable = (Comparable)Ordering.natural().min(this.last(), other.last())) < 0 ? Ranges.closed(comparable2, comparable).asSet(this.domain) : new EmptyContiguousSet(this.domain);
    }

    @Override
    public Range<C> range() {
        return this.range(BoundType.CLOSED, BoundType.CLOSED);
    }

    @Override
    public Range<C> range(BoundType lowerBoundType, BoundType upperBoundType) {
        return Ranges.create(this.range.lowerBound.withLowerBoundType(lowerBoundType, this.domain), this.range.upperBound.withUpperBoundType(upperBoundType, this.domain));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RegularContiguousSet) {
            RegularContiguousSet regularContiguousSet = (RegularContiguousSet)object;
            if (this.domain.equals(regularContiguousSet.domain)) {
                return this.first().equals(regularContiguousSet.first()) && this.last().equals(regularContiguousSet.last());
            }
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new SerializedForm(this.range, this.domain);
    }

    @GwtIncompatible(value="serialization")
    private static final class SerializedForm<C extends Comparable>
    implements Serializable {
        final Range<C> range;
        final DiscreteDomain<C> domain;

        private SerializedForm(Range<C> range, DiscreteDomain<C> domain) {
            this.range = range;
            this.domain = domain;
        }

        private Object readResolve() {
            return new RegularContiguousSet<C>(this.range, this.domain);
        }
    }
}

