/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.io;

import com.timevale.esign.paas.guava.common.annotations.Beta;
import com.timevale.esign.paas.guava.common.base.Preconditions;
import com.timevale.esign.paas.guava.common.io.ByteArrayDataInput;
import com.timevale.esign.paas.guava.common.io.ByteArrayDataOutput;
import com.timevale.esign.paas.guava.common.io.ByteProcessor;
import com.timevale.esign.paas.guava.common.io.Closeables;
import com.timevale.esign.paas.guava.common.io.InputSupplier;
import com.timevale.esign.paas.guava.common.io.LimitInputStream;
import com.timevale.esign.paas.guava.common.io.MultiInputStream;
import com.timevale.esign.paas.guava.common.io.OutputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.zip.Checksum;

@Beta
public final class ByteStreams {
    private static final int BUF_SIZE = 4096;

    private ByteStreams() {
    }

    public static InputSupplier<ByteArrayInputStream> newInputStreamSupplier(byte[] b2) {
        return ByteStreams.newInputStreamSupplier(b2, 0, b2.length);
    }

    public static InputSupplier<ByteArrayInputStream> newInputStreamSupplier(final byte[] b2, final int off, final int len) {
        return new InputSupplier<ByteArrayInputStream>(){

            @Override
            public ByteArrayInputStream getInput() {
                return new ByteArrayInputStream(b2, off, len);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] from, OutputSupplier<? extends OutputStream> to) throws IOException {
        Preconditions.checkNotNull(from);
        boolean bl2 = true;
        OutputStream outputStream = to.getOutput();
        try {
            outputStream.write(from);
            bl2 = false;
        }
        finally {
            Closeables.close(outputStream, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputSupplier<? extends InputStream> from, OutputSupplier<? extends OutputStream> to) throws IOException {
        boolean bl2 = true;
        InputStream inputStream = from.getInput();
        try {
            long l2;
            OutputStream outputStream = to.getOutput();
            try {
                long l3 = ByteStreams.copy(inputStream, outputStream);
                bl2 = false;
                l2 = l3;
            }
            catch (Throwable throwable) {
                Closeables.close(outputStream, bl2);
                throw throwable;
            }
            Closeables.close(outputStream, bl2);
            return l2;
        }
        finally {
            Closeables.close(inputStream, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputSupplier<? extends InputStream> from, OutputStream to) throws IOException {
        boolean bl2 = true;
        InputStream inputStream = from.getInput();
        try {
            long l2 = ByteStreams.copy(inputStream, to);
            bl2 = false;
            long l3 = l2;
            return l3;
        }
        finally {
            Closeables.close(inputStream, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream from, OutputSupplier<? extends OutputStream> to) throws IOException {
        boolean bl2 = true;
        OutputStream outputStream = to.getOutput();
        try {
            long l2 = ByteStreams.copy(from, outputStream);
            bl2 = false;
            long l3 = l2;
            return l3;
        }
        finally {
            Closeables.close(outputStream, bl2);
        }
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        long l2 = 0L;
        while ((n2 = from.read(byArray)) != -1) {
            to.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copy(ReadableByteChannel from, WritableByteChannel to) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
        long l2 = 0L;
        while (from.read(byteBuffer) != -1) {
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                l2 += (long)to.write(byteBuffer);
            }
            byteBuffer.clear();
        }
        return l2;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteStreams.copy(in, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputSupplier<? extends InputStream> supplier) throws IOException {
        boolean bl2 = true;
        InputStream inputStream = supplier.getInput();
        try {
            byte[] byArray = ByteStreams.toByteArray(inputStream);
            bl2 = false;
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            Closeables.close(inputStream, bl2);
        }
    }

    public static ByteArrayDataInput newDataInput(byte[] bytes) {
        return new ByteArrayDataInputStream(bytes);
    }

    public static ByteArrayDataInput newDataInput(byte[] bytes, int start) {
        Preconditions.checkPositionIndex(start, bytes.length);
        return new ByteArrayDataInputStream(bytes, start);
    }

    public static ByteArrayDataOutput newDataOutput() {
        return new ByteArrayDataOutputStream();
    }

    public static ByteArrayDataOutput newDataOutput(int size) {
        Preconditions.checkArgument(size >= 0, "Invalid size: %s", size);
        return new ByteArrayDataOutputStream(size);
    }

    public static long length(InputSupplier<? extends InputStream> supplier) throws IOException {
        long l2 = 0L;
        boolean bl2 = true;
        InputStream inputStream = supplier.getInput();
        try {
            while (true) {
                long l3;
                if ((l3 = inputStream.skip(Integer.MAX_VALUE)) == 0L) {
                    if (inputStream.read() == -1) {
                        bl2 = false;
                        long l4 = l2;
                        return l4;
                    }
                    ++l2;
                    continue;
                }
                l2 += l3;
            }
        }
        finally {
            Closeables.close(inputStream, bl2);
        }
    }

    public static boolean equal(InputSupplier<? extends InputStream> supplier1, InputSupplier<? extends InputStream> supplier2) throws IOException {
        byte[] byArray = new byte[4096];
        byte[] byArray2 = new byte[4096];
        boolean bl2 = true;
        InputStream inputStream = supplier1.getInput();
        try {
            InputStream inputStream2 = supplier2.getInput();
            try {
                while (true) {
                    int n2;
                    int n3;
                    if ((n3 = ByteStreams.read(inputStream, byArray, 0, 4096)) != (n2 = ByteStreams.read(inputStream2, byArray2, 0, 4096)) || !Arrays.equals(byArray, byArray2)) {
                        bl2 = false;
                        boolean bl3 = false;
                        return bl3;
                    }
                    if (n3 == 4096) continue;
                    bl2 = false;
                    boolean bl4 = true;
                    return bl4;
                }
            }
            finally {
                Closeables.close(inputStream2, bl2);
            }
        }
        finally {
            Closeables.close(inputStream, bl2);
        }
    }

    public static void readFully(InputStream in, byte[] b2) throws IOException {
        ByteStreams.readFully(in, b2, 0, b2.length);
    }

    public static void readFully(InputStream in, byte[] b2, int off, int len) throws IOException {
        if (ByteStreams.read(in, b2, off, len) != len) {
            throw new EOFException();
        }
    }

    public static void skipFully(InputStream in, long n2) throws IOException {
        while (n2 > 0L) {
            long l2 = in.skip(n2);
            if (l2 == 0L) {
                if (in.read() == -1) {
                    throw new EOFException();
                }
                --n2;
                continue;
            }
            n2 -= l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readBytes(InputSupplier<? extends InputStream> supplier, ByteProcessor<T> processor) throws IOException {
        byte[] byArray = new byte[4096];
        boolean bl2 = true;
        InputStream inputStream = supplier.getInput();
        try {
            int n2;
            do {
                if ((n2 = inputStream.read(byArray)) != -1) continue;
                bl2 = false;
                break;
            } while (processor.processBytes(byArray, 0, n2));
            T t2 = processor.getResult();
            return t2;
        }
        finally {
            Closeables.close(inputStream, bl2);
        }
    }

    public static long getChecksum(InputSupplier<? extends InputStream> supplier, final Checksum checksum) throws IOException {
        return ByteStreams.readBytes(supplier, new ByteProcessor<Long>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                checksum.update(buf, off, len);
                return true;
            }

            @Override
            public Long getResult() {
                long l2 = checksum.getValue();
                checksum.reset();
                return l2;
            }
        });
    }

    public static byte[] getDigest(InputSupplier<? extends InputStream> supplier, final MessageDigest md) throws IOException {
        return ByteStreams.readBytes(supplier, new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                md.update(buf, off, len);
                return true;
            }

            @Override
            public byte[] getResult() {
                return md.digest();
            }
        });
    }

    public static int read(InputStream in, byte[] b2, int off, int len) throws IOException {
        int n2;
        int n3;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (n2 = 0; n2 < len && (n3 = in.read(b2, off + n2, len - n2)) != -1; n2 += n3) {
        }
        return n2;
    }

    public static InputSupplier<InputStream> slice(final InputSupplier<? extends InputStream> supplier, final long offset, final long length) {
        Preconditions.checkNotNull(supplier);
        Preconditions.checkArgument(offset >= 0L, "offset is negative");
        Preconditions.checkArgument(length >= 0L, "length is negative");
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() throws IOException {
                InputStream inputStream = (InputStream)supplier.getInput();
                if (offset > 0L) {
                    try {
                        ByteStreams.skipFully(inputStream, offset);
                    }
                    catch (IOException iOException) {
                        Closeables.closeQuietly(inputStream);
                        throw iOException;
                    }
                }
                return new LimitInputStream(inputStream, length);
            }
        };
    }

    public static InputSupplier<InputStream> join(final Iterable<? extends InputSupplier<? extends InputStream>> suppliers) {
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() throws IOException {
                return new MultiInputStream(suppliers.iterator());
            }
        };
    }

    public static InputSupplier<InputStream> join(InputSupplier<? extends InputStream> ... suppliers) {
        return ByteStreams.join(Arrays.asList(suppliers));
    }

    private static class ByteArrayDataOutputStream
    implements ByteArrayDataOutput {
        final DataOutput output;
        final ByteArrayOutputStream byteArrayOutputSteam;

        ByteArrayDataOutputStream() {
            this(new ByteArrayOutputStream());
        }

        ByteArrayDataOutputStream(int size) {
            this(new ByteArrayOutputStream(size));
        }

        ByteArrayDataOutputStream(ByteArrayOutputStream byteArrayOutputSteam) {
            this.byteArrayOutputSteam = byteArrayOutputSteam;
            this.output = new DataOutputStream(byteArrayOutputSteam);
        }

        @Override
        public void write(int b2) {
            try {
                this.output.write(b2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void write(byte[] b2) {
            try {
                this.output.write(b2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            try {
                this.output.write(b2, off, len);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeBoolean(boolean v2) {
            try {
                this.output.writeBoolean(v2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeByte(int v2) {
            try {
                this.output.writeByte(v2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeBytes(String s2) {
            try {
                this.output.writeBytes(s2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeChar(int v2) {
            try {
                this.output.writeChar(v2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeChars(String s2) {
            try {
                this.output.writeChars(s2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeDouble(double v2) {
            try {
                this.output.writeDouble(v2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeFloat(float v2) {
            try {
                this.output.writeFloat(v2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeInt(int v2) {
            try {
                this.output.writeInt(v2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeLong(long v2) {
            try {
                this.output.writeLong(v2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeShort(int v2) {
            try {
                this.output.writeShort(v2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeUTF(String s2) {
            try {
                this.output.writeUTF(s2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public byte[] toByteArray() {
            return this.byteArrayOutputSteam.toByteArray();
        }
    }

    private static class ByteArrayDataInputStream
    implements ByteArrayDataInput {
        final DataInput input;

        ByteArrayDataInputStream(byte[] bytes) {
            this.input = new DataInputStream(new ByteArrayInputStream(bytes));
        }

        ByteArrayDataInputStream(byte[] bytes, int start) {
            this.input = new DataInputStream(new ByteArrayInputStream(bytes, start, bytes.length - start));
        }

        @Override
        public void readFully(byte[] b2) {
            try {
                this.input.readFully(b2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public void readFully(byte[] b2, int off, int len) {
            try {
                this.input.readFully(b2, off, len);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int skipBytes(int n2) {
            try {
                return this.input.skipBytes(n2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public boolean readBoolean() {
            try {
                return this.input.readBoolean();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public byte readByte() {
            try {
                return this.input.readByte();
            }
            catch (EOFException eOFException) {
                throw new IllegalStateException(eOFException);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public int readUnsignedByte() {
            try {
                return this.input.readUnsignedByte();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public short readShort() {
            try {
                return this.input.readShort();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int readUnsignedShort() {
            try {
                return this.input.readUnsignedShort();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public char readChar() {
            try {
                return this.input.readChar();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int readInt() {
            try {
                return this.input.readInt();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public long readLong() {
            try {
                return this.input.readLong();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.input.readFloat();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.input.readDouble();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public String readLine() {
            try {
                return this.input.readLine();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public String readUTF() {
            try {
                return this.input.readUTF();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }
}

