/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.guava.common.io;

import com.timevale.esign.paas.guava.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

final class MultiInputStream
extends InputStream {
    private Iterator<? extends InputSupplier<? extends InputStream>> it;
    private InputStream in;

    public MultiInputStream(Iterator<? extends InputSupplier<? extends InputStream>> it) throws IOException {
        this.it = it;
        this.advance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    private void advance() throws IOException {
        this.close();
        if (this.it.hasNext()) {
            this.in = this.it.next().getInput();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int n2 = this.in.read();
        if (n2 == -1) {
            this.advance();
            return this.read();
        }
        return n2;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        int n2 = this.in.read(b2, off, len);
        if (n2 == -1) {
            this.advance();
            return this.read(b2, off, len);
        }
        return n2;
    }

    @Override
    public long skip(long n2) throws IOException {
        if (this.in == null || n2 <= 0L) {
            return 0L;
        }
        long l2 = this.in.skip(n2);
        if (l2 != 0L) {
            return l2;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.in.skip(n2 - 1L);
    }
}

