/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.seal.sdk.drawer.impl;

import com.timevale.esign.paas.seal.sdk.drawer.impl.DefaultEllipseImageDrawer;
import com.timevale.esign.paas.seal.sdk.drawer.request.InnerRequest;
import com.timevale.esign.paas.seal.sdk.drawer.request.ellipse.DoubleEllipseInnerRequest;
import com.timevale.esign.paas.seal.sdk.drawer.request.ellipse.SurroundTextInfo;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Ellipse2D;

public class DoubleEllipseImageDrawer
extends DefaultEllipseImageDrawer {
    @Override
    public <T extends InnerRequest> void customDraw(T obj, Graphics2D g2d) {
        DoubleEllipseInnerRequest doubleEllipseInnerRequest = (DoubleEllipseInnerRequest)obj;
        super.customDraw(doubleEllipseInnerRequest, g2d);
        this.drawInnerBorder(doubleEllipseInnerRequest, g2d);
        Point point = this.getCenterPoint(doubleEllipseInnerRequest);
        this.drawInnerSurroundText(g2d, doubleEllipseInnerRequest, point, true);
    }

    private void drawInnerSurroundText(Graphics2D g2d, DoubleEllipseInnerRequest request, Point centerPoint, boolean top) {
        SurroundTextInfo surroundTextInfo = request.getInnerTopSurroundTextInfo();
        if (surroundTextInfo == null) {
            return;
        }
        Font font = surroundTextInfo.getFont();
        int n2 = (request.getInnerWidth() >>> 1) - font.getSize();
        int n3 = (request.getInnerHeight() >>> 1) - font.getSize();
        this.doDrawSurroundText(g2d, surroundTextInfo, centerPoint, n2, n3, top);
    }

    private void drawInnerBorder(DoubleEllipseInnerRequest request, Graphics2D g2d) {
        int n2 = request.getWidth();
        int n3 = request.getHeight();
        int n4 = request.getInnerWidth();
        int n5 = request.getInnerHeight();
        int n6 = request.getInnerBorderWidth();
        int n7 = (n2 >>> 1) - (n4 >>> 1) + (n6 >>> 1);
        int n8 = (n3 >>> 1) - (n5 >>> 1) + (n6 >>> 1);
        g2d.setStroke(new BasicStroke(n6));
        Ellipse2D.Float float_ = new Ellipse2D.Float(n7, n8, n4, n5);
        g2d.draw(float_);
    }
}

