/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.seal.sdk.drawer.impl;

import com.timevale.esign.paas.seal.sdk.drawer.impl.DoubleEllipseImageDrawer;
import com.timevale.esign.paas.seal.sdk.drawer.request.InnerRequest;
import com.timevale.esign.paas.seal.sdk.drawer.request.ellipse.CenterTextInfo;
import com.timevale.esign.paas.seal.sdk.drawer.request.ellipse.HkEllipseInnerRequest;
import com.timevale.esign.paas.seal.sdk.enums.CenterTypeEnum;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HkEllipseImageDrawer
extends DoubleEllipseImageDrawer {
    private static final Logger log = LoggerFactory.getLogger(HkEllipseImageDrawer.class);
    private static final char LEFT_CHINA_PARENTHESIS = '\uff08';
    private static final char RIGHT_CHINA_PARENTHESIS = '\uff09';

    @Override
    public <T extends InnerRequest> void customDraw(T obj, Graphics2D g2d) {
        super.customDraw(obj, g2d);
        HkEllipseInnerRequest hkEllipseInnerRequest = (HkEllipseInnerRequest)obj;
        this.drawDoubleInnerBorder(hkEllipseInnerRequest, g2d);
        this.drawCenterText(hkEllipseInnerRequest, g2d);
    }

    private void drawCenterText(HkEllipseInnerRequest request, Graphics2D g2d) {
        CenterTextInfo centerTextInfo = request.getCenterTextInfo();
        if (centerTextInfo == null) {
            return;
        }
        CenterTypeEnum centerTypeEnum = centerTextInfo.getCenterTypeEnum();
        if (!CenterTypeEnum.TEXT.equals((Object)centerTypeEnum)) {
            log.warn("hk draw center text, CenterTypeEnum is not text");
            return;
        }
        String string = centerTextInfo.getText();
        if (StringUtils.isBlank(string)) {
            log.warn("center text is blank");
            return;
        }
        Font font = centerTextInfo.getFont();
        if (font == null) {
            log.warn("center font is null");
            return;
        }
        FontMetrics fontMetrics = g2d.getFontMetrics(font);
        Integer[] integerArray = centerTextInfo.getCenterTextCols();
        char[] cArray = string.toCharArray();
        int n2 = this.getMaxWordWidth(cArray, fontMetrics);
        double d2 = (double)(request.getHeight() / 6) / (double)fontMetrics.getHeight();
        int n3 = 0;
        int n4 = integerArray[0] - 1;
        this.drawLine(request, d2, cArray, n3, n4, g2d, integerArray[0], n2, LineEnum.ONE);
        n3 = n4 + 1;
        if (n3 >= cArray.length) {
            return;
        }
        if (integerArray[1] == null) {
            return;
        }
        n4 = n3 + integerArray[1] - 1;
        this.drawLine(request, d2, cArray, n3, n4, g2d, integerArray[1], n2, LineEnum.TWO);
        n3 = n4 + 1;
        if (n3 >= cArray.length) {
            return;
        }
        if (integerArray[2] == null) {
            return;
        }
        n4 = n3 + integerArray[2] - 1;
        this.drawLine(request, d2, cArray, n3, n4, g2d, integerArray[2], n2, LineEnum.THREE);
    }

    private void drawLine(HkEllipseInnerRequest request, double scaleY, char[] chars, int textStartIndex, int textEndIndex, Graphics2D g2d, Integer centerTextCol, int originMaxWordWidth, LineEnum line) {
        int n2;
        int n3;
        double d2;
        int n4;
        CenterTextInfo centerTextInfo = request.getCenterTextInfo();
        if (LineEnum.TWO.equals((Object)line)) {
            n4 = request.getWidth() >> 1;
            d2 = this.getScaleXForTwo(request.getWidth(), centerTextCol, originMaxWordWidth);
        } else {
            n4 = request.getWidth() * 3 >> 3;
            d2 = (double)n4 / (double)(originMaxWordWidth * centerTextCol);
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d2, scaleY);
        Font font = centerTextInfo.getFont().deriveFont(affineTransform);
        g2d.setFont(font);
        FontMetrics fontMetrics = g2d.getFontMetrics(font);
        int n5 = request.getHeight() >> 2;
        int n6 = LineEnum.ONE.equals((Object)line) ? n5 + (n5 >> 1) + (fontMetrics.getAscent() >> 1) : (LineEnum.TWO.equals((Object)line) ? (request.getHeight() >> 1) + (fontMetrics.getAscent() >> 1) : (request.getHeight() >> 1) + (n5 >> 1) + (fontMetrics.getAscent() >> 1));
        int n7 = this.getTotalWordWidth(chars, textStartIndex, textEndIndex, fontMetrics);
        if (centerTextCol == 1) {
            n3 = 0;
            n2 = n7;
        } else {
            n3 = (n4 - n7) / (centerTextCol - 1);
            n2 = n7 + (centerTextCol - 1) * n3;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        int n8 = (request.getWidth() >> 1) - (n2 >> 1);
        int n9 = this.getKuoWidthOfThree(fontMetrics);
        if ('\uff08' == chars[textStartIndex]) {
            n8 -= n9;
        } else if ('\uff09' == chars[textEndIndex]) {
            n8 += n9;
        }
        for (int i2 = textStartIndex; i2 <= textEndIndex; ++i2) {
            g2d.drawString(String.valueOf(chars[i2]), n8, n6);
            if (i2 == textEndIndex) break;
            int n10 = fontMetrics.charWidth(chars[i2]);
            n8 = n8 + n10 + n3;
            if (i2 == textStartIndex || '\uff08' != chars[i2 + 1] && '\uff09' != chars[i2 + 1]) continue;
            n8 -= n9;
        }
    }

    private int getKuoWidthOfThree(FontMetrics fm2) {
        return fm2.charWidth('\uff08') / 3;
    }

    protected int getTotalWordWidth(char[] chars, int startIndex, int endIndex, FontMetrics fm2) {
        if (chars == null || chars.length == 0 || fm2 == null) {
            return 0;
        }
        if (endIndex >= chars.length) {
            endIndex = chars.length;
        }
        int n2 = 0;
        for (int i2 = startIndex; i2 <= endIndex; ++i2) {
            int n3 = fm2.charWidth(chars[i2]);
            if ('\uff08' == chars[i2] || '\uff09' == chars[i2]) {
                n3 = (n3 << 1) / 3;
            }
            n2 += n3;
        }
        return n2;
    }

    private double getScaleXForTwo(int width, int wordCount, int originMaxWordWidth) {
        return (double)(width >>= 1) / (double)(originMaxWordWidth * wordCount);
    }

    private void drawDoubleInnerBorder(HkEllipseInnerRequest request, Graphics2D g2d) {
        int n2 = request.getWidth();
        int n3 = request.getHeight();
        int n4 = request.getDoubleInnerWidth();
        int n5 = request.getDoubleInnerHeight();
        int n6 = request.getDoubleInnerBorderWidth();
        int n7 = (n2 >>> 1) - (n4 >>> 1) + (n6 >>> 1);
        int n8 = (n3 >>> 1) - (n5 >>> 1) + (n6 >>> 1);
        g2d.setStroke(new BasicStroke(n6));
        Ellipse2D.Float float_ = new Ellipse2D.Float(n7, n8, n4, n5);
        g2d.draw(float_);
    }

    private static enum LineEnum {
        ONE,
        TWO,
        THREE;

    }
}

