/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.seal.sdk.request.generator.impl;

import com.timevale.esign.paas.seal.sdk.drawer.request.InnerRequest;
import com.timevale.esign.paas.seal.sdk.drawer.request.rect.RectImageInnerRequest;
import com.timevale.esign.paas.seal.sdk.enums.FontLayoutTypeEnum;
import com.timevale.esign.paas.seal.sdk.enums.FontPullTypeEnum;
import com.timevale.esign.paas.seal.sdk.exception.SealSdkException;
import com.timevale.esign.paas.seal.sdk.request.RectSealRequest;
import com.timevale.esign.paas.seal.sdk.request.SealBaseRequest;
import com.timevale.esign.paas.seal.sdk.request.generator.AbstractRequestGenerator;
import com.timevale.esign.paas.seal.sdk.util.FontUtil;
import com.timevale.esign.paas.seal.sdk.util.PixelUtil;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import java.awt.Font;

public class RectImageRequestGenerator
extends AbstractRequestGenerator {
    private static final int RECT_FIX_BIT = 4;

    @Override
    protected InnerRequest getImageRequest() {
        return new RectImageInnerRequest();
    }

    @Override
    protected <T extends SealBaseRequest> void validateRequest(T t2) {
        super.validateRequest(t2);
        RectSealRequest rectSealRequest = (RectSealRequest)t2;
        String string = rectSealRequest.getText();
        if (StringUtils.isBlank(string)) {
            throw new SealSdkException("\u5370\u7ae0\u6b63\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Font font = rectSealRequest.getFont();
        if (font == null) {
            throw new SealSdkException("\u5b57\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String string2 = rectSealRequest.getSealCode();
        if (StringUtils.isNotBlank(string2) && null == rectSealRequest.getSealCodeFont()) {
            throw new SealSdkException("\u5370\u7ae0\u7f16\u7801\u5b57\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int n2 = rectSealRequest.getLastFixWordCount();
        if (n2 != 0) {
            if (n2 < 0) {
                throw new SealSdkException("lastFixWordCount \u5e94\u8be5\u5927\u4e8e0");
            }
            if (n2 > string.length()) {
                throw new SealSdkException("lastFixWordCount \u5927\u4e8e\u4e86\u5370\u7ae0\u6b63\u6587\u5b57\u6570");
            }
        }
    }

    @Override
    protected <T extends SealBaseRequest, R extends InnerRequest> void convertDetail(T t2, R r2) {
        RectImageInnerRequest rectImageInnerRequest = (RectImageInnerRequest)r2;
        RectSealRequest rectSealRequest = (RectSealRequest)t2;
        rectImageInnerRequest.setText(rectSealRequest.getText());
        rectImageInnerRequest.setFont(FontUtil.processFont(rectSealRequest.getFont(), 1, 50));
        rectImageInnerRequest.setBottomCode(rectSealRequest.getSealCode());
        if (rectSealRequest.getSealCodeFont() == null) {
            rectImageInnerRequest.setCodeFont(FontUtil.processFont(rectSealRequest.getSealCodeFont(), 1, 30));
        }
        rectImageInnerRequest.setCodeWidth(PixelUtil.transferMmToPixel(rectImageInnerRequest.getCodeWidth(), rectImageInnerRequest.getDpi()));
        rectImageInnerRequest.setCodeHeight(PixelUtil.transferMmToPixel(rectImageInnerRequest.getCodeHeight(), rectImageInnerRequest.getDpi()));
        rectImageInnerRequest.setCodeColInterval(PixelUtil.transferMmToPixel(rectImageInnerRequest.getCodeColInterval(), rectImageInnerRequest.getDpi()));
        rectImageInnerRequest.setFontPullType(rectSealRequest.getFontPullType());
        rectImageInnerRequest.setFontLayoutType(rectSealRequest.getFontLayoutType());
        rectImageInnerRequest.setLastFixWordCount(rectSealRequest.getLastFixWordCount());
        rectImageInnerRequest.setGroupRowCol(RectImageRequestGenerator.groupRowCol(rectSealRequest.getText().length(), rectImageInnerRequest));
    }

    private static int[] groupRowCol(int wordCount, RectImageInnerRequest innerRequest) {
        int n2 = innerRequest.getLastFixWordCount();
        int[] nArray = innerRequest.getWidth() == innerRequest.getHeight() && n2 == 0 ? RectImageRequestGenerator.calSquareRawRowAndCol(wordCount) : RectImageRequestGenerator.calRectRawRowAndCol(wordCount);
        if (innerRequest.getWidth() <= innerRequest.getHeight()) {
            RectImageRequestGenerator.exchangeNormalRowAndCol(nArray);
        }
        if (n2 != 0) {
            return RectImageRequestGenerator.groupRowColByFixWord(wordCount, n2, nArray, innerRequest);
        }
        if (nArray[0] * nArray[1] == wordCount || FontPullTypeEnum.NONE.equals((Object)innerRequest.getFontPullType())) {
            return nArray;
        }
        if (FontLayoutTypeEnum.LEFT_RIGHT_UP_DOWN.equals((Object)innerRequest.getFontLayoutType()) || innerRequest.getWidth() >= innerRequest.getHeight()) {
            int n3;
            int n4 = nArray[0];
            int n5 = nArray[1];
            nArray[1] = n3 = wordCount - (n4 - 1) * n5;
            nArray[2] = n4 - 1;
            nArray[3] = n5 - n3;
        } else if (FontLayoutTypeEnum.RIGHT_LEFT_UP_DOWN.equals((Object)innerRequest.getFontLayoutType())) {
            int n6 = nArray[0];
            int n7 = nArray[1] - 1;
            int n8 = wordCount - n7 * n6;
            nArray[1] = n7;
            nArray[2] = n8;
            nArray[3] = 1;
        }
        return nArray;
    }

    private static int[] groupRowColByFixWord(int wordCount, int lastFixWordCount, int[] groupRowAndCol, RectImageInnerRequest innerRequest) {
        RectImageRequestGenerator.adjustNormalRowAndCol(groupRowAndCol, wordCount -= lastFixWordCount, lastFixWordCount, innerRequest);
        if (wordCount == 0) {
            return groupRowAndCol;
        }
        if (FontLayoutTypeEnum.LEFT_RIGHT_UP_DOWN.equals((Object)innerRequest.getFontLayoutType())) {
            groupRowAndCol[4] = 1;
            groupRowAndCol[5] = lastFixWordCount;
        } else if (FontLayoutTypeEnum.RIGHT_LEFT_UP_DOWN.equals((Object)innerRequest.getFontLayoutType())) {
            groupRowAndCol[4] = lastFixWordCount;
            groupRowAndCol[5] = 1;
        }
        if (groupRowAndCol[0] * groupRowAndCol[1] == wordCount) {
            return groupRowAndCol;
        }
        if (FontLayoutTypeEnum.LEFT_RIGHT_UP_DOWN.equals((Object)innerRequest.getFontLayoutType())) {
            int n2 = groupRowAndCol[0] - 1;
            int n3 = groupRowAndCol[1];
            int n4 = wordCount - n2 * n3;
            groupRowAndCol[0] = n2;
            if (n4 > 0) {
                groupRowAndCol[2] = 1;
            }
            groupRowAndCol[3] = n4;
        } else if (FontLayoutTypeEnum.RIGHT_LEFT_UP_DOWN.equals((Object)innerRequest.getFontLayoutType())) {
            int n5 = groupRowAndCol[0];
            int n6 = groupRowAndCol[1] - 1;
            int n7 = wordCount - n6 * n5;
            groupRowAndCol[1] = n6;
            groupRowAndCol[2] = n7;
            if (n7 > 0) {
                groupRowAndCol[3] = 1;
            }
        }
        return groupRowAndCol;
    }

    private static void adjustNormalRowAndCol(int[] groupRowAndCol, int totalCount, int fixCol, RectImageInnerRequest innerRequest) {
        FontLayoutTypeEnum fontLayoutTypeEnum = innerRequest.getFontLayoutType();
        if (totalCount == 0) {
            if (innerRequest.getWidth() >= innerRequest.getHeight()) {
                groupRowAndCol[0] = 1;
                groupRowAndCol[1] = fixCol;
            } else {
                groupRowAndCol[0] = fixCol;
                groupRowAndCol[1] = 1;
            }
            return;
        }
        int n2 = groupRowAndCol[0];
        int n3 = groupRowAndCol[1];
        if (FontLayoutTypeEnum.LEFT_RIGHT_UP_DOWN.equals((Object)fontLayoutTypeEnum)) {
            if (totalCount <= fixCol) {
                groupRowAndCol[0] = 1;
                groupRowAndCol[1] = totalCount;
                return;
            }
            if (--n2 * n3 == totalCount) {
                groupRowAndCol[0] = n2;
                return;
            }
            n2 = 1;
            n3 = fixCol;
            while (n2 * n3 < totalCount) {
                ++n2;
            }
            if ((totalCount & 1) == 0) {
                n3 = totalCount / n2;
            } else {
                while (totalCount - (n2 - 1) * n3 <= fixCol >> 1) {
                    --n3;
                }
            }
        } else {
            if (totalCount <= fixCol) {
                groupRowAndCol[0] = totalCount;
                groupRowAndCol[1] = 1;
                return;
            }
            if (n2 * --n3 == totalCount) {
                groupRowAndCol[1] = n3;
                return;
            }
            n3 = 1;
            n2 = fixCol;
            while (n2 * n3 < totalCount) {
                ++n3;
            }
            if ((totalCount & 1) == 0) {
                n2 = totalCount / n3;
            } else {
                while (totalCount - (n3 - 1) * n2 <= fixCol >> 1) {
                    --n2;
                }
            }
        }
        groupRowAndCol[0] = n2;
        groupRowAndCol[1] = n3;
    }

    private static int[] calRectRawRowAndCol(int wordCount) {
        if (wordCount <= 4) {
            return new int[]{1, wordCount, 0, 0, 0, 0};
        }
        int n2 = (int)Math.sqrt(wordCount);
        if (n2 * n2 == wordCount) {
            return new int[]{n2, n2, 0, 0, 0, 0};
        }
        int n3 = n2 + 1;
        if (wordCount - n2 * (n3 - 1) < n3 / 2) {
            --n2;
            ++n3;
        }
        while (n2 * n3 - wordCount < 0) {
            ++n3;
        }
        return new int[]{n2, n3, 0, 0, 0, 0};
    }

    private static int[] calSquareRawRowAndCol(int wordCount) {
        if (wordCount == 1) {
            return new int[]{1, 1, 0, 0, 0, 0};
        }
        if (wordCount == 2) {
            return new int[]{1, 2, 0, 0, 0, 0};
        }
        int n2 = (int)Math.ceil(Math.sqrt(wordCount));
        int n3 = 1;
        while (n3 * n2 < wordCount) {
            ++n3;
        }
        return new int[]{n3, n2, 0, 0, 0, 0};
    }

    private static void exchangeNormalRowAndCol(int[] groupRowAndCol) {
        int n2;
        int n3 = groupRowAndCol[0];
        groupRowAndCol[0] = n2 = groupRowAndCol[1];
        groupRowAndCol[1] = n3;
    }
}

