/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.util.FileUtil;

public class FilePdfParam {
    private String srcPdfFile;
    private byte[] streamFile;
    private String password;
    private boolean showModifySignatureInfo;
    private String fileNo;

    public String getFileNo() {
        return this.fileNo;
    }

    public void setFileNo(String fileNo) {
        this.fileNo = fileNo;
    }

    public String getSrcPdfFile() {
        return this.srcPdfFile;
    }

    public void setSrcPdfFile(String srcPdfFile) {
        this.srcPdfFile = srcPdfFile;
    }

    public boolean isShowModifySignatureInfo() {
        return this.showModifySignatureInfo;
    }

    public void setShowModifySignatureInfo(boolean showModifySignatureInfo) {
        this.showModifySignatureInfo = showModifySignatureInfo;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void check() throws SuperException {
        if (StringUtils.isBlank(this.srcPdfFile) && (this.streamFile == null || this.streamFile.length == 0)) {
            throw ErrorException.FILE_STREAM_ERROR.e();
        }
    }

    public byte[] getBytes() throws SuperException {
        if (this.streamFile == null || this.streamFile.length == 0) {
            try {
                this.streamFile = FileUtil.fileToByte(this.srcPdfFile);
            }
            catch (Exception exception) {
                throw ErrorException.FILE_READ_ERROR.e(this.srcPdfFile);
            }
        }
        return this.streamFile;
    }

    public byte[] getStreamFile() {
        return this.streamFile;
    }

    public void setStreamFile(byte[] streamFile) {
        this.streamFile = streamFile;
    }
}

