/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.bean.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.tech.constant.ErrorCode;
import com.timevale.esign.paas.tech.enums.AuthTypeEnum;
import com.timevale.esign.paas.tech.enums.CertTimeEnum;
import com.timevale.esign.paas.tech.enums.IdNoTypeEnum;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OfflineCreateLegalRepAuthParam {
    private String organizeId;
    private String name;
    private IdNoTypeEnum idNoType;
    private String idNo;
    private Boolean encrypt = Boolean.FALSE;
    private int authType = AuthTypeEnum.AUTH_TO_PLATFORM.getType();
    private String personId;
    private String sealScope;
    private String fileType;
    private String notifyUrl;
    private String transactorAccountId;
    private String identityAuthId;
    private CertTimeEnum certTime = CertTimeEnum.ONEYEAR;

    public String getOrganizeId() {
        return this.organizeId;
    }

    public void setOrganizeId(String organizeId) {
        this.organizeId = organizeId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IdNoTypeEnum getIdNoType() {
        return this.idNoType;
    }

    public void setIdNoType(IdNoTypeEnum idNoType) {
        this.idNoType = idNoType;
    }

    public String getIdNo() {
        return this.idNo;
    }

    public void setIdNo(String idNo) {
        this.idNo = idNo;
    }

    public Boolean getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getSealScope() {
        return this.sealScope;
    }

    public void setSealScope(String sealScope) {
        this.sealScope = sealScope;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getTransactorAccountId() {
        return this.transactorAccountId;
    }

    public void setTransactorAccountId(String transactorAccountId) {
        this.transactorAccountId = transactorAccountId;
    }

    public String getIdentityAuthId() {
        return this.identityAuthId;
    }

    public void setIdentityAuthId(String identityAuthId) {
        this.identityAuthId = identityAuthId;
    }

    public void setCertTime(CertTimeEnum certTime) {
        this.certTime = certTime;
    }

    public CertTimeEnum getCertTime() {
        return this.certTime;
    }

    public void check() throws SuperException {
        if (StringUtils.isBlank((String)this.organizeId)) {
            throw ErrorCode.PARAM_ERROR.e("organizeId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.name)) {
            throw ErrorCode.PARAM_ERROR.e("name\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull((Object)this.idNoType)) {
            throw ErrorCode.PARAM_ERROR.e("idNoType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.idNo)) {
            throw ErrorCode.PARAM_ERROR.e("idNo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)this.transactorAccountId)) {
            throw ErrorCode.PARAM_ERROR.e("transactorAccountId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkPerSonId();
        this.checkAuthType();
    }

    private void checkPerSonId() throws SuperException {
        if (AuthTypeEnum.AUTH_TO_PERSON.getType() == this.authType && StringUtils.isBlank((String)this.personId)) {
            throw ErrorCode.PARAM_ERROR.e("\u6388\u6743\u81f3\u7ecf\u529e\u4eba\u65f6\uff0c\u4e2a\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkAuthType() throws SuperException {
        if (this.authType != AuthTypeEnum.AUTH_TO_PLATFORM.getType() && this.authType != AuthTypeEnum.AUTH_TO_PERSON.getType()) {
            throw ErrorCode.PARAM_ERROR.e("\u6388\u6743\u7c7b\u578bauthType\u4f20\u5165\u7684\u503c\u9519\u8bef");
        }
    }
}

