/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.enums;

import com.timevale.esign.paas.guava.common.collect.Maps;
import java.util.Map;

public enum SignBizTypeEnum {
    ORGANIZE_SIGN(1, "\u4f01\u4e1a\u8bc1\u4e66\u7b7e\u7f72"),
    LEGAL_SIGN(2, "\u6cd5\u4eba\u8bc1\u4e66\u7b7e\u7f72");

    private int type;
    private String description;
    private static Map<Integer, SignBizTypeEnum> items;

    private SignBizTypeEnum(int type, String description) {
        this.type = type;
        this.description = description;
    }

    public int getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public static SignBizTypeEnum of(Integer type) {
        if (type == null) {
            return ORGANIZE_SIGN;
        }
        return items.getOrDefault(type, ORGANIZE_SIGN);
    }

    public static boolean isValid(Integer type) {
        return items.containsKey(type);
    }

    static {
        items = Maps.newHashMap();
        for (SignBizTypeEnum signBizTypeEnum : SignBizTypeEnum.values()) {
            items.put(signBizTypeEnum.getType(), signBizTypeEnum);
        }
    }
}

