/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.service.a;

import com.google.gson.JsonObject;
import com.timevale.esign.paas.esign.utils.JsonHelper;
import com.timevale.esign.paas.esign.utils.StringUtil;
import com.timevale.esign.paas.esign.utils.bean.ResultUtil;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.util.concurrent.ListenableFuture;
import com.timevale.esign.paas.guava.common.util.concurrent.ListeningExecutorService;
import com.timevale.esign.paas.guava.common.util.concurrent.MoreExecutors;
import com.timevale.esign.paas.guava.common.util.concurrent.ThreadFactoryBuilder;
import com.timevale.esign.paas.seal.sdk.util.StringUtils;
import com.timevale.esign.paas.tech.bean.bean.SignPDFDocBean;
import com.timevale.esign.paas.tech.bean.bean.SignerInfoBean;
import com.timevale.esign.paas.tech.bean.httpvo.GetSealResult;
import com.timevale.esign.paas.tech.bean.model.GetSignSealModel;
import com.timevale.esign.paas.tech.bean.request.PlatformSignParam;
import com.timevale.esign.paas.tech.bean.result.BatchFileDigestSignResult;
import com.timevale.esign.paas.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.constant.ErrorException;
import com.timevale.esign.paas.tech.constant.GbConstant;
import com.timevale.esign.paas.tech.enums.SealSpecEnum;
import com.timevale.esign.paas.tech.enums.SignWayEnum;
import com.timevale.esign.paas.tech.service.PlatformSignService;
import com.timevale.esign.paas.tech.service.a.b;
import com.timevale.esign.paas.tech.sign.SignKind;
import com.timevale.esign.paas.tech.sign.b.a;
import com.timevale.esign.paas.tech.sign.b.e;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class j
extends b
implements PlatformSignService {
    private static final Logger log = LoggerFactory.getLogger(j.class);
    private static final ListeningExecutorService VA = MoreExecutors.listeningDecorator(new ThreadPoolExecutor((int)GbConstant.CORE_POOL_SIZE, (int)GbConstant.MAXIMUM_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(GbConstant.CAPACITY), new ThreadFactoryBuilder().setNameFormat("\u5e73\u53f0\u6279\u91cf\u6587\u6863\u7b7e-thread-pool-%d").build()));

    public j() {
    }

    public j(AbstractServiceClient abstractServiceClient) {
        super(abstractServiceClient);
    }

    @Override
    public FileDigestSignResult platformSign(PlatformSignParam signInfo) {
        try {
            Object object;
            signInfo.check();
            String string = signInfo.getSealData();
            String string2 = null;
            if (StringUtils.isBlank(string)) {
                object = this.a(signInfo.getSealId(), signInfo.getSealSpec());
                string = ((GetSealResult)object).getSealBase64();
                string2 = ((GetSealResult)object).getSealBizType();
            }
            object = this.a(signInfo.getFileBean());
            a a2 = e.c(this.vF()).a(SignWayEnum.AUTH_SIGN).a(signInfo.getSealSpec()).vY();
            a2.setSealBizType(string2);
            SignerInfoBean signerInfoBean = new SignerInfoBean();
            signerInfoBean.setImageSignDateBean(signerInfoBean.getImageSignDateBean());
            FileDigestSignResult fileDigestSignResult = this.a((SignPDFDocBean)object, signInfo.getPosBeans(), signInfo.getSignType(), string, a2, null, SignKind.AUTH, signerInfoBean);
            fileDigestSignResult.setFileNo(signInfo.getFileBean().getFileNo());
            return fileDigestSignResult;
        }
        catch (SuperException superException) {
            FileDigestSignResult fileDigestSignResult = ResultUtil.failed(superException, FileDigestSignResult.class);
            fileDigestSignResult.setFileNo(signInfo.getFileBean().getFileNo());
            return fileDigestSignResult;
        }
        catch (Exception exception) {
            log.warn("platformSign fail {}", (Throwable)exception);
            FileDigestSignResult fileDigestSignResult = ResultUtil.failed(ErrorException.PLATFORM_SIGN_ERROR.e(), FileDigestSignResult.class);
            fileDigestSignResult.setFileNo(signInfo.getFileBean().getFileNo());
            return fileDigestSignResult;
        }
    }

    private GetSealResult a(String string, SealSpecEnum sealSpecEnum) throws SuperException {
        JsonObject jsonObject;
        GetSealResult getSealResult;
        if ("0".equals(string)) {
            throw ErrorException.SIGN_ID_ERROR.e();
        }
        GetSignSealModel getSignSealModel = (GetSignSealModel)this.vF().getContext().a(InterfaceKey.GET_SIGN_SEAL);
        getSignSealModel.setSealId(string);
        if (sealSpecEnum != null) {
            getSignSealModel.setSealSpec(sealSpecEnum.name());
        }
        if (0 != (getSealResult = JsonHelper.fromJson(jsonObject = HiddenOperationDelegator.request(this.vF(), getSignSealModel), GetSealResult.class)).getErrCode()) {
            throw ErrorsDiscriptor.direct(getSealResult.getErrCode(), getSealResult.getMsg());
        }
        if (StringUtil.isNull(getSealResult.getSealBase64())) {
            throw ErrorsDiscriptor.SignNoSeal.e();
        }
        return getSealResult;
    }

    @Override
    public BatchFileDigestSignResult batchPlatformSign(List<PlatformSignParam> signInfos) {
        BatchFileDigestSignResult batchFileDigestSignResult = new BatchFileDigestSignResult();
        try {
            this.o(signInfos);
            ArrayList<ListenableFuture<FileDigestSignResult>> arrayList = Lists.newArrayList();
            for (PlatformSignParam platformSignParam : signInfos) {
                log.info("\u6279\u91cf\u5904\u7406");
                arrayList.add(VA.submit(() -> this.platformSign(platformSignParam)));
            }
            ArrayList arrayList2 = new ArrayList();
            this.a(arrayList, arrayList2);
            batchFileDigestSignResult.setFileDigestSignResults(arrayList2);
            batchFileDigestSignResult.setErrCode(0);
            batchFileDigestSignResult.setMsg("\u6279\u91cf\u7b7e\u7f72\u6210\u529f");
            if (arrayList2.stream().anyMatch(fileDigestSignResult -> fileDigestSignResult.getErrCode() != 0)) {
                batchFileDigestSignResult.setErrCode(-1);
                batchFileDigestSignResult.setMsg("\u6279\u91cf\u7b7e\u7f72\u5931\u8d25");
            }
        }
        catch (Exception exception) {
            return this.a(batchFileDigestSignResult, exception);
        }
        return batchFileDigestSignResult;
    }

    private BatchFileDigestSignResult a(BatchFileDigestSignResult batchFileDigestSignResult, Exception exception) {
        if (exception instanceof com.timevale.esign.paas.tech.exception.a) {
            batchFileDigestSignResult.setErrCode(((com.timevale.esign.paas.tech.exception.a)exception).getCode());
            batchFileDigestSignResult.setMsg(exception.getMessage());
            return batchFileDigestSignResult;
        }
        batchFileDigestSignResult.setErrCode(-1);
        batchFileDigestSignResult.setMsg("\u6279\u91cf\u7b7e\u7f72\u5931\u8d25");
        return batchFileDigestSignResult;
    }

    private void o(List<PlatformSignParam> list) {
        if (list.size() > GbConstant.SIGN_SIZE_MAX_LIMIT) {
            String string = String.format("\u7b7e\u7f72\u5217\u8868\u6700\u591a%s\u4e2a", GbConstant.SIGN_SIZE_MAX_LIMIT);
            throw new com.timevale.esign.paas.tech.exception.a(string);
        }
        if (this.hasDuplicateDstPdfFile(list)) {
            throw new com.timevale.esign.paas.tech.exception.a("\u8f93\u51fa\u5730\u5740\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        List list2 = list.stream().filter(platformSignParam -> platformSignParam.getFileBean() != null).map(platformSignParam -> platformSignParam.getFileBean().getFileNo()).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list2) || list2.size() != list.size()) {
            throw new com.timevale.esign.paas.tech.exception.a("\u6587\u4ef6\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u91cd\u590d");
        }
    }

    public boolean hasDuplicateDstPdfFile(List<PlatformSignParam> list) {
        return list.stream().filter(platformSignParam -> platformSignParam.getFileBean() != null).map(platformSignParam -> platformSignParam.getFileBean().getDstPdfFile()).filter(StringUtils::isNotBlank).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).values().stream().anyMatch(l2 -> l2 > 1L);
    }

    private void a(List<ListenableFuture<FileDigestSignResult>> list, List<FileDigestSignResult> list2) {
        for (ListenableFuture<FileDigestSignResult> listenableFuture : list) {
            try {
                FileDigestSignResult fileDigestSignResult = (FileDigestSignResult)listenableFuture.get();
                list2.add(fileDigestSignResult);
            }
            catch (InterruptedException interruptedException) {
                log.error("\u6279\u91cf\u7b7e\u7f72\u4efbInterruptedException\u5f02\u5e38: {}", (Object)interruptedException.getMessage());
                list2.add(ResultUtil.failed(ErrorsDiscriptor.InternalService, FileDigestSignResult.class));
            }
            catch (ExecutionException executionException) {
                log.error("\u6279\u91cf\u7b7e\u7f72\u4efb\u52a1ExecutionException\u5f02\u5e38: {}", (Object)executionException.getMessage());
                list2.add(ResultUtil.failed(ErrorsDiscriptor.InternalService, FileDigestSignResult.class));
            }
        }
    }
}

