/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.service.a;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.timevale.esign.paas.esign.utils.Base64;
import com.timevale.esign.paas.esign.utils.asserts.AssertSupport;
import com.timevale.esign.paas.esign.utils.bean.ResultUtil;
import com.timevale.esign.paas.esign.utils.coding.Coder;
import com.timevale.esign.paas.esign.utils.exception.ErrorsDiscriptor;
import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.esign.utils.exception.impl.ErrorBasic;
import com.timevale.esign.paas.guava.common.collect.Lists;
import com.timevale.esign.paas.guava.common.util.concurrent.ListenableFuture;
import com.timevale.esign.paas.guava.common.util.concurrent.ListeningExecutorService;
import com.timevale.esign.paas.guava.common.util.concurrent.MoreExecutors;
import com.timevale.esign.paas.guava.common.util.concurrent.ThreadFactoryBuilder;
import com.timevale.esign.paas.tech.bean.bean.CertInfo;
import com.timevale.esign.paas.tech.bean.bean.PosBean;
import com.timevale.esign.paas.tech.bean.bean.SignPDFDocBean;
import com.timevale.esign.paas.tech.bean.bean.SignerInfoBean;
import com.timevale.esign.paas.tech.bean.model.DigitalSignModel;
import com.timevale.esign.paas.tech.bean.request.BatchBaseSignParam;
import com.timevale.esign.paas.tech.bean.request.BatchOrgSignParam;
import com.timevale.esign.paas.tech.bean.request.BatchPersonSignParam;
import com.timevale.esign.paas.tech.bean.request.DigitalSignBean;
import com.timevale.esign.paas.tech.bean.request.OrgSignParam;
import com.timevale.esign.paas.tech.bean.request.PersonSignParam;
import com.timevale.esign.paas.tech.bean.result.BatchFileDigestSignResult;
import com.timevale.esign.paas.tech.bean.result.DigitalSignWithP1Result;
import com.timevale.esign.paas.tech.bean.result.DigitalSignWithP7Result;
import com.timevale.esign.paas.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.paas.tech.bean.result.StandardCertBean;
import com.timevale.esign.paas.tech.bean.result.VerifyDigestSignResult;
import com.timevale.esign.paas.tech.bean.result.VerifyDigitalSignP1Bean;
import com.timevale.esign.paas.tech.bean.result.VerifyDigitalSignP7Bean;
import com.timevale.esign.paas.tech.client.AbstractServiceClient;
import com.timevale.esign.paas.tech.client.HiddenOperationDelegator;
import com.timevale.esign.paas.tech.client.context.InterfaceKey;
import com.timevale.esign.paas.tech.constant.GbConstant;
import com.timevale.esign.paas.tech.enums.SignType;
import com.timevale.esign.paas.tech.enums.SignWayEnum;
import com.timevale.esign.paas.tech.enums.SignatureFormatEnum;
import com.timevale.esign.paas.tech.enums.SignatureVerifyEnum;
import com.timevale.esign.paas.tech.service.UserSignService;
import com.timevale.esign.paas.tech.service.a.b;
import com.timevale.esign.paas.tech.sign.SignKind;
import com.timevale.esign.paas.tech.sign.b.a;
import com.timevale.esign.paas.tech.sign.b.e;
import com.timevale.esign.paas.tech.util.CommonCertUtil;
import com.timevale.esign.paas.tech.util.IOUtil;
import com.timevale.esign.paas.tech.util.JsonUtil;
import com.timevale.esign.paas.tech.util.SignatureTemplate;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.esign.paas.tgtext.bouncycastle.util.CollectionStore;
import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class m
extends b
implements UserSignService {
    private static final Logger log = LoggerFactory.getLogger(m.class);
    private static final ListeningExecutorService VA = MoreExecutors.listeningDecorator(new ThreadPoolExecutor((int)GbConstant.CORE_POOL_SIZE, (int)GbConstant.MAXIMUM_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(GbConstant.CAPACITY), new ThreadFactoryBuilder().setNameFormat("\u6279\u91cf\u6587\u6863\u7b7e-thread-pool-%d").build()));
    private static final String VC = "1.2.156.10197.1.501";

    public m() {
    }

    public m(AbstractServiceClient abstractServiceClient) {
        super(abstractServiceClient);
    }

    @Override
    public FileDigestSignResult orgSign(OrgSignParam param) {
        a a2;
        SignPDFDocBean signPDFDocBean;
        try {
            param.check();
            signPDFDocBean = this.a(param.getFileBean());
            a2 = e.c(this.vF()).dm(param.getWillingnessId()).dn(param.getWillingnessAccountId()).a(SignWayEnum.AUTH_SIGN).a(param.getSealSpec()).I(false).J(param.isLegalRepSign()).cS(param.getSignBizType()).do(param.getRequestUuid()).vY();
        }
        catch (SuperException superException) {
            FileDigestSignResult fileDigestSignResult = ResultUtil.failed(superException.getCode(), superException.getMessage(), true, FileDigestSignResult.class);
            fileDigestSignResult.setFileNo(param.getFileBean().getFileNo());
            return fileDigestSignResult;
        }
        SignerInfoBean signerInfoBean = new SignerInfoBean();
        signerInfoBean.setImageSignDateBean(param.getImageSignDateBean());
        FileDigestSignResult fileDigestSignResult = this.a(signPDFDocBean, param.getPosBeans(), param.getSignType(), param.getSealData(), a2, param.getAccountId(), signerInfoBean);
        fileDigestSignResult.setFileNo(param.getFileBean().getFileNo());
        return fileDigestSignResult;
    }

    @Override
    public FileDigestSignResult personSign(PersonSignParam param) {
        a a2;
        SignPDFDocBean signPDFDocBean;
        try {
            param.check();
            signPDFDocBean = this.a(param.getFileBean());
            a2 = e.c(this.vF()).dm(param.getWillingnessId()).a(SignWayEnum.AUTH_SIGN).a(param.getSealSpec()).I(true).do(param.getRequestUuid()).vY();
        }
        catch (SuperException superException) {
            FileDigestSignResult fileDigestSignResult = ResultUtil.failed(superException.getCode(), superException.getMessage(), true, FileDigestSignResult.class);
            fileDigestSignResult.setFileNo(param.getFileBean().getFileNo());
            return fileDigestSignResult;
        }
        SignerInfoBean signerInfoBean = new SignerInfoBean();
        signerInfoBean.setImageSignDateBean(param.getImageSignDateBean());
        FileDigestSignResult fileDigestSignResult = this.a(signPDFDocBean, param.getPosBeans(), param.getSignType(), param.getSealData(), a2, param.getAccountId(), signerInfoBean);
        fileDigestSignResult.setFileNo(param.getFileBean().getFileNo());
        return fileDigestSignResult;
    }

    @Override
    public DigitalSignWithP1Result localDigitalSignWithP1(DigitalSignBean param) {
        try {
            param.validate();
            DigitalSignModel digitalSignModel = (DigitalSignModel)this.vF().getContext().a(InterfaceKey.PAAS_TECH_DIGITAL_SIGN);
            digitalSignModel.setAccountId(param.getAccountId());
            digitalSignModel.setText(param.getPlainText());
            digitalSignModel.setSignatureFormat(SignatureFormatEnum.PKCS1.getType());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), digitalSignModel);
            DigitalSignWithP1Result digitalSignWithP1Result = JsonUtil.jsonObjectToBean(jsonObject, DigitalSignWithP1Result.class);
            this.a(digitalSignWithP1Result, jsonObject);
            AssertSupport.assertTrue(digitalSignWithP1Result.getErrCode() == 0, ErrorsDiscriptor.direct(digitalSignWithP1Result.getErrCode(), digitalSignWithP1Result.getMsg()));
            com.timevale.esign.paas.tech.sign.b.a(this.vF(), param.getAccountId(), "text", "text", null, digitalSignWithP1Result.getSignServiceId(), null, null, null, null, null, null);
            return digitalSignWithP1Result;
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException.getCode(), superException.getMessage(), true, DigitalSignWithP1Result.class);
        }
        catch (Exception exception) {
            return ResultUtil.failed(ErrorBasic.FailureCipherSign.code(), ErrorBasic.FailureCipherSign.message(), true, DigitalSignWithP1Result.class);
        }
    }

    @Override
    public DigitalSignWithP7Result localDigitalSignWithP7(DigitalSignBean param) {
        try {
            param.validate();
            DigitalSignModel digitalSignModel = (DigitalSignModel)this.vF().getContext().a(InterfaceKey.PAAS_TECH_DIGITAL_SIGN);
            digitalSignModel.setAccountId(param.getAccountId());
            digitalSignModel.setText(param.getPlainText());
            digitalSignModel.setSignatureFormat(SignatureFormatEnum.PKCS7.getType());
            JsonObject jsonObject = HiddenOperationDelegator.request(this.vF(), digitalSignModel);
            DigitalSignWithP7Result digitalSignWithP7Result = JsonUtil.jsonObjectToBean(jsonObject, DigitalSignWithP7Result.class);
            AssertSupport.assertTrue(digitalSignWithP7Result.getErrCode() == 0, ErrorsDiscriptor.direct(digitalSignWithP7Result.getErrCode(), digitalSignWithP7Result.getMsg()));
            DigitalSignWithP7Result digitalSignWithP7Result2 = digitalSignWithP7Result;
            com.timevale.esign.paas.tech.sign.b.a(this.vF(), param.getAccountId(), "text", "text", null, digitalSignWithP7Result2.getSignServiceId(), null, null, null, null, null, null);
            String string = digitalSignWithP7Result2.getSignature();
            CMSSignedData cMSSignedData = new CMSSignedData(Base64.decode(string));
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)((CollectionStore)cMSSignedData.getCertificates()).iterator().next();
            digitalSignWithP7Result2.setCertBean(this.dg(Base64.encode(x509CertificateHolder.getEncoded())));
            return digitalSignWithP7Result2;
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException.getCode(), superException.getMessage(), true, DigitalSignWithP7Result.class);
        }
        catch (Exception exception) {
            return ResultUtil.failed(ErrorBasic.FailureCipherSign.code(), ErrorBasic.FailureCipherSign.message(), true, DigitalSignWithP7Result.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyDigestSignResult digitalVerifyWithP1(VerifyDigitalSignP1Bean param) {
        try {
            Object object;
            param.validate();
            AssertSupport.assertTrue(StringUtils.isNotEmpty((String)param.getPlainText()), ErrorsDiscriptor.MissingArgumentsSpec.e("plainText"));
            AssertSupport.assertTrue(StringUtils.isNotEmpty((String)param.getCert()), ErrorsDiscriptor.MissingArgumentsSpec.e("cert"));
            if (Base64.decode(param.getSignature()) == null) {
                return ResultUtil.failed(ErrorBasic.FailureCipherVerify.code(), "\u9a8c\u8bc1\u5931\u8d25\uff0csignature\u683c\u5f0f\u9519\u8bef\u3002", true, VerifyDigestSignResult.class);
            }
            if (Base64.decode(param.getCert()) == null) {
                return ResultUtil.failed(ErrorBasic.FailureCipherVerify.code(), "\u9a8c\u8bc1\u5931\u8d25\uff0ccert\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", true, VerifyDigestSignResult.class);
            }
            if (Base64.decode(param.getTimestampSignature()) == null) {
                return ResultUtil.failed(ErrorBasic.FailureCipherVerify.code(), "\u9a8c\u8bc1\u5931\u8d25\uff0ctimestampSignature\u683c\u5f0f\u9519\u8bef\u3002", true, VerifyDigestSignResult.class);
            }
            boolean bl2 = false;
            ByteArrayInputStream byteArrayInputStream = null;
            ASN1InputStream aSN1InputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(Base64.decode(param.getCert()));
                aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                object = (ASN1Sequence)aSN1InputStream.readObject();
                Certificate certificate = Certificate.getInstance(object);
                bl2 = VC.equals(certificate.getSignatureAlgorithm().getAlgorithm().getId());
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(aSN1InputStream);
                IOUtil.closeQuietly(byteArrayInputStream);
                throw throwable;
            }
            IOUtil.closeQuietly(aSN1InputStream);
            IOUtil.closeQuietly(byteArrayInputStream);
            if (!bl2 && !param.getAlgorithm().equalsIgnoreCase("SHA256WithRSA")) {
                return ResultUtil.failed(ErrorBasic.FailureCipherVerify.code(), "\u9a8c\u8bc1\u5931\u8d25\uff0c\u7b7e\u540d\u8bc1\u4e66\u4e0e" + param.getAlgorithm() + "\u7b97\u6cd5\u4e0d\u5339\u914d", true, VerifyDigestSignResult.class);
            }
            if (bl2 && !param.getAlgorithm().equalsIgnoreCase("SM3WithSM2")) {
                return ResultUtil.failed(ErrorBasic.FailureCipherVerify.code(), "\u9a8c\u8bc1\u5931\u8d25\uff0c\u7b7e\u540d\u8bc1\u4e66\u4e0e" + param.getAlgorithm() + "\u7b97\u6cd5\u4e0d\u5339\u914d", true, VerifyDigestSignResult.class);
            }
            SignatureVerifyEnum.getVerifyEnumByAlgAndPkcs(param.getAlgorithm(), false).verify(param);
            object = new VerifyDigestSignResult();
            ((VerifyDigestSignResult)object).setCertBean(this.dg(param.getCert()));
            return object;
        }
        catch (Exception exception) {
            return m.b(exception);
        }
    }

    @Override
    public VerifyDigestSignResult digitalVerifyWithP7(VerifyDigitalSignP7Bean param) {
        try {
            param.validate();
            if (Base64.decode(param.getSignature()) == null) {
                return ResultUtil.failed(ErrorBasic.FailureCipherVerify.code(), "\u9a8c\u8bc1\u5931\u8d25\uff0csignature\u683c\u5f0f\u9519\u8bef\u3002", true, VerifyDigestSignResult.class);
            }
            SignatureVerifyEnum.getVerifyEnumByAlgAndPkcs(SignatureVerifyEnum.SHA256WITHRSA_P7.getAlg(), true).verify(param);
            VerifyDigestSignResult verifyDigestSignResult = new VerifyDigestSignResult();
            CMSSignedData cMSSignedData = new CMSSignedData(Base64.decode(param.getSignature()));
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)((CollectionStore)cMSSignedData.getCertificates()).iterator().next();
            verifyDigestSignResult.setCertBean(this.dg(Base64.encode(x509CertificateHolder.getEncoded())));
            return verifyDigestSignResult;
        }
        catch (Exception exception) {
            return m.b(exception);
        }
    }

    private static VerifyDigestSignResult b(Exception exception) {
        if (exception instanceof SuperException) {
            return ResultUtil.failed(((SuperException)exception).getCode(), ((SuperException)exception).getMessage(), true, VerifyDigestSignResult.class);
        }
        if (exception instanceof SignatureTemplate.SignatureVerifyFailureException) {
            return ResultUtil.failed(ErrorBasic.FailureCipherVerify.code(), exception.getMessage(), true, VerifyDigestSignResult.class);
        }
        return ResultUtil.failed(ErrorBasic.FailureCipherVerify.code(), ErrorBasic.FailureCipherVerify.message(), true, VerifyDigestSignResult.class);
    }

    private FileDigestSignResult a(SignPDFDocBean signPDFDocBean, List<PosBean> list, SignType signType, String string, a a2, String string2, SignerInfoBean signerInfoBean) {
        try {
            return this.a(signPDFDocBean, list, signType, string, a2, string2, SignKind.AUTH, signerInfoBean);
        }
        catch (SuperException superException) {
            return ResultUtil.failed(superException.getCode(), superException.getMessage(), true, FileDigestSignResult.class);
        }
    }

    private void a(DigitalSignWithP7Result digitalSignWithP7Result, JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("cert");
        if (jsonElement != null && JsonNull.INSTANCE != jsonElement) {
            digitalSignWithP7Result.setCertBean(this.dg(jsonElement.getAsString()));
        }
    }

    private StandardCertBean dg(String string) {
        CertInfo certInfo = CommonCertUtil.getCertInfo(Coder.BASE64.decode(string));
        StandardCertBean standardCertBean = new StandardCertBean();
        standardCertBean.setCert(string);
        standardCertBean.setCn(certInfo != null ? certInfo.getSubject_cn() : null);
        standardCertBean.setEndDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Objects.requireNonNull(certInfo).getEndTime()));
        standardCertBean.setStartDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(certInfo.getStartTime()));
        standardCertBean.setIssuerCN(certInfo.getIssue_cn());
        standardCertBean.setOu(certInfo.getIssue_ou());
        standardCertBean.setSn(certInfo.getSerialNumber());
        return standardCertBean;
    }

    @Override
    public BatchFileDigestSignResult batchOrgSign(BatchOrgSignParam param) {
        BatchFileDigestSignResult batchFileDigestSignResult = new BatchFileDigestSignResult();
        try {
            param.checkSignParam();
            BatchBaseSignParam batchBaseSignParam = param.getSignInfoParams().get(0);
            String string = UUID.randomUUID().toString();
            OrgSignParam orgSignParam = this.a(param, batchBaseSignParam);
            orgSignParam.setRequestUuid(string);
            FileDigestSignResult fileDigestSignResult = this.orgSign(orgSignParam);
            ArrayList<ListenableFuture<FileDigestSignResult>> arrayList = Lists.newArrayList();
            for (int i2 = 1; i2 < param.getSignInfoParams().size(); ++i2) {
                BatchBaseSignParam batchBaseSignParam2 = param.getSignInfoParams().get(i2);
                OrgSignParam orgSignParam2 = this.a(param, batchBaseSignParam2);
                orgSignParam2.setRequestUuid(string);
                arrayList.add(VA.submit(() -> this.orgSign(orgSignParam2)));
            }
            ArrayList<FileDigestSignResult> arrayList2 = new ArrayList<FileDigestSignResult>();
            this.a(arrayList, arrayList2);
            arrayList2.add(fileDigestSignResult);
            batchFileDigestSignResult = this.p(arrayList2);
        }
        catch (Exception exception) {
            return m.a(batchFileDigestSignResult, exception);
        }
        return batchFileDigestSignResult;
    }

    private BatchFileDigestSignResult p(List<FileDigestSignResult> list) {
        BatchFileDigestSignResult batchFileDigestSignResult = new BatchFileDigestSignResult();
        batchFileDigestSignResult.setFileDigestSignResults(list);
        batchFileDigestSignResult.setErrCode(0);
        batchFileDigestSignResult.setMsg("\u6279\u91cf\u7b7e\u7f72\u6210\u529f");
        if (list.stream().anyMatch(fileDigestSignResult -> fileDigestSignResult.getErrCode() != 0)) {
            batchFileDigestSignResult.setErrCode(-1);
            batchFileDigestSignResult.setMsg("\u6279\u91cf\u7b7e\u7f72\u5931\u8d25");
        }
        return batchFileDigestSignResult;
    }

    private OrgSignParam a(BatchOrgSignParam batchOrgSignParam, BatchBaseSignParam batchBaseSignParam) {
        OrgSignParam orgSignParam = new OrgSignParam();
        orgSignParam.setSignBizType(batchOrgSignParam.getSignBizType());
        orgSignParam.setWillingnessAccountId(batchOrgSignParam.getWillingnessAccountId());
        orgSignParam.setAccountId(batchOrgSignParam.getAccountId());
        orgSignParam.setWillingnessId(batchOrgSignParam.getWillingnessId());
        orgSignParam.setLegalRepSign(batchOrgSignParam.isLegalRepSign());
        orgSignParam.setSignBizType(batchOrgSignParam.getSignBizType());
        orgSignParam.setSignType(batchBaseSignParam.getSignType());
        orgSignParam.setFileBean(batchBaseSignParam.getFileBean());
        orgSignParam.setPosBeans(batchBaseSignParam.getPosBeans());
        orgSignParam.setSealData(batchBaseSignParam.getSealData());
        orgSignParam.setSealSpec(batchBaseSignParam.getSealSpec());
        return orgSignParam;
    }

    private PersonSignParam a(BatchPersonSignParam batchPersonSignParam, BatchBaseSignParam batchBaseSignParam) {
        PersonSignParam personSignParam = new PersonSignParam();
        personSignParam.setAccountId(batchPersonSignParam.getAccountId());
        personSignParam.setWillingnessId(batchPersonSignParam.getWillingnessId());
        personSignParam.setSignType(batchBaseSignParam.getSignType());
        personSignParam.setFileBean(batchBaseSignParam.getFileBean());
        personSignParam.setPosBeans(batchBaseSignParam.getPosBeans());
        personSignParam.setSealData(batchBaseSignParam.getSealData());
        personSignParam.setSealSpec(batchBaseSignParam.getSealSpec());
        return personSignParam;
    }

    @Override
    public BatchFileDigestSignResult batchPersonSign(BatchPersonSignParam param) {
        BatchFileDigestSignResult batchFileDigestSignResult = new BatchFileDigestSignResult();
        try {
            param.checkSignParam();
            BatchBaseSignParam batchBaseSignParam = param.getSignInfoParams().get(0);
            String string = UUID.randomUUID().toString();
            PersonSignParam personSignParam = this.a(param, batchBaseSignParam);
            personSignParam.setRequestUuid(string);
            FileDigestSignResult fileDigestSignResult = this.personSign(personSignParam);
            ArrayList<ListenableFuture<FileDigestSignResult>> arrayList = Lists.newArrayList();
            for (int i2 = 1; i2 < param.getSignInfoParams().size(); ++i2) {
                BatchBaseSignParam batchBaseSignParam2 = param.getSignInfoParams().get(i2);
                PersonSignParam personSignParam2 = this.a(param, batchBaseSignParam2);
                personSignParam2.setRequestUuid(string);
                arrayList.add(VA.submit(() -> this.personSign(personSignParam2)));
            }
            ArrayList<FileDigestSignResult> arrayList2 = new ArrayList<FileDigestSignResult>();
            this.a(arrayList, arrayList2);
            arrayList2.add(fileDigestSignResult);
            batchFileDigestSignResult = this.p(arrayList2);
        }
        catch (Exception exception) {
            return m.a(batchFileDigestSignResult, exception);
        }
        return batchFileDigestSignResult;
    }

    private static BatchFileDigestSignResult a(BatchFileDigestSignResult batchFileDigestSignResult, Exception exception) {
        if (exception instanceof com.timevale.esign.paas.tech.exception.a) {
            batchFileDigestSignResult.setErrCode(((com.timevale.esign.paas.tech.exception.a)exception).getCode());
            batchFileDigestSignResult.setMsg(exception.getMessage());
            return batchFileDigestSignResult;
        }
        batchFileDigestSignResult.setErrCode(-1);
        batchFileDigestSignResult.setMsg("\u6279\u91cf\u7b7e\u7f72\u5931\u8d25");
        return batchFileDigestSignResult;
    }

    private void a(List<ListenableFuture<FileDigestSignResult>> list, List<FileDigestSignResult> list2) {
        for (ListenableFuture<FileDigestSignResult> listenableFuture : list) {
            try {
                FileDigestSignResult fileDigestSignResult = (FileDigestSignResult)listenableFuture.get();
                list2.add(fileDigestSignResult);
            }
            catch (InterruptedException interruptedException) {
                log.error("\u6279\u91cf\u7b7e\u7f72\u4efbInterruptedException\u5f02\u5e38: {}", (Object)interruptedException.getMessage());
                list2.add(ResultUtil.failed(ErrorsDiscriptor.InternalService, FileDigestSignResult.class));
            }
            catch (ExecutionException executionException) {
                log.error("\u6279\u91cf\u7b7e\u7f72\u4efb\u52a1ExecutionException\u5f02\u5e38: {}", (Object)executionException.getMessage());
                list2.add(ResultUtil.failed(ErrorsDiscriptor.InternalService, FileDigestSignResult.class));
            }
        }
    }
}

