/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.tech.util.RSASignatureProperties;
import com.timevale.esign.paas.tech.util.SM2SignatureProperties;
import com.timevale.esign.paas.tech.util.SignAlgorithm;
import com.timevale.esign.paas.tech.util.SignatureProperties;

public class SignaturePropertiesFactory {
    public static SignatureProperties build(String algorithmOid, byte[] certBytes) {
        if ("1.2.156.10197.1.501".equalsIgnoreCase(algorithmOid)) {
            return new SM2SignatureProperties(new byte[0], certBytes);
        }
        return new RSASignatureProperties(new byte[0], certBytes);
    }

    public static SignatureProperties build(SignAlgorithm signAlgorithm, byte[] privateKeyData, byte[] certBytes) {
        switch (signAlgorithm) {
            case SM3WITHSM2: {
                return new SM2SignatureProperties(privateKeyData, certBytes);
            }
            case SHA256WITHRSA: {
                return new RSASignatureProperties(privateKeyData, certBytes);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\u7c7b\u578b\uff1a" + (Object)((Object)signAlgorithm));
    }
}

