/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.esign.utils.exception.SuperException;
import com.timevale.esign.paas.tech.util.SMProvider;
import com.timevale.esign.paas.tech.util.SignatureProperties;
import com.timevale.esign.paas.tech.util.SignaturePropertiesFactory;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.DEROutputStream;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.gm.GMObjectIdentifiers;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSException;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSignedDataGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.jcajce.provider.digest.SM3;
import com.timevale.esign.paas.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import com.timevale.esign.paas.tgtext.bouncycastle.util.CollectionStore;
import com.timevale.esign.paas.timestamp.utils.d;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;

public class SignatureTemplate {
    public static byte[] signWithP1(byte[] origin, SignatureProperties property) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(property.getSignatureAlgorithm());
        signature.initSign(property.getPrivateKey());
        signature.update(origin);
        return signature.sign();
    }

    public static boolean verifyWithP1(byte[] origin, byte[] signatureResult, byte[] tpSignatureResult, SignatureProperties property) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, SuperException {
        boolean bl2 = SignatureTemplate.verifyWithP1(origin, signatureResult, property);
        if (!bl2) {
            throw new SignatureVerifyFailureException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u7b7e\u540d\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
        }
        if (tpSignatureResult == null || tpSignatureResult.length == 0) {
            return true;
        }
        if (!d.p(signatureResult, tpSignatureResult)) {
            throw new SignatureVerifyFailureException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u65f6\u95f4\u6233\u7b7e\u540d\u503c\u9a8c\u8bc1\u5931\u8d25\u3002");
        }
        return true;
    }

    public static boolean verifyWithP1(byte[] origin, byte[] signatureResult, SignatureProperties property) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(property.getSignatureAlgorithm());
        signature.initVerify(property.getPublicKey());
        signature.update(origin);
        return signature.verify(signatureResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] signWithP7(byte[] origin, SignatureProperties property) throws CMSException, IOException, OperatorCreationException {
        CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(property.getSignatureAlgorithm()).setProvider(property.getProvider()).build(property.getPrivateKey());
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(property.getCertificate());
        cMSSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(property.getProvider()).build()).build(contentSigner, x509CertificateHolder));
        cMSSignedDataGenerator.addCertificate(x509CertificateHolder);
        CMSProcessableByteArray cMSProcessableByteArray = new CMSProcessableByteArray(origin);
        CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSProcessableByteArray, true);
        ContentInfo contentInfo = cMSSignedData.toASN1Structure();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(contentInfo);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean verifyWithP7(byte[] origin, byte[] signatureResult) throws CMSException, IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, SuperException {
        CMSSignedData cMSSignedData = new CMSSignedData(signatureResult);
        SignerInformation signerInformation = (SignerInformation)cMSSignedData.getSignerInfos().getSigners().toArray()[0];
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)((CollectionStore)cMSSignedData.getCertificates()).iterator().next();
        String string = signerInformation.getEncryptionAlgOID();
        SignatureProperties signatureProperties = SignaturePropertiesFactory.build(string, x509CertificateHolder.getEncoded());
        boolean bl2 = SignatureTemplate.verifyWithP1(signerInformation.getEncodedSignedAttributes(), signerInformation.getSignature(), signatureProperties);
        if (!bl2) {
            throw new SignatureVerifyFailureException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u7b7e\u540d\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
        }
        if (origin.length > 0) {
            bl2 = Arrays.equals(origin, (byte[])cMSSignedData.getSignedContent().getContent());
        }
        if (!bl2) {
            throw new SignatureVerifyFailureException("\u9a8c\u8bc1\u5931\u8d25\uff0c\u7b7e\u540d\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
        }
        return true;
    }

    static {
        Security.removeProvider("BC");
        Security.removeProvider("SM");
        SMProvider sMProvider = new SMProvider();
        sMProvider.put("MessageDigest.SM3", SM3.class.getName() + "$Digest");
        sMProvider.put("Alg.Alias.MessageDigest.SM3", "SM3");
        sMProvider.put("Alg.Alias.MessageDigest.1.2.156.197.1.401", "SM3");
        sMProvider.put("Alg.Alias.MessageDigest." + GMObjectIdentifiers.sm3, "SM3");
        Security.addProvider(sMProvider);
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public static class SignatureVerifyFailureException
    extends RuntimeException {
        public SignatureVerifyFailureException(String message) {
            super(message);
        }
    }
}

