/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tech.util;

import com.timevale.esign.paas.tech.bean.bean.TextImageInfoBean;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class SingleLineTextImageGenerator {
    private static final int PADDING_WIDTH = 0;

    public static TextImageInfoBean drawSingleLineTextToImgBase64(DrawSingleLineTextRequest request) {
        float f2 = request.getFontSize() / 72.0f * (float)request.getDpi();
        Font font = request.getFont().deriveFont(f2);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = fontMetrics.stringWidth(request.getText());
        graphics2D.dispose();
        int n4 = n2 + Math.round(0.0f * (float)request.getDpi());
        int n5 = n3 + Math.round(0.0f * (float)request.getDpi());
        BufferedImage bufferedImage2 = new BufferedImage(n5, n4, 2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.setFont(font);
        if (request.isDebug()) {
            graphics2D2.setColor(new Color(255, 0, 0, 255));
        } else {
            graphics2D2.setColor(new Color(0, 0, 0, 0));
        }
        graphics2D2.fillRect(0, 0, n5, n4);
        int n6 = Math.round((float)(n5 - n3) / 2.0f);
        int n7 = Math.round((float)(n4 - n2) / 2.0f + (float)fontMetrics.getAscent());
        graphics2D2.setColor(Color.BLACK);
        graphics2D2.drawString(request.getText(), n6, n7);
        TextImageInfoBean textImageInfoBean = new TextImageInfoBean();
        textImageInfoBean.setImageBase64(SingleLineTextImageGenerator.imageToBase64(bufferedImage2));
        graphics2D2.dispose();
        textImageInfoBean.setWidth((float)n5 / 1.0f);
        textImageInfoBean.setHeight((float)n4 / 1.0f);
        return textImageInfoBean;
    }

    private static String imageToBase64(BufferedImage image) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return Base64.getEncoder().encodeToString(byArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("\u56fe\u7247\u8f6c\u6362\u4e3aBase64\u5931\u8d25", exception);
        }
    }

    public static class DrawSingleLineTextRequest {
        private String text;
        private float fontSize = 12.0f;
        private int dpi = 96;
        private Font font;
        private boolean debug;

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public float getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(float fontSize) {
            this.fontSize = fontSize;
        }

        public int getDpi() {
            return this.dpi;
        }

        public void setDpi(int dpi) {
            this.dpi = dpi;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }
    }
}

