/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.bc;

import com.timevale.esign.paas.tgtext.bouncycastle.cert.crmf.EncryptedValuePadder;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.Digest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.digests.SHA1Digest;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.generators.MGF1BytesGenerator;
import com.timevale.esign.paas.tgtext.bouncycastle.crypto.params.MGFParameters;
import java.security.SecureRandom;

public class BcFixedLengthMGF1Padder
implements EncryptedValuePadder {
    private int length;
    private SecureRandom random;
    private Digest dig = new SHA1Digest();

    public BcFixedLengthMGF1Padder(int n2) {
        this(n2, null);
    }

    public BcFixedLengthMGF1Padder(int n2, SecureRandom secureRandom) {
        this.length = n2;
        this.random = secureRandom;
    }

    @Override
    public byte[] getPaddedData(byte[] byArray) {
        int n2;
        byte[] byArray2 = new byte[this.length];
        byte[] byArray3 = new byte[this.dig.getDigestSize()];
        byte[] byArray4 = new byte[this.length - this.dig.getDigestSize()];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray3);
        MGF1BytesGenerator mGF1BytesGenerator = new MGF1BytesGenerator(this.dig);
        mGF1BytesGenerator.init(new MGFParameters(byArray3));
        mGF1BytesGenerator.generateBytes(byArray4, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, byArray3.length, byArray.length);
        for (n2 = byArray3.length + byArray.length + 1; n2 != byArray2.length; ++n2) {
            byArray2[n2] = (byte)(1 + this.random.nextInt(255));
        }
        for (n2 = 0; n2 != byArray4.length; ++n2) {
            int n3 = n2 + byArray3.length;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray4[n2]);
        }
        return byArray2;
    }

    @Override
    public byte[] getUnpaddedData(byte[] byArray) {
        int n2;
        byte[] byArray2 = new byte[this.dig.getDigestSize()];
        byte[] byArray3 = new byte[this.length - this.dig.getDigestSize()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        MGF1BytesGenerator mGF1BytesGenerator = new MGF1BytesGenerator(this.dig);
        mGF1BytesGenerator.init(new MGFParameters(byArray2));
        mGF1BytesGenerator.generateBytes(byArray3, 0, byArray3.length);
        for (n2 = 0; n2 != byArray3.length; ++n2) {
            int n3 = n2 + byArray2.length;
            byArray[n3] = (byte)(byArray[n3] ^ byArray3[n2]);
        }
        n2 = 0;
        for (int i2 = byArray.length - 1; i2 != byArray2.length; --i2) {
            if (byArray[i2] != 0) continue;
            n2 = i2;
            break;
        }
        if (n2 == 0) {
            throw new IllegalStateException("bad padding in encoding");
        }
        byte[] byArray4 = new byte[n2 - byArray2.length];
        System.arraycopy(byArray, byArray2.length, byArray4, 0, byArray4.length);
        return byArray4;
    }
}

