/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cert.dane;

import com.timevale.esign.paas.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.dane.DANEEntry;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.dane.DANEEntryFetcherFactory;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.dane.DANEEntrySelector;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.dane.DANEEntrySelectorFactory;
import com.timevale.esign.paas.tgtext.bouncycastle.cert.dane.DANEException;
import com.timevale.esign.paas.tgtext.bouncycastle.operator.DigestCalculator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DANECertificateFetcher {
    private final DANEEntryFetcherFactory fetcherFactory;
    private final DANEEntrySelectorFactory selectorFactory;

    public DANECertificateFetcher(DANEEntryFetcherFactory dANEEntryFetcherFactory, DigestCalculator digestCalculator) {
        this.fetcherFactory = dANEEntryFetcherFactory;
        this.selectorFactory = new DANEEntrySelectorFactory(digestCalculator);
    }

    public List fetch(String string) throws DANEException {
        DANEEntrySelector dANEEntrySelector = this.selectorFactory.createSelector(string);
        List list = this.fetcherFactory.build(dANEEntrySelector.getDomainName()).getEntries();
        ArrayList<X509CertificateHolder> arrayList = new ArrayList<X509CertificateHolder>(list.size());
        for (DANEEntry dANEEntry : list) {
            if (!dANEEntrySelector.match(dANEEntry)) continue;
            arrayList.add(dANEEntry.getCertificate());
        }
        return Collections.unmodifiableList(arrayList);
    }
}

