/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cert.selector;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.util.Pack;
import java.io.IOException;

class MSOutlookKeyIdCalculator {
    MSOutlookKeyIdCalculator() {
    }

    static byte[] calculateKeyId(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray2 = new byte[]{};
        try {
            byArray2 = subjectPublicKeyInfo.getEncoded("DER");
        }
        catch (IOException iOException) {
            return new byte[0];
        }
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        return byArray;
    }

    private static abstract class GeneralDigest {
        private static final int BYTE_LENGTH = 64;
        private byte[] xBuf;
        private int xBufOff;
        private long byteCount;

        protected GeneralDigest() {
            this.xBuf = new byte[4];
            this.xBufOff = 0;
        }

        protected GeneralDigest(GeneralDigest generalDigest) {
            this.xBuf = new byte[generalDigest.xBuf.length];
            this.copyIn(generalDigest);
        }

        protected void copyIn(GeneralDigest generalDigest) {
            System.arraycopy(generalDigest.xBuf, 0, this.xBuf, 0, generalDigest.xBuf.length);
            this.xBufOff = generalDigest.xBufOff;
            this.byteCount = generalDigest.byteCount;
        }

        public void update(byte by2) {
            this.xBuf[this.xBufOff++] = by2;
            if (this.xBufOff == this.xBuf.length) {
                this.processWord(this.xBuf, 0);
                this.xBufOff = 0;
            }
            ++this.byteCount;
        }

        public void update(byte[] byArray, int n2, int n3) {
            while (this.xBufOff != 0 && n3 > 0) {
                this.update(byArray[n2]);
                ++n2;
                --n3;
            }
            while (n3 > this.xBuf.length) {
                this.processWord(byArray, n2);
                n2 += this.xBuf.length;
                n3 -= this.xBuf.length;
                this.byteCount += (long)this.xBuf.length;
            }
            while (n3 > 0) {
                this.update(byArray[n2]);
                ++n2;
                --n3;
            }
        }

        public void finish() {
            long l2 = this.byteCount << 3;
            this.update((byte)-128);
            while (this.xBufOff != 0) {
                this.update((byte)0);
            }
            this.processLength(l2);
            this.processBlock();
        }

        public void reset() {
            this.byteCount = 0L;
            this.xBufOff = 0;
            for (int i2 = 0; i2 < this.xBuf.length; ++i2) {
                this.xBuf[i2] = 0;
            }
        }

        protected abstract void processWord(byte[] var1, int var2);

        protected abstract void processLength(long var1);

        protected abstract void processBlock();
    }

    private static class SHA1Digest
    extends GeneralDigest {
        private static final int DIGEST_LENGTH = 20;
        private int H1;
        private int H2;
        private int H3;
        private int H4;
        private int H5;
        private int[] X = new int[80];
        private int xOff;
        private static final int Y1 = 1518500249;
        private static final int Y2 = 1859775393;
        private static final int Y3 = -1894007588;
        private static final int Y4 = -899497514;

        public SHA1Digest() {
            this.reset();
        }

        public String getAlgorithmName() {
            return "SHA-1";
        }

        public int getDigestSize() {
            return 20;
        }

        @Override
        protected void processWord(byte[] byArray, int n2) {
            int n3 = byArray[n2] << 24;
            n3 |= (byArray[++n2] & 0xFF) << 16;
            n3 |= (byArray[++n2] & 0xFF) << 8;
            this.X[this.xOff] = n3 |= byArray[++n2] & 0xFF;
            if (++this.xOff == 16) {
                this.processBlock();
            }
        }

        @Override
        protected void processLength(long l2) {
            if (this.xOff > 14) {
                this.processBlock();
            }
            this.X[14] = (int)(l2 >>> 32);
            this.X[15] = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        }

        public int doFinal(byte[] byArray, int n2) {
            this.finish();
            Pack.intToBigEndian(this.H1, byArray, n2);
            Pack.intToBigEndian(this.H2, byArray, n2 + 4);
            Pack.intToBigEndian(this.H3, byArray, n2 + 8);
            Pack.intToBigEndian(this.H4, byArray, n2 + 12);
            Pack.intToBigEndian(this.H5, byArray, n2 + 16);
            this.reset();
            return 20;
        }

        @Override
        public void reset() {
            super.reset();
            this.H1 = 1732584193;
            this.H2 = -271733879;
            this.H3 = -1732584194;
            this.H4 = 271733878;
            this.H5 = -1009589776;
            this.xOff = 0;
            for (int i2 = 0; i2 != this.X.length; ++i2) {
                this.X[i2] = 0;
            }
        }

        private int f(int n2, int n3, int n4) {
            return n2 & n3 | ~n2 & n4;
        }

        private int h(int n2, int n3, int n4) {
            return n2 ^ n3 ^ n4;
        }

        private int g(int n2, int n3, int n4) {
            return n2 & n3 | n2 & n4 | n3 & n4;
        }

        @Override
        protected void processBlock() {
            int n2;
            int n3;
            int n4;
            for (n4 = 16; n4 < 80; ++n4) {
                n3 = this.X[n4 - 3] ^ this.X[n4 - 8] ^ this.X[n4 - 14] ^ this.X[n4 - 16];
                this.X[n4] = n3 << 1 | n3 >>> 31;
            }
            n4 = this.H1;
            n3 = this.H2;
            int n5 = this.H3;
            int n6 = this.H4;
            int n7 = this.H5;
            int n8 = 0;
            for (n2 = 0; n2 < 4; ++n2) {
                n7 += (n4 << 5 | n4 >>> 27) + this.f(n3, n5, n6) + this.X[n8++] + 1518500249;
                n3 = n3 << 30 | n3 >>> 2;
                n6 += (n7 << 5 | n7 >>> 27) + this.f(n4, n3, n5) + this.X[n8++] + 1518500249;
                n4 = n4 << 30 | n4 >>> 2;
                n5 += (n6 << 5 | n6 >>> 27) + this.f(n7, n4, n3) + this.X[n8++] + 1518500249;
                n7 = n7 << 30 | n7 >>> 2;
                n3 += (n5 << 5 | n5 >>> 27) + this.f(n6, n7, n4) + this.X[n8++] + 1518500249;
                n6 = n6 << 30 | n6 >>> 2;
                n4 += (n3 << 5 | n3 >>> 27) + this.f(n5, n6, n7) + this.X[n8++] + 1518500249;
                n5 = n5 << 30 | n5 >>> 2;
            }
            for (n2 = 0; n2 < 4; ++n2) {
                n7 += (n4 << 5 | n4 >>> 27) + this.h(n3, n5, n6) + this.X[n8++] + 1859775393;
                n3 = n3 << 30 | n3 >>> 2;
                n6 += (n7 << 5 | n7 >>> 27) + this.h(n4, n3, n5) + this.X[n8++] + 1859775393;
                n4 = n4 << 30 | n4 >>> 2;
                n5 += (n6 << 5 | n6 >>> 27) + this.h(n7, n4, n3) + this.X[n8++] + 1859775393;
                n7 = n7 << 30 | n7 >>> 2;
                n3 += (n5 << 5 | n5 >>> 27) + this.h(n6, n7, n4) + this.X[n8++] + 1859775393;
                n6 = n6 << 30 | n6 >>> 2;
                n4 += (n3 << 5 | n3 >>> 27) + this.h(n5, n6, n7) + this.X[n8++] + 1859775393;
                n5 = n5 << 30 | n5 >>> 2;
            }
            for (n2 = 0; n2 < 4; ++n2) {
                n7 += (n4 << 5 | n4 >>> 27) + this.g(n3, n5, n6) + this.X[n8++] + -1894007588;
                n3 = n3 << 30 | n3 >>> 2;
                n6 += (n7 << 5 | n7 >>> 27) + this.g(n4, n3, n5) + this.X[n8++] + -1894007588;
                n4 = n4 << 30 | n4 >>> 2;
                n5 += (n6 << 5 | n6 >>> 27) + this.g(n7, n4, n3) + this.X[n8++] + -1894007588;
                n7 = n7 << 30 | n7 >>> 2;
                n3 += (n5 << 5 | n5 >>> 27) + this.g(n6, n7, n4) + this.X[n8++] + -1894007588;
                n6 = n6 << 30 | n6 >>> 2;
                n4 += (n3 << 5 | n3 >>> 27) + this.g(n5, n6, n7) + this.X[n8++] + -1894007588;
                n5 = n5 << 30 | n5 >>> 2;
            }
            for (n2 = 0; n2 <= 3; ++n2) {
                n7 += (n4 << 5 | n4 >>> 27) + this.h(n3, n5, n6) + this.X[n8++] + -899497514;
                n3 = n3 << 30 | n3 >>> 2;
                n6 += (n7 << 5 | n7 >>> 27) + this.h(n4, n3, n5) + this.X[n8++] + -899497514;
                n4 = n4 << 30 | n4 >>> 2;
                n5 += (n6 << 5 | n6 >>> 27) + this.h(n7, n4, n3) + this.X[n8++] + -899497514;
                n7 = n7 << 30 | n7 >>> 2;
                n3 += (n5 << 5 | n5 >>> 27) + this.h(n6, n7, n4) + this.X[n8++] + -899497514;
                n6 = n6 << 30 | n6 >>> 2;
                n4 += (n3 << 5 | n3 >>> 27) + this.h(n5, n6, n7) + this.X[n8++] + -899497514;
                n5 = n5 << 30 | n5 >>> 2;
            }
            this.H1 += n4;
            this.H2 += n3;
            this.H3 += n5;
            this.H4 += n6;
            this.H5 += n7;
            this.xOff = 0;
            for (n2 = 0; n2 < 16; ++n2) {
                this.X[n2] = 0;
            }
        }
    }
}

