/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.paas.tgtext.bouncycastle.cms;

import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.OriginatorPublicKey;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.RecipientEncryptedKey;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.cms.RecipientKeyIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import com.timevale.esign.paas.tgtext.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.AuthAttributesProvider;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSException;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.CMSSecureReadable;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.KeyAgreeRecipient;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.KeyAgreeRecipientId;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.OriginatorId;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.Recipient;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.RecipientId;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.RecipientInformation;
import com.timevale.esign.paas.tgtext.bouncycastle.cms.RecipientOperator;
import java.io.IOException;
import java.util.List;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString encryptedKey;

    static void readRecipientInfo(List list, KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        ASN1Sequence aSN1Sequence = keyAgreeRecipientInfo.getRecipientEncryptedKeys();
        for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
            KeyAgreeRecipientId keyAgreeRecipientId;
            RecipientEncryptedKey recipientEncryptedKey = RecipientEncryptedKey.getInstance(aSN1Sequence.getObjectAt(i2));
            KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier = recipientEncryptedKey.getIdentifier();
            IssuerAndSerialNumber issuerAndSerialNumber = keyAgreeRecipientIdentifier.getIssuerAndSerialNumber();
            if (issuerAndSerialNumber != null) {
                keyAgreeRecipientId = new KeyAgreeRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
            } else {
                RecipientKeyIdentifier recipientKeyIdentifier = keyAgreeRecipientIdentifier.getRKeyID();
                keyAgreeRecipientId = new KeyAgreeRecipientId(recipientKeyIdentifier.getSubjectKeyIdentifier().getOctets());
            }
            list.add(new KeyAgreeRecipientInformation(keyAgreeRecipientInfo, keyAgreeRecipientId, recipientEncryptedKey.getEncryptedKey(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider));
        }
    }

    KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, RecipientId recipientId, ASN1OctetString aSN1OctetString, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyAgreeRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyAgreeRecipientInfo;
        this.rid = recipientId;
        this.encryptedKey = aSN1OctetString;
    }

    private SubjectPublicKeyInfo getSenderPublicKeyInfo(AlgorithmIdentifier algorithmIdentifier, OriginatorIdentifierOrKey originatorIdentifierOrKey) throws CMSException, IOException {
        OriginatorId originatorId;
        OriginatorPublicKey originatorPublicKey = originatorIdentifierOrKey.getOriginatorKey();
        if (originatorPublicKey != null) {
            return this.getPublicKeyInfoFromOriginatorPublicKey(algorithmIdentifier, originatorPublicKey);
        }
        IssuerAndSerialNumber issuerAndSerialNumber = originatorIdentifierOrKey.getIssuerAndSerialNumber();
        if (issuerAndSerialNumber != null) {
            originatorId = new OriginatorId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        } else {
            SubjectKeyIdentifier subjectKeyIdentifier = originatorIdentifierOrKey.getSubjectKeyIdentifier();
            originatorId = new OriginatorId(subjectKeyIdentifier.getKeyIdentifier());
        }
        return this.getPublicKeyInfoFromOriginatorId(originatorId);
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorPublicKey(AlgorithmIdentifier algorithmIdentifier, OriginatorPublicKey originatorPublicKey) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, originatorPublicKey.getPublicKey().getBytes());
        return subjectPublicKeyInfo;
    }

    private SubjectPublicKeyInfo getPublicKeyInfoFromOriginatorId(OriginatorId originatorId) throws CMSException {
        throw new CMSException("No support for 'originator' as IssuerAndSerialNumber or SubjectKeyIdentifier");
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        KeyAgreeRecipient keyAgreeRecipient = (KeyAgreeRecipient)recipient;
        AlgorithmIdentifier algorithmIdentifier = keyAgreeRecipient.getPrivateKeyAlgorithmIdentifier();
        return ((KeyAgreeRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.getSenderPublicKeyInfo(algorithmIdentifier, this.info.getOriginator()), this.info.getUserKeyingMaterial(), this.encryptedKey.getOctets());
    }
}

